/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistAsyncFuncTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.topologyaware.TopologyAwareDistAsyncFuncTest")
public class TopologyAwareDistAsyncFuncTest
extends DistAsyncFuncTest {
    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        String machine;
        String rack;
        int index = this.cacheManagers.size();
        switch (index) {
            case 0: {
                rack = "r0";
                machine = "m0";
                break;
            }
            case 1: {
                rack = "r1";
                machine = "m0";
                break;
            }
            case 2: {
                rack = "r1";
                machine = "m0";
                break;
            }
            case 3: {
                rack = "r1";
                machine = "m1";
                break;
            }
            default: {
                throw new RuntimeException("Bad!");
            }
        }
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().rackId(rack).machineId(machine);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(gcb, TopologyAwareDistAsyncFuncTest.getDefaultClusteredCacheConfig(CacheMode.DIST_ASYNC), flags);
        this.cacheManagers.add(cm);
        return cm;
    }
}

