/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.List;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.TopologyAwareSyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyAwareConsistentHashFactoryTest;
import org.infinispan.distribution.topologyaware.TopologyAwareOwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.topologyaware.TopologyAwareSyncConsistentHashFactoryTest")
public class TopologyAwareSyncConsistentHashFactoryTest
extends TopologyAwareConsistentHashFactoryTest {
    private final Log log = LogFactory.getLog(TopologyAwareSyncConsistentHashFactoryTest.class);

    @Override
    protected ConsistentHashFactory<DefaultConsistentHash> createConsistentHashFactory() {
        return new TopologyAwareSyncConsistentHashFactory();
    }

    @Override
    protected void assertDistribution(List<Address> currentMembers, int numOwners, int numSegments) {
        TopologyAwareOwnershipStatistics stats = new TopologyAwareOwnershipStatistics(this.ch);
        this.log.tracef("Ownership stats: " + stats, new Object[0]);
        for (Address node : currentMembers) {
            float expectedPrimarySegments = stats.computeExpectedPrimarySegments(node);
            float expectedOwnedSegments = stats.computeExpectedOwnedSegments(node);
            int primaryOwned = stats.getPrimaryOwned(node);
            int owned = stats.getOwned(node);
            Assert.assertTrue((Math.floor(0.7 * (double)expectedPrimarySegments) <= (double)primaryOwned ? 1 : 0) != 0);
            Assert.assertTrue(((double)primaryOwned <= Math.ceil(1.2 * (double)expectedPrimarySegments) ? 1 : 0) != 0);
            Assert.assertTrue((Math.floor(0.7 * (double)expectedOwnedSegments) <= (double)owned ? 1 : 0) != 0);
            Assert.assertTrue(((double)owned <= Math.ceil(1.2 * (double)expectedOwnedSegments) ? 1 : 0) != 0);
        }
    }
}

