/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.impl.DistributionManagerImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.topologyaware.TopologyInfoBroadcastTest")
public class TopologyInfoBroadcastTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder gc1 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.updatedSiteInfo(gc1, "s0", "r0", "m0");
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(gc1, this.getClusterConfig());
        this.cacheManagers.add(cm1);
        GlobalConfigurationBuilder gc2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.updatedSiteInfo(gc2, "s1", "r1", "m1");
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(gc2, this.getClusterConfig());
        this.cacheManagers.add(cm2);
        GlobalConfigurationBuilder gc3 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.updatedSiteInfo(gc3, "s2", "r2", "m2");
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager(gc3, this.getClusterConfig());
        this.cacheManagers.add(cm3);
        log.info((Object)"Here it starts");
        this.waitForClusterToForm();
        log.info((Object)"Here it ends");
    }

    protected ConfigurationBuilder getClusterConfig() {
        return TopologyInfoBroadcastTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
    }

    private void updatedSiteInfo(GlobalConfigurationBuilder gcb, String s, String r, String m) {
        gcb.transport().siteId(s).rackId(r).machineId(m);
    }

    public void testIsReplicated() {
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        log.trace((Object)("distributionManager.ConsistentHash() = " + dmi.getWriteConsistentHash()));
        this.assertTopologyInfo3Nodes(dmi.getWriteConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(1).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getWriteConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getWriteConsistentHash().getMembers());
        ConsistentHash tach0 = this.advancedCache(0).getDistributionManager().getWriteConsistentHash();
        ConsistentHash tach1 = this.advancedCache(1).getDistributionManager().getWriteConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach1.getMembers());
        ConsistentHash tach2 = this.advancedCache(2).getDistributionManager().getWriteConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach2.getMembers());
    }

    @Test(dependsOnMethods={"testIsReplicated"})
    public void testNodeLeaves() {
        TestingUtil.killCacheManagers(this.manager(1));
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0), this.cache(2));
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(2));
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getWriteConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getWriteConsistentHash().getMembers());
        ConsistentHash tach0 = this.advancedCache(0).getDistributionManager().getWriteConsistentHash();
        ConsistentHash tach2 = this.advancedCache(2).getDistributionManager().getWriteConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach2.getMembers());
    }

    private void assertTopologyInfo3Nodes(List<Address> caches) {
        this.assertTopologyInfo2Nodes(Arrays.asList(caches.get(0), caches.get(2)));
        TopologyAwareAddress address1 = (TopologyAwareAddress)caches.get(1);
        Assert.assertEquals((String)address1.getSiteId(), (String)"s1");
        Assert.assertEquals((String)address1.getRackId(), (String)"r1");
        Assert.assertEquals((String)address1.getMachineId(), (String)"m1");
    }

    private void assertTopologyInfo2Nodes(List<Address> caches) {
        TopologyAwareAddress address0 = (TopologyAwareAddress)caches.get(0);
        Assert.assertEquals((String)address0.getSiteId(), (String)"s0");
        Assert.assertEquals((String)address0.getRackId(), (String)"r0");
        Assert.assertEquals((String)address0.getMachineId(), (String)"m0");
        TopologyAwareAddress address2 = (TopologyAwareAddress)caches.get(1);
        Assert.assertEquals((String)address2.getSiteId(), (String)"s2");
        Assert.assertEquals((String)address2.getRackId(), (String)"r2");
        Assert.assertEquals((String)address2.getMachineId(), (String)"m2");
    }
}

