/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionFunctionalTest")
public class EvictionFunctionalTest
extends SingleCacheManagerTest {
    private static final int CACHE_SIZE = 64;
    private StorageType storageType;
    private EvictionListener evictionListener;
    private ControlledTimeService timeService;

    protected EvictionFunctionalTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public EvictionFunctionalTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new EvictionFunctionalTest().storageType(StorageType.BINARY), new EvictionFunctionalTest().storageType(StorageType.OBJECT), new EvictionFunctionalTest().storageType(StorageType.OFF_HEAP)};
    }

    @Override
    protected String parameters() {
        return "[" + this.storageType + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.memory().size(64L).storageType(this.getStorageType()).expiration().wakeUpInterval(100L).locking().useLockStriping(false).invocationBatching();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        this.cache = cm.getCache();
        this.evictionListener = new EvictionListener();
        this.cache.addListener((Object)this.evictionListener);
        this.timeService = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        return cm;
    }

    public void testSimpleEvictionMaxEntries() throws Exception {
        int i;
        for (i = 0; i < 128; ++i) {
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)));
        }
        AssertJUnit.assertEquals((String)("cache size too big: " + this.cache.size()), (int)64, (int)this.cache.size());
        AssertJUnit.assertEquals((String)("eviction events count should be same with case size: " + this.evictionListener.getEvictedEvents()), (int)64, (int)this.evictionListener.getEvictedEvents().size());
        for (i = 0; i < 64; ++i) {
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)));
        }
        AssertJUnit.assertEquals((int)64, (int)this.cache.size());
        AssertJUnit.assertTrue((this.evictionListener.evictedEntries.size() > 64 ? 1 : 0) != 0);
    }

    public void testEvictNonExistantEntry() {
        String key = "key";
        String value = "some-value";
        this.cache.put((Object)key, (Object)value);
        this.cache.evict((Object)key);
        AssertJUnit.assertEquals((int)1, (int)this.evictionListener.evictedEntries.size());
        this.cache.evict((Object)key);
        AssertJUnit.assertEquals((int)2, (int)this.evictionListener.evictedEntries.size());
    }

    public void testSimpleExpirationMaxIdle() throws Exception {
        for (int i = 0; i < 128; ++i) {
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)), 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(1000L);
        this.cache.getAdvancedCache().getExpirationManager().processExpiration();
        assert (0 == this.cache.size()) : "cache size should be zero: " + this.cache.size();
    }

    public void testEvictionNotificationSkipped() {
        String key = "key";
        String value = "value";
        this.cache.put((Object)key, (Object)value);
        this.cache.getAdvancedCache().withFlags(Flag.SKIP_LISTENER_NOTIFICATION).evict((Object)key);
        AssertJUnit.assertEquals((int)0, (int)this.evictionListener.getEvictedEvents().size());
    }

    @Listener
    public static class EvictionListener {
        private List<Map.Entry> evictedEntries = Collections.synchronizedList(new ArrayList());

        @CacheEntriesEvicted
        public void nodeEvicted(CacheEntriesEvictedEvent e) {
            assert (e.isPre() || !e.isPre());
            Object key = e.getEntries().keySet().iterator().next();
            assert (key != null);
            assert (e.getCache() != null);
            assert (e.getType() == Event.Type.CACHE_ENTRY_EVICTED);
            e.getEntries().entrySet().stream().forEach(entry -> this.evictedEntries.add((Map.Entry)entry));
        }

        public List<Map.Entry> getEvictedEvents() {
            return this.evictedEntries;
        }
    }
}

