/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.impl.AbstractDelegatingInternalDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.impl.EvictionWithConcurrentOperationsSCIImpl;
import org.infinispan.eviction.impl.EvictionWithConcurrentOperationsTest;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.ManualEvictionWithSizeBasedAndConcurrentOperationsInPrimaryOwnerTest", singleThreaded=true)
public class ManualEvictionWithSizeBasedAndConcurrentOperationsInPrimaryOwnerTest
extends EvictionWithConcurrentOperationsTest {
    protected EmbeddedCacheManager otherCacheManager;

    @AfterMethod(alwaysRun=true)
    public void stopSecondCacheManager() {
        if (this.otherCacheManager != null) {
            this.otherCacheManager.getCache().stop();
            this.otherCacheManager.stop();
            this.otherCacheManager = null;
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void startSecondCacheManager() throws Exception {
        if (this.otherCacheManager == null) {
            this.otherCacheManager = this.createCacheManager();
        } else {
            AssertJUnit.fail((String)"Other cache manager should not be set!");
        }
        Cache otherCache = this.otherCacheManager.getCache();
        TestingUtil.waitForNoRebalance(this.cache, otherCache);
    }

    @Override
    public void testScenario1() throws Exception {
        Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        AfterPassivationOrCacheWriter controller = new AfterPassivationOrCacheWriter().injectThis((Cache<Object, Object>)this.cache);
        EvictionWithConcurrentOperationsTest.Latch latch = new EvictionWithConcurrentOperationsTest.Latch(this);
        controller.beforeEvict = () -> latch.blockIfNeeded();
        latch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        latch.waitToBlock(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)this.cache.get(key1));
        latch.disable();
        evict.get(30L, TimeUnit.SECONDS);
        this.assertNotInMemory(key1, "v1");
    }

    @Override
    public void testScenario2() throws Exception {
        Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        EvictionWithConcurrentOperationsTest.Latch latch = new EvictionWithConcurrentOperationsTest.Latch(this);
        this.replaceControlledDataContainer(latch);
        latch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        latch.waitToBlock(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)this.cache.get(key1));
        latch.disable();
        evict.get(30L, TimeUnit.SECONDS);
        this.assertNotInMemory(key1, "v1");
    }

    @Override
    public void testScenario3() throws Exception {
        final Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        final EvictionWithConcurrentOperationsTest.Latch latch = new EvictionWithConcurrentOperationsTest.Latch(this);
        EvictionWithConcurrentOperationsTest.SyncEvictionListener evictionListener = new EvictionWithConcurrentOperationsTest.SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    latch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        latch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        latch.waitToBlock(30L, TimeUnit.SECONDS);
        if (this.passivation) {
            Future<Object> getFuture = this.fork(() -> this.cache.get(key1));
            TestingUtil.assertNotDone(getFuture);
            latch.disable();
            evict.get(30L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((Object)"v1", (Object)getFuture.get(10L, TimeUnit.SECONDS));
            this.assertInMemory(key1, "v1");
        } else {
            AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)this.cache.get(key1));
            latch.disable();
            evict.get(30L, TimeUnit.SECONDS);
            this.assertInMemory(key1, "v1");
        }
    }

    @Override
    public void testScenario4() throws Exception {
        final Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        EvictionWithConcurrentOperationsTest.Latch readLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        final EvictionWithConcurrentOperationsTest.Latch writeLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        AtomicBoolean firstGet = new AtomicBoolean(false);
        EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor(this).injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> {
            if (firstGet.compareAndSet(false, true)) {
                readLatch.blockIfNeeded();
            }
        };
        EvictionWithConcurrentOperationsTest.SyncEvictionListener evictionListener = new EvictionWithConcurrentOperationsTest.SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
        Future<Object> get = this.fork(() -> this.cache.get(key1));
        readLatch.waitToBlock(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)this.cache.get(key1));
        writeLatch.disable();
        evict.get(30L, TimeUnit.SECONDS);
        readLatch.disable();
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)get.get(30L, TimeUnit.SECONDS));
        this.assertInMemory(key1, "v1");
    }

    @Override
    public void testScenario5() throws Exception {
        final Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        EvictionWithConcurrentOperationsTest.Latch readLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        final EvictionWithConcurrentOperationsTest.Latch writeLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor(this).injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> readLatch.blockIfNeeded();
        EvictionWithConcurrentOperationsTest.SyncEvictionListener evictionListener = new EvictionWithConcurrentOperationsTest.SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
        Future<Object> get = this.fork(() -> this.cache.get(key1));
        readLatch.waitToBlock(30L, TimeUnit.SECONDS);
        writeLatch.disable();
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in put operation."), (Object)"v1", (Object)this.cache.put(key1, (Object)"v3"));
        evict.get(30L, TimeUnit.SECONDS);
        readLatch.disable();
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v3", (Object)get.get(30L, TimeUnit.SECONDS));
        this.assertInMemory(key1, "v3");
    }

    @Override
    public void testScenario6() throws Exception {
        final Object key1 = this.createSameHashCodeKey("key1");
        this.initializeKeyAndCheckData(key1, "v1");
        EvictionWithConcurrentOperationsTest.Latch readLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        final EvictionWithConcurrentOperationsTest.Latch writeLatch = new EvictionWithConcurrentOperationsTest.Latch(this);
        EvictionWithConcurrentOperationsTest.Latch writeLatch2 = new EvictionWithConcurrentOperationsTest.Latch(this);
        EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor afterEntryWrappingInterceptor = new EvictionWithConcurrentOperationsTest.AfterEntryWrappingInterceptor(this).injectThis((Cache<Object, Object>)this.cache);
        afterEntryWrappingInterceptor.beforeGet = () -> readLatch.blockIfNeeded();
        afterEntryWrappingInterceptor.afterPut = () -> writeLatch2.blockIfNeeded();
        EvictionWithConcurrentOperationsTest.SyncEvictionListener evictionListener = new EvictionWithConcurrentOperationsTest.SyncEvictionListener(){

            @Override
            @CacheEntriesEvicted
            public void evicted(CacheEntriesEvictedEvent event) {
                if (event.getEntries().containsKey(key1)) {
                    writeLatch.blockIfNeeded();
                }
            }
        };
        this.cache.addListener((Object)evictionListener);
        readLatch.enable();
        Future<Void> evict = this.evictWithFuture(key1);
        writeLatch.waitToBlock(30L, TimeUnit.SECONDS);
        Future<Object> get = this.fork(() -> this.cache.get(key1));
        readLatch.waitToBlock(30L, TimeUnit.SECONDS);
        writeLatch.disable();
        Future<Object> put2 = this.fork(() -> this.cache.put(key1, (Object)"v3"));
        evict.get(30L, TimeUnit.SECONDS);
        writeLatch2.waitToBlock(30L, TimeUnit.SECONDS);
        readLatch.disable();
        this.assertPossibleValues(key1, get.get(30L, TimeUnit.SECONDS), "v1", "v3");
        writeLatch2.disable();
        AssertJUnit.assertEquals((String)("Wrong value for key " + key1 + " in get operation."), (Object)"v1", (Object)put2.get(30L, TimeUnit.SECONDS));
        this.assertInMemory(key1, "v3");
    }

    @Override
    protected void configurePersistence(ConfigurationBuilder builder) {
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.storeName + this.storeNamePrefix.getAndIncrement());
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(2).numSegments(2);
        this.configurePersistence(builder);
        this.configureEviction(builder);
        return TestCacheManagerFactory.createClusteredCacheManager(new EvictionWithConcurrentOperationsSCIImpl(), builder);
    }

    protected Object createSameHashCodeKey(String name) {
        Address address = this.cache.getAdvancedCache().getRpcManager().getAddress();
        DistributionManager distributionManager = this.cache.getAdvancedCache().getDistributionManager();
        int hashCode = 0;
        EvictionWithConcurrentOperationsTest.SameHashCodeKey key = new EvictionWithConcurrentOperationsTest.SameHashCodeKey(name, hashCode);
        while (!distributionManager.getCacheTopology().getDistribution((Object)key).primary().equals(address)) {
            key = new EvictionWithConcurrentOperationsTest.SameHashCodeKey(name, ++hashCode);
        }
        return key;
    }

    protected final Future<Void> evictWithFuture(Object key) {
        return this.fork(() -> {
            this.cache.evict(key);
            return null;
        });
    }

    private void replaceControlledDataContainer(final EvictionWithConcurrentOperationsTest.Latch latch) {
        final InternalDataContainer current = TestingUtil.extractComponent(this.cache, InternalDataContainer.class);
        AbstractDelegatingInternalDataContainer controlledDataContainer = new AbstractDelegatingInternalDataContainer(){

            protected InternalDataContainer delegate() {
                return current;
            }

            public void evict(Object key) {
                latch.blockIfNeeded();
                super.evict(key);
            }

            public CompletionStage<Void> evict(int segment, Object key) {
                latch.blockIfNeeded();
                return super.evict(segment, key);
            }
        };
        TestingUtil.replaceComponent(this.cache, InternalDataContainer.class, controlledDataContainer, true);
    }

    class AfterPassivationOrCacheWriter
    extends EvictionWithConcurrentOperationsTest.ControlledCommandInterceptor {
        volatile Runnable beforeEvict;
        volatile Runnable afterEvict;

        AfterPassivationOrCacheWriter() {
            super(ManualEvictionWithSizeBasedAndConcurrentOperationsInPrimaryOwnerTest.this);
        }

        public AfterPassivationOrCacheWriter injectThis(Cache<Object, Object> injectInCache) {
            AsyncInterceptorChain chain = TestingUtil.extractComponent(injectInCache, AsyncInterceptorChain.class);
            AsyncInterceptor interceptor = chain.findInterceptorExtending(CacheWriterInterceptor.class);
            if (interceptor == null) {
                interceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
            }
            if (interceptor == null) {
                throw new IllegalStateException("Should not happen!");
            }
            chain.addInterceptorAfter((AsyncInterceptor)this, interceptor.getClass());
            return this;
        }

        public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, this.beforeEvict, this.afterEvict);
        }
    }
}

