/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.CountMarshallingPojo;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.MarshalledValuesManualEvictionTest")
public class MarshalledValuesManualEvictionTest
extends SingleCacheManagerTest {
    public static final String POJO_NAME = MarshalledValuesManualEvictionTest.class.getName();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().storageType(StorageType.BINARY);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(TestDataSCI.INSTANCE, cfg);
        this.cache = cm.getCache();
        return cm;
    }

    public void testManualEvictCustomKeyValue() {
        CountMarshallingPojo.reset(POJO_NAME);
        CountMarshallingPojo p1 = new CountMarshallingPojo(POJO_NAME, 64);
        CountMarshallingPojo p2 = new CountMarshallingPojo(POJO_NAME, 24);
        CountMarshallingPojo p3 = new CountMarshallingPojo(POJO_NAME, 97);
        CountMarshallingPojo p4 = new CountMarshallingPojo(POJO_NAME, 35);
        this.cache.put((Object)p1, (Object)p2);
        this.cache.put((Object)p3, (Object)p4);
        AssertJUnit.assertEquals((int)2, (int)this.cache.size());
        this.cache.evict((Object)p1);
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
        AssertJUnit.assertEquals((Object)p4, (Object)this.cache.get((Object)p3));
        AssertJUnit.assertEquals((int)6, (int)CountMarshallingPojo.getMarshallCount(POJO_NAME));
        AssertJUnit.assertEquals((int)1, (int)CountMarshallingPojo.getUnmarshallCount(POJO_NAME));
    }

    public void testEvictPrimitiveKeyCustomValue() {
        CountMarshallingPojo.reset(POJO_NAME);
        CountMarshallingPojo p1 = new CountMarshallingPojo(POJO_NAME, 51);
        CountMarshallingPojo p2 = new CountMarshallingPojo(POJO_NAME, 78);
        this.cache.put((Object)"key-isoprene", (Object)p1);
        this.cache.put((Object)"key-hexastyle", (Object)p2);
        AssertJUnit.assertEquals((int)2, (int)this.cache.size());
        this.cache.evict((Object)"key-isoprene");
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
        AssertJUnit.assertEquals((Object)p2, (Object)this.cache.get((Object)"key-hexastyle"));
        AssertJUnit.assertEquals((int)2, (int)CountMarshallingPojo.getMarshallCount(POJO_NAME));
        AssertJUnit.assertEquals((int)1, (int)CountMarshallingPojo.getUnmarshallCount(POJO_NAME));
    }
}

