/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.eviction.EvictionType;
import org.infinispan.eviction.impl.protostream.PrimitiveArrayCtx;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.MemoryBasedEvictionFunctionalTest")
public class MemoryBasedEvictionFunctionalTest
extends SingleCacheManagerTest {
    protected static final long CACHE_SIZE = 2000L;
    protected StorageType storageType;

    public MemoryBasedEvictionFunctionalTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    protected void configure(ConfigurationBuilder cb) {
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.memory().evictionType(EvictionType.MEMORY).storageType(this.storageType);
        if (this.storageType == StorageType.BINARY) {
            builder.memory().size(2000L);
        } else {
            builder.memory().size(2000L + UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)2048L));
        }
        this.configure(builder);
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        SerializationConfigurationBuilder serialization = globalBuilder.serialization();
        serialization.addContextInitializer((SerializationContextInitializer)new PrimitiveArrayCtx());
        serialization.addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
        this.cache = cm.getCache();
        return cm;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new MemoryBasedEvictionFunctionalTest().storageType(StorageType.BINARY), new MemoryBasedEvictionFunctionalTest().storageType(StorageType.OFF_HEAP)};
    }

    @Override
    protected String parameters() {
        return "[storageType=" + this.storageType + "]";
    }

    public void testByteArray() throws Exception {
        int keyValueByteSize = 100;
        long numberInserted = 1000L / (long)keyValueByteSize;
        Random random = new Random();
        for (long i = 0L; i < numberInserted; ++i) {
            byte[] key = new byte[keyValueByteSize];
            byte[] value = new byte[keyValueByteSize];
            random.nextBytes(key);
            random.nextBytes(value);
            this.cache.put((Object)key, (Object)value);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testByteObjectArray() throws Exception {
        int keyValueByteSize = 100;
        long numberInserted = 1000L / (long)keyValueByteSize;
        Random random = new Random();
        for (long i = 0L; i < numberInserted; ++i) {
            byte[] key = new byte[keyValueByteSize];
            Byte[] value = new Byte[keyValueByteSize];
            this.fillByteArray(random, key);
            this.fillByteArray(random, value);
            this.cache.put((Object)key, (Object)value);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    private void fillByteArray(Random random, byte[] bytes) {
        random.nextBytes(bytes);
    }

    private void fillByteArray(Random random, Byte[] bytes) {
        byte[] singleByte = new byte[1];
        for (int i = 0; i < bytes.length; ++i) {
            random.nextBytes(singleByte);
            bytes[i] = singleByte[0];
        }
    }

    public void testShort() throws Exception {
        long numberInserted = 1000L;
        Random random = new Random();
        short i = 0;
        while ((long)i < numberInserted) {
            this.cache.put((Object)i, (Object)((short)random.nextInt(32768)));
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testShortArray() throws Exception {
        int arraySize = 10;
        long numberInserted = 1000L / (long)arraySize;
        Random random = new Random();
        short[] shortArray = new short[arraySize];
        Short[] ShortArray = new Short[arraySize];
        int i = 0;
        while ((long)i < numberInserted) {
            IntStream.range(0, arraySize).forEach(j -> {
                shortArray[j] = (short)random.nextInt(Short.MAX_VALUE);
            });
            Arrays.setAll(ShortArray, j -> (short)random.nextInt(Short.MAX_VALUE));
            this.cache.put((Object)shortArray, (Object)ShortArray);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testInteger() throws Exception {
        long numberInserted = 250L;
        Random random = new Random();
        int i = 0;
        while ((long)i < numberInserted) {
            this.cache.put((Object)i, (Object)random.nextInt());
            ++i;
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testIntegerArray() throws Exception {
        int arraySize = 10;
        long numberInserted = 500L / (long)arraySize;
        Random random = new Random();
        int[] integerArray = new int[arraySize];
        Integer[] IntegerArray = new Integer[arraySize];
        int i = 0;
        while ((long)i < numberInserted) {
            Arrays.setAll(integerArray, j -> random.nextInt());
            Arrays.setAll(IntegerArray, j -> random.nextInt());
            this.cache.put((Object)integerArray, (Object)IntegerArray);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testLong() throws Exception {
        long numberInserted = 500L;
        Random random = new Random();
        for (long i = 0L; i < numberInserted; ++i) {
            this.cache.put((Object)i, (Object)random.nextLong());
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testLongArray() throws Exception {
        int arraySize = 10;
        long numberInserted = 250L / (long)arraySize;
        Random random = new Random();
        long[] longArray = new long[arraySize];
        Long[] LongArray = new Long[arraySize];
        int i = 0;
        while ((long)i < numberInserted) {
            Arrays.setAll(longArray, j -> random.nextLong());
            Arrays.setAll(LongArray, j -> random.nextLong());
            this.cache.put((Object)longArray, (Object)LongArray);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testByte() throws Exception {
        long numberInserted = 1000L;
        Random random = new Random();
        byte[] bytes = new byte[1];
        short i = 0;
        while ((long)i < numberInserted) {
            random.nextBytes(bytes);
            this.cache.put((Object)i, (Object)bytes[0]);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testByteObject() throws Exception {
        long numberInserted = 1000L;
        Random random = new Random();
        byte[] bytes = new byte[1];
        short i = 0;
        while ((long)i < numberInserted) {
            random.nextBytes(bytes);
            this.cache.put((Object)i, (Object)bytes[0]);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testFloat() throws Exception {
        long numberInserted = 500L;
        Random random = new Random();
        for (float i = 0.0f; i < (float)numberInserted; i += 1.0f) {
            this.cache.put((Object)Float.valueOf(i), (Object)Float.valueOf(random.nextFloat()));
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testDouble() throws Exception {
        long numberInserted = 250L;
        Random random = new Random();
        for (double i = 0.0; i < (double)numberInserted; i += 1.0) {
            this.cache.put((Object)i, (Object)random.nextDouble());
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testDoubleArray() throws Exception {
        int arraySize = 10;
        long numberInserted = 250L / (long)arraySize;
        Random random = new Random();
        double[] doubleArray = new double[arraySize];
        Double[] DoubleArray = new Double[arraySize];
        int i = 0;
        while ((long)i < numberInserted) {
            Arrays.setAll(doubleArray, j -> random.nextDouble());
            Arrays.setAll(DoubleArray, j -> random.nextDouble());
            this.cache.put((Object)doubleArray, (Object)DoubleArray);
            i = (short)(i + 1);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testString() throws Exception {
        int stringLength = 10;
        long numberInserted = 2000L / (long)stringLength + 4L;
        Random random = new Random();
        for (long i = 0L; i < numberInserted; ++i) {
            this.cache.put((Object)i, (Object)this.randomStringFullOfInt(random, stringLength));
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    public void testStringArray() throws Exception {
        int arraySize = 10;
        int stringLength = 10;
        long numberInserted = 2000L / (long)stringLength + (long)(4 / arraySize);
        Random random = new Random();
        String[] stringArray = new String[arraySize];
        AtomicInteger atomicInteger = new AtomicInteger();
        for (long i = 0L; i < numberInserted; ++i) {
            atomicInteger.set(0);
            Arrays.setAll(stringArray, j -> this.randomStringFullOfInt(random, stringLength));
            this.cache.put((Object)i, (Object)stringArray);
        }
        AssertJUnit.assertTrue(((long)this.cache.getAdvancedCache().getDataContainer().size() < numberInserted ? 1 : 0) != 0);
    }

    protected String randomStringFullOfInt(Random random, int digits) {
        return random.ints(digits, 0, 10).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }
}

