/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.context.Flag;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ClusterExpirationLifespanTest")
public class ClusterExpirationLifespanTest
extends MultipleCacheManagersTest {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;
    protected ControlledTimeService ts2;
    protected Cache<Object, String> cache0;
    protected Cache<Object, String> cache1;
    protected Cache<Object, String> cache2;
    protected ConfigurationBuilder configurationBuilder;

    @Override
    public Object[] factory() {
        return Arrays.stream(StorageType.values()).flatMap(type -> Stream.builder().add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(false)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(false)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.SCATTERED_SYNC).transactional(false)).build()).toArray();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = new ConfigurationBuilder();
        this.configurationBuilder.clustering().cacheMode(this.cacheMode);
        this.configurationBuilder.transaction().transactionMode(this.transactionMode()).lockingMode(this.lockingMode);
        this.configurationBuilder.expiration().disableReaper();
        if (this.storageType != null) {
            this.configurationBuilder.memory().storage(this.storageType);
        }
        this.createCluster(TestDataSCI.INSTANCE, this.configurationBuilder, 3);
        this.waitForClusterToForm();
        this.injectTimeServices();
        this.cache0 = this.cache(0);
        this.cache1 = this.cache(1);
        this.cache2 = this.cache(2);
    }

    protected void injectTimeServices() {
        this.ts0 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.ts0, true);
        this.ts1 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.ts1, true);
        this.ts2 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(2), TimeService.class, this.ts2, true);
    }

    public void testLifespanExpiredOnPrimaryOwner() throws Exception {
        this.testLifespanExpiredEntryRetrieval(this.cache0, this.cache1, this.ts0, true);
    }

    public void testLifespanExpiredOnBackupOwner() throws Exception {
        this.testLifespanExpiredEntryRetrieval(this.cache0, this.cache1, this.ts1, false);
    }

    private void testLifespanExpiredEntryRetrieval(Cache<Object, String> primaryOwner, Cache<Object, String> backupOwner, ControlledTimeService timeService, boolean expireOnPrimary) throws Exception {
        AdvancedCache otherCache;
        Cache<Object, String> expiredCache;
        Object key = this.createKey(primaryOwner, (Cache<Object, String>)backupOwner);
        primaryOwner.put(key, (Object)key.toString(), 10L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)primaryOwner.get(key)));
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)backupOwner.get(key)));
        timeService.advance(11L);
        if (expireOnPrimary) {
            expiredCache = primaryOwner;
            otherCache = backupOwner;
        } else {
            expiredCache = backupOwner;
            otherCache = primaryOwner;
        }
        AdvancedCache other = this.cacheMode.isScattered() ? otherCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK}) : otherCache;
        AssertJUnit.assertEquals((Object)key.toString(), (Object)other.get(key));
        Object expiredValue = expiredCache.get(key);
        if (this.cacheMode.isScattered() && !expireOnPrimary) {
            AssertJUnit.assertEquals((Object)key.toString(), (Object)expiredValue);
        } else {
            AssertJUnit.assertNull((Object)expiredValue);
            this.eventually(() -> ClusterExpirationLifespanTest.lambda$testLifespanExpiredEntryRetrieval$1((Cache)other, key), 10L, TimeUnit.SECONDS);
        }
    }

    private Object createKey(Cache<Object, String> primaryOwner, Cache<Object, String> backupOwner) {
        if (this.storageType == StorageType.OBJECT) {
            if (this.cacheMode.isScattered()) {
                return new MagicKey(primaryOwner);
            }
            return new MagicKey(primaryOwner, backupOwner);
        }
        LocalizedCacheTopology primaryLct = primaryOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        LocalizedCacheTopology backupLct = backupOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int attempt = 0;
        do {
            int key = tlr.nextInt();
            Object wrappedKey = primaryOwner.getAdvancedCache().getKeyDataConversion().toStorage((Object)key);
            if (!primaryLct.getDistribution(wrappedKey).isPrimary() || !this.cacheMode.isScattered() && !backupLct.getDistribution(wrappedKey).isWriteBackup()) continue;
            log.tracef("Found key %s for primary owner %s and backup owner %s", wrappedKey, primaryOwner, backupOwner);
            return key;
        } while (++attempt != 1000);
        throw new AssertionError((Object)("Unable to find key that maps to primary " + primaryOwner + " and backup " + backupOwner));
    }

    public void testLifespanExpiredOnBoth() {
        Object key = this.createKey(this.cache0, this.cache1);
        this.cache0.put(key, (Object)key.toString(), 10L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)this.cache0.get(key)));
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)this.cache1.get(key)));
        this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        AssertJUnit.assertNull((Object)this.cache0.get(key));
        AssertJUnit.assertNull((Object)this.cache1.get(key));
    }

    private void incrementAllTimeServices(long time, TimeUnit unit) {
        for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
            cts.advance(unit.toMillis(time));
        }
    }

    @Test(groups={"unstable"}, description="https://issues.redhat.com/browse/ISPN-11422")
    public void testWriteExpiredEntry() {
        String key = "key";
        String value = "value";
        for (int i = 0; i < 100; ++i) {
            Cache<Object, String> cache = this.cache0;
            Object prev = cache.get((Object)key);
            if (prev == null) {
                prev = cache.putIfAbsent((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
                AssertJUnit.assertNull((Object)prev);
                AssertJUnit.assertNotNull((Object)cache.get((Object)key));
            }
            long secondOneMilliAdvanced = TimeUnit.SECONDS.toMillis(1L);
            this.ts0.advance(secondOneMilliAdvanced);
            this.ts1.advance(secondOneMilliAdvanced);
            this.ts2.advance(secondOneMilliAdvanced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryNotExpiredButBackupWas() throws InterruptedException, ExecutionException, TimeoutException {
        Class<PutKeyValueCommand> commandToExpect;
        if (this.transactional.booleanValue() || this.cacheMode == CacheMode.SCATTERED_SYNC) {
            throw new SkipException("Test isn't supported in transactional mode or scattered cache");
        }
        Object key = this.createKey(this.cache0, this.cache1);
        String value = key.toString();
        this.cache0.put(key, (Object)value, 10L, TimeUnit.SECONDS);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(this.cache0);
        if (this.cacheMode == CacheMode.DIST_SYNC) {
            controlledRpcManager.excludeCommands(PutKeyValueCommand.class);
            commandToExpect = BackupWriteCommand.class;
        } else {
            commandToExpect = PutKeyValueCommand.class;
        }
        try {
            Future<String> result = this.fork(() -> (String)this.cache0.put(key, (Object)(value + "-expire-backup")));
            ControlledRpcManager.BlockedRequest<PutKeyValueCommand> blockedRequest = controlledRpcManager.expectCommand(commandToExpect);
            this.incrementAllTimeServices(11L, TimeUnit.SECONDS);
            ControlledRpcManager.SentRequest sentRequest = blockedRequest.send();
            if (sentRequest != null) {
                sentRequest.expectAllResponses().receive();
            }
            AssertJUnit.assertEquals((String)value, (String)result.get(10L, TimeUnit.SECONDS));
        }
        finally {
            controlledRpcManager.revertRpcManager();
        }
        AssertJUnit.assertEquals((String)(value + "-expire-backup"), (String)((String)this.cache0.get(key)));
        AssertJUnit.assertEquals((String)(value + "-expire-backup"), (String)((String)this.cache1.get(key)));
        AssertJUnit.assertEquals((String)(value + "-expire-backup"), (String)((String)this.cache2.get(key)));
    }

    private static /* synthetic */ boolean lambda$testLifespanExpiredEntryRetrieval$1(Cache other, Object key) throws Exception {
        return !other.containsKey(key);
    }
}

