/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.expiration.TouchMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ClusterExpirationMaxIdleTest")
public class ClusterExpirationMaxIdleTest
extends MultipleCacheManagersTest {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;
    protected ControlledTimeService ts2;
    protected Cache<Object, String> cache0;
    protected Cache<Object, String> cache1;
    protected Cache<Object, String> cache2;
    private TouchMode touchMode = TouchMode.SYNC;
    protected ConfigurationBuilder configurationBuilder;

    @Override
    public Object[] factory() {
        return Arrays.stream(StorageType.values()).flatMap(type -> Stream.builder().add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(false)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(false)).add(new ClusterExpirationMaxIdleTest().storageType((StorageType)type).cacheMode(CacheMode.SCATTERED_SYNC).transactional(false)).add(new ClusterExpirationMaxIdleTest().touch(TouchMode.ASYNC).storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationMaxIdleTest().touch(TouchMode.ASYNC).storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationMaxIdleTest().touch(TouchMode.ASYNC).storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(false)).add(new ClusterExpirationMaxIdleTest().touch(TouchMode.ASYNC).storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(false)).add(new ClusterExpirationMaxIdleTest().touch(TouchMode.ASYNC).storageType((StorageType)type).cacheMode(CacheMode.SCATTERED_SYNC).transactional(false)).build()).toArray();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = new ConfigurationBuilder();
        this.configurationBuilder.clustering().cacheMode(this.cacheMode);
        this.configurationBuilder.transaction().transactionMode(this.transactionMode()).lockingMode(this.lockingMode);
        this.configurationBuilder.expiration().disableReaper().touch(this.touchMode);
        if (this.storageType != null) {
            this.configurationBuilder.memory().storage(this.storageType);
        }
        this.createCluster(TestDataSCI.INSTANCE, this.configurationBuilder, 3);
        this.waitForClusterToForm();
        this.injectTimeServices();
        this.cache0 = this.cache(0);
        this.cache1 = this.cache(1);
        this.cache2 = this.cache(2);
    }

    protected void injectTimeServices() {
        this.ts0 = new ControlledTimeService((Object)this.address(0));
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.ts0, true);
        this.ts1 = new ControlledTimeService((Object)this.address(1));
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.ts1, true);
        this.ts2 = new ControlledTimeService((Object)this.address(2));
        TestingUtil.replaceComponent((CacheContainer)this.manager(2), TimeService.class, this.ts2, true);
    }

    private Object createKey(Cache<Object, String> primaryOwner, Cache<Object, String> backupOwner) {
        if (this.storageType == StorageType.OBJECT) {
            return this.getKeyForCache(primaryOwner, backupOwner);
        }
        LocalizedCacheTopology primaryLct = primaryOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        LocalizedCacheTopology backupLct = backupOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int attempt = 0;
        do {
            int key = tlr.nextInt();
            Object wrappedKey = primaryOwner.getAdvancedCache().getKeyDataConversion().toStorage((Object)key);
            if (!primaryLct.getDistribution(wrappedKey).isPrimary() || !this.cacheMode.isScattered() && !backupLct.getDistribution(wrappedKey).isWriteBackup()) continue;
            log.tracef("Found key %s for primary owner %s and backup owner %s", wrappedKey, primaryOwner, backupOwner);
            return key;
        } while (++attempt != 1000);
        throw new AssertionError((Object)("Unable to find key that maps to primary " + primaryOwner + " and backup " + backupOwner));
    }

    public void testMaxIdleExpiredOnBoth() throws Exception {
        Object key = this.createKey(this.cache0, this.cache1);
        this.cache1.put(key, (Object)key.toString(), -1L, null, 10L, TimeUnit.MINUTES);
        this.incrementAllTimeServices(1L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)this.cache0.get(key)));
        this.assertLastUsedUpdate(key, this.ts0.wallClockTime(), this.cache0, this.cache1);
        this.incrementAllTimeServices(11L, TimeUnit.MINUTES);
        AssertJUnit.assertNull((Object)this.cache0.get(key));
        AssertJUnit.assertNull((Object)this.cache1.get(key));
    }

    public void testMaxIdleExpiredOnPrimaryOwner() throws Exception {
        this.testMaxIdleExpiredEntryRetrieval(true);
    }

    public void testMaxIdleExpiredOnBackupOwner() throws Exception {
        this.testMaxIdleExpiredEntryRetrieval(false);
    }

    private void incrementAllTimeServices(long time, TimeUnit unit) {
        for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
            cts.advance(unit.toMillis(time));
        }
    }

    private void testMaxIdleExpiredEntryRetrieval(boolean expireOnPrimary) throws Exception {
        AdvancedCache<Object, String> otherCache;
        AdvancedCache<Object, String> expiredCache;
        AdvancedCache primaryOwner = this.cache0.getAdvancedCache();
        AdvancedCache backupOwner = this.cache1.getAdvancedCache();
        Object key = this.createKey((Cache<Object, String>)primaryOwner, (Cache<Object, String>)backupOwner);
        backupOwner.put(key, (Object)key.toString(), -1L, null, 10L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)primaryOwner.get(key)));
        AssertJUnit.assertEquals((String)key.toString(), (String)((String)backupOwner.get(key)));
        if (expireOnPrimary) {
            expiredCache = this.localModeCache((AdvancedCache<Object, String>)primaryOwner);
            otherCache = this.localModeCache((AdvancedCache<Object, String>)backupOwner);
        } else {
            expiredCache = this.localModeCache((AdvancedCache<Object, String>)backupOwner);
            otherCache = this.localModeCache((AdvancedCache<Object, String>)primaryOwner);
        }
        this.incrementAllTimeServices(5L, TimeUnit.MINUTES);
        AssertJUnit.assertNotNull((Object)otherCache.get(key));
        this.assertLastUsedUpdate(key, this.ts1.wallClockTime(), (Cache<Object, String>)otherCache, (Cache<Object, String>)expiredCache);
        this.incrementAllTimeServices(6L, TimeUnit.MINUTES);
        if (this.cacheMode == CacheMode.SCATTERED_SYNC) {
            String expiredValue = (String)expiredCache.get(key);
            String otherValue = (String)otherCache.get(key);
            AssertJUnit.assertNotNull((Object)expiredValue);
            AssertJUnit.assertNotNull((Object)otherValue);
        } else {
            long targetTime = this.ts0.wallClockTime();
            CacheEntry ce = otherCache.getCacheEntry(key);
            AssertJUnit.assertNotNull((Object)ce);
            if (this.transactional == Boolean.FALSE) {
                AssertJUnit.assertEquals((long)targetTime, (long)ce.getLastUsed());
            }
            ce = expiredCache.getCacheEntry(key);
            AssertJUnit.assertNotNull((Object)ce);
            if (this.transactional == Boolean.FALSE) {
                AssertJUnit.assertEquals((long)targetTime, (long)ce.getLastUsed());
            }
        }
    }

    private AdvancedCache<Object, String> localModeCache(AdvancedCache<Object, String> expiredCache) {
        return expiredCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMaxIdleExpireExpireIteration(boolean expireOnPrimary, boolean iterateOnPrimary) {
        Object key = this.createKey(this.cache0, this.cache1);
        this.cache1.put(key, (Object)key.toString(), -1L, null, 10L, TimeUnit.SECONDS);
        ControlledTimeService expiredTimeService = expireOnPrimary ? this.ts0 : this.ts1;
        expiredTimeService.advance(11L, TimeUnit.SECONDS);
        Cache<Object, String> cacheToIterate = iterateOnPrimary ? this.cache0 : this.cache1;
        try (CloseableIterator iterator = cacheToIterate.entrySet().iterator();){
            if (expireOnPrimary == (iterateOnPrimary || this.cacheMode.isScattered())) {
                AssertJUnit.assertFalse((boolean)iterator.hasNext());
            } else {
                AssertJUnit.assertTrue((boolean)iterator.hasNext());
                Map.Entry entry = (Map.Entry)iterator.next();
                AssertJUnit.assertEquals((Object)key, entry.getKey());
                AssertJUnit.assertEquals((String)key.toString(), (String)((String)entry.getValue()));
            }
        }
        catch (Throwable throwable) {
            for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
                if (cts == expiredTimeService) continue;
                cts.advance(TimeUnit.SECONDS.toMillis(11L));
            }
            throw throwable;
        }
        for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
            if (cts == expiredTimeService) continue;
            cts.advance(TimeUnit.SECONDS.toMillis(11L));
        }
    }

    public void testMaxIdleExpirePrimaryIteratePrimary() {
        this.testMaxIdleExpireExpireIteration(true, true);
    }

    public void testMaxIdleExpireBackupIteratePrimary() {
        this.testMaxIdleExpireExpireIteration(false, true);
    }

    public void testMaxIdleExpirePrimaryIterateBackup() {
        this.testMaxIdleExpireExpireIteration(true, false);
    }

    public void testMaxIdleExpireBackupIterateBackup() {
        this.testMaxIdleExpireExpireIteration(false, false);
    }

    public void testMaxIdleAccessSuspectedExpiredEntryRefreshesProperly() {
        Object key = this.createKey(this.cache0, this.cache1);
        String value = key.toString();
        this.cache1.put(key, (Object)value, -1L, null, 10L, TimeUnit.SECONDS);
        this.incrementAllTimeServices(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache1.get(key)));
        this.assertLastUsedUpdate(key, this.ts1.wallClockTime(), this.cache1, this.cache0);
        this.incrementAllTimeServices(5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache0.get(key)));
        this.assertLastUsedUpdate(key, this.ts1.wallClockTime(), this.cache0, this.cache1);
        this.incrementAllTimeServices(9L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache0.get(key)));
    }

    private void assertLastUsedUpdate(Object key, long expectedLastUsed, Cache<Object, String> readCache, Cache<Object, String> otherCache) {
        Object storageKey = readCache.getAdvancedCache().getKeyDataConversion().toStorage(key);
        if (this.touchMode == TouchMode.SYNC) {
            AssertJUnit.assertEquals((long)expectedLastUsed, (long)this.getLastUsed(readCache, storageKey));
            AssertJUnit.assertEquals((long)expectedLastUsed, (long)this.getLastUsed(otherCache, storageKey));
        } else {
            this.eventuallyEquals(expectedLastUsed, () -> this.getLastUsed(readCache, storageKey));
            this.eventuallyEquals(expectedLastUsed, () -> this.getLastUsed(otherCache, storageKey));
        }
    }

    private long getLastUsed(Cache<Object, String> cache, Object storageKey) {
        InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().peek(storageKey);
        AssertJUnit.assertNotNull((Object)entry);
        return entry.getLastUsed();
    }

    public void testMaxIdleReadNodeDiesPrimary() {
        if (!this.cacheMode.isScattered()) {
            this.testMaxIdleNodeDies(true);
        }
    }

    public void testMaxIdleReadNodeDiesBackup() {
        this.testMaxIdleNodeDies(false);
    }

    private void testMaxIdleNodeDies(boolean isPrimary) {
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.configurationBuilder);
        this.waitForClusterToForm();
        Cache cache3 = this.cache(3);
        ControlledTimeService ts3 = new ControlledTimeService((Object)this.address(3), this.ts2);
        TestingUtil.replaceComponent((CacheContainer)this.manager(3), TimeService.class, ts3, true);
        Object primary = isPrimary ? cache3 : this.cache0;
        Object backup = isPrimary ? this.cache0 : cache3;
        Object key = this.createKey((Cache<Object, String>)primary, (Cache<Object, String>)backup);
        backup.put(key, (Object)"max-idle", -1L, TimeUnit.SECONDS, 100L, TimeUnit.SECONDS);
        this.incrementAllTimeServices(99L, TimeUnit.SECONDS);
        ts3.advance(99L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)cache3.get(key));
        this.assertLastUsedUpdate(key, ts3.wallClockTime(), cache3, this.cache0);
        this.killMember(3);
        this.incrementAllTimeServices(2L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)this.cache1.get(key));
    }

    protected MultipleCacheManagersTest touch(TouchMode touchMode) {
        this.touchMode = touchMode;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return ClusterExpirationMaxIdleTest.concat(super.parameterNames(), "touch");
    }

    @Override
    protected Object[] parameterValues() {
        return ClusterExpirationMaxIdleTest.concat(super.parameterValues(), this.touchMode);
    }
}

