/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.CustomLoaderNonNullWithExpirationTest")
public class CustomLoaderNonNullWithExpirationTest
extends SingleCacheManagerTest {
    private ControlledTimeService timeService = new ControlledTimeService();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((SimpleLoaderConfigurationBuilder)builder.persistence().addStore(SimpleLoaderConfigurationBuilder.class)).segmented(false);
        builder.expiration().wakeUpInterval(1L, TimeUnit.DAYS);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        this.cache = cm.getCache();
        return cm;
    }

    public void testEntryExpired() {
        String key = "some-key";
        Object value = this.cache.get((Object)key);
        AssertJUnit.assertEquals((Object)"some-value", (Object)value);
        this.timeService.advance(TimeUnit.SECONDS.toMillis(2L));
        value = this.cache.get((Object)key);
        AssertJUnit.assertEquals((Object)"some-value", (Object)value);
    }

    public void testExpireAfterWrapping() {
        this.cache.getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new BaseCustomAsyncInterceptor(){

            public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
                CustomLoaderNonNullWithExpirationTest.this.timeService.advance(TimeUnit.SECONDS.toMillis(2L));
                return super.visitGetKeyValueCommand(ctx, command);
            }
        }, EntryWrappingInterceptor.class);
        String key = "some-key";
        Object value = this.cache.get((Object)key);
        AssertJUnit.assertEquals((Object)"some-value", (Object)value);
        value = this.cache.get((Object)key);
        AssertJUnit.assertEquals((Object)"some-value", (Object)value);
    }

    public void testConcurrentReadExpiration() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        final AtomicBoolean blockFirst = new AtomicBoolean(true);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final String key = "some-key";
        this.cache.getAdvancedCache().getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new BaseCustomAsyncInterceptor(){

            public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
                if (blockFirst.getAndSet(false)) {
                    AssertJUnit.assertEquals((Object)NullCacheEntry.getInstance(), (Object)ctx.lookupEntry((Object)key));
                    barrier.await(10L, TimeUnit.SECONDS);
                    barrier.await(10L, TimeUnit.SECONDS);
                }
                return super.visitGetKeyValueCommand(ctx, command);
            }
        }, EntryWrappingInterceptor.class);
        Future<Void> future = this.fork(() -> AssertJUnit.assertEquals((Object)"some-value", (Object)this.cache.get((Object)key)));
        barrier.await(10L, TimeUnit.SECONDS);
        Object value = this.cache.get((Object)key);
        AssertJUnit.assertEquals((Object)"some-value", (Object)value);
        this.timeService.advance(TimeUnit.SECONDS.toMillis(2L));
        barrier.await(10L, TimeUnit.SECONDS);
        future.get(10L, TimeUnit.SECONDS);
    }

    public static class SimpleLoader<K, V>
    implements CacheLoader<K, V> {
        static final String VALUE = "some-value";
        private MarshallableEntryFactory<K, V> factory;
        private TimeService timeService;

        public void init(InitializationContext ctx) {
            this.factory = ctx.getMarshallableEntryFactory();
            this.timeService = ctx.getTimeService();
        }

        public MarshallableEntry<K, V> loadEntry(Object key) {
            Metadata metadata = new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.SECONDS).build();
            long now = this.timeService.wallClockTime();
            return this.factory.create(key, (Object)VALUE, metadata, null, now, now);
        }

        public boolean contains(Object key) {
            return true;
        }

        public void start() {
        }

        public void stop() {
        }
    }

    public static class SimpleLoaderConfigurationBuilder
    extends AbstractStoreConfigurationBuilder<SimpleLoaderConfiguration, SimpleLoaderConfigurationBuilder> {
        public SimpleLoaderConfigurationBuilder(PersistenceConfigurationBuilder builder) {
            super(builder, SimpleLoaderConfiguration.attributeDefinitionSet());
        }

        public SimpleLoaderConfiguration create() {
            return new SimpleLoaderConfiguration(this.attributes.protect(), this.async.create());
        }

        public SimpleLoaderConfigurationBuilder self() {
            return this;
        }
    }

    @BuiltBy(value=SimpleLoaderConfigurationBuilder.class)
    @ConfigurationFor(value=SimpleLoader.class)
    public static class SimpleLoaderConfiguration
    extends AbstractStoreConfiguration {
        public SimpleLoaderConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
            super(attributes, async);
        }
    }
}

