/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationFunctionalTest")
public class ExpirationFunctionalTest
extends SingleCacheManagerTest {
    protected final int SIZE = 10;
    protected ControlledTimeService timeService = new ControlledTimeService();
    protected StorageType storage;
    protected CacheMode cacheMode;
    protected ExpirationManager<?, ?> expirationManager;

    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.BINARY), new ExpirationFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.OBJECT), new ExpirationFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.OFF_HEAP), new ExpirationFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.BINARY), new ExpirationFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.OBJECT), new ExpirationFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.OFF_HEAP)};
    }

    protected ExpirationFunctionalTest cacheMode(CacheMode mode) {
        this.cacheMode = mode;
        return this;
    }

    @Override
    protected String parameters() {
        return "[" + this.cacheMode + ", " + this.storage + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        this.configure(builder);
        EmbeddedCacheManager cm = this.createCacheManager(builder);
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        this.cache = cm.getCache();
        this.expirationManager = this.cache.getAdvancedCache().getExpirationManager();
        this.afterCacheCreated(cm);
        return cm;
    }

    protected EmbeddedCacheManager createCacheManager(ConfigurationBuilder builder) {
        if (builder.clustering().cacheMode().isClustered()) {
            GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
            this.configure(globalBuilder);
            return TestCacheManagerFactory.createClusteredCacheManager(false, globalBuilder, builder, new TransportFlags());
        }
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        this.configure(globalBuilder);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder, false);
    }

    protected void configure(GlobalConfigurationBuilder globalBuilder) {
    }

    protected void configure(ConfigurationBuilder config) {
        config.clustering().cacheMode(this.cacheMode).expiration().disableReaper().memory().storage(this.storage);
    }

    protected void afterCacheCreated(EmbeddedCacheManager cm) {
    }

    protected void processExpiration() {
        this.expirationManager.processExpiration();
    }

    public ExpirationFunctionalTest withStorage(StorageType storage) {
        this.storage = storage;
        return this;
    }

    public StorageType getStorageType() {
        return this.storage;
    }

    public void testSimpleExpirationLifespan() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
    }

    protected int maxInMemory() {
        return 10;
    }

    public void testSimpleExpirationMaxIdle() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), -1L, null, 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        AssertJUnit.assertEquals((int)this.maxInMemory(), (int)this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        this.processExpiration();
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
    }

    public void testSimpleExprationMaxIdleWithGet() {
        String key = "max-idle-get-key";
        String value = "max-idle-value";
        AssertJUnit.assertNull((Object)this.cache.put((Object)key, (Object)value, -1L, null, 20L, TimeUnit.MILLISECONDS));
        this.timeService.advance(19L);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        this.timeService.advance(5L);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        this.timeService.advance(25L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }

    public void testExpirationLifespanInOps() throws Exception {
        for (int i = 0; i < 10; ++i) {
            long expirationTime = i % 2 == 0 ? 1L : 1000L;
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), expirationTime, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        this.checkOddExist(10);
    }

    public void testExpirationMaxIdleInOps() throws Exception {
        for (int i = 0; i < 10; ++i) {
            long expirationTime = i % 2 == 0 ? 1L : 1000L;
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), -1L, null, expirationTime, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        this.checkOddExist(10);
    }

    protected void checkOddExist(int SIZE) {
        for (int i = 0; i < SIZE; ++i) {
            if (i % 2 == 0) {
                AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)("key-" + i)));
                AssertJUnit.assertNull((Object)this.cache.get((Object)("key-" + i)));
                AssertJUnit.assertNull((Object)this.cache.remove((Object)("key-" + i)));
                continue;
            }
            AssertJUnit.assertTrue((boolean)this.cache.containsKey((Object)("key-" + i)));
            AssertJUnit.assertNotNull((Object)this.cache.get((Object)("key-" + i)));
            AssertJUnit.assertNotNull((Object)this.cache.remove((Object)("key-" + i)));
        }
    }

    public void testExpirationLifespanInExec() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        this.cache.getAdvancedCache().getDataContainer().forEach(ice -> {
            throw new RuntimeException("No task should be executed on expired entry");
        });
    }

    public void testExpirationMaxIdleDataContainerIterator() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), -1L, null, 1L, TimeUnit.MILLISECONDS);
        }
        this.timeService.advance(2L);
        this.cache.getAdvancedCache().getDataContainer().iterator().forEachRemaining(ice -> {
            throw new RuntimeException("No task should be executed on expired entry");
        });
        this.cache.getAdvancedCache().getDataContainer().forEach(ice -> {
            throw new RuntimeException("No task should be executed on expired entry");
        });
        AtomicInteger invocationCount = new AtomicInteger();
        this.cache.getAdvancedCache().getDataContainer().iteratorIncludingExpired().forEachRemaining(ice -> invocationCount.incrementAndGet());
        AssertJUnit.assertEquals((int)this.maxInMemory(), (int)invocationCount.get());
        this.processExpiration();
        this.cache.getAdvancedCache().getDataContainer().iteratorIncludingExpired().forEachRemaining(ice -> {
            throw new RuntimeException("No task should be executed on expired entry");
        });
    }

    public void testExpiredEntriesCleared() {
        this.cache.put((Object)"key-0", (Object)"value-1", -1L, null, 0L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)"key-1", (Object)"value-1", -1L, null, 1L, TimeUnit.MILLISECONDS);
        this.timeService.advance(1L);
        this.cache.clear();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
    }
}

