/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.impl.TestComponentAccessors;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="expiration.impl.ExpirationManagerTest")
public class ExpirationManagerTest
extends AbstractInfinispanTest {
    private ConfigurationBuilder getCfg() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        return builder;
    }

    public void testNoExpirationThread() {
        ExpirationManagerImpl em = new ExpirationManagerImpl();
        Configuration cfg = this.getCfg().expiration().wakeUpInterval(0L).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        TestingUtil.inject(em, cfg, Mockito.mock(AdvancedCache.class, (Answer)Answers.RETURNS_MOCKS), new TestComponentAccessors.NamedComponent("org.infinispan.executors.expiration", mockService));
        em.start();
        AssertJUnit.assertNull((String)"Expiration task is not null!  Should not have scheduled anything!", (Object)em.expirationTask);
    }

    public void testWakeupInterval() {
        ExpirationManagerImpl em = new ExpirationManagerImpl();
        Configuration cfg = this.getCfg().expiration().wakeUpInterval(789L).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        TestingUtil.inject(em, cfg, Mockito.mock(AdvancedCache.class, (Answer)Answers.RETURNS_MOCKS), new TestComponentAccessors.NamedComponent("org.infinispan.executors.expiration", mockService));
        ScheduledFuture mockFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockService.scheduleWithFixedDelay((Runnable)Matchers.isA(ExpirationManagerImpl.ScheduledTask.class), Matchers.eq((long)789L), Matchers.eq((long)789L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)mockFuture);
        em.start();
        AssertJUnit.assertEquals((Object)mockFuture, (Object)em.expirationTask);
        ((ScheduledExecutorService)Mockito.verify((Object)mockService)).scheduleWithFixedDelay((Runnable)Matchers.any(Runnable.class), Matchers.anyLong(), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
    }
}

