/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationWithClusteredWriteSkewTest")
public class ExpirationWithClusteredWriteSkewTest
extends MultipleCacheManagersTest {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private ControlledTimeService timeService = new ControlledTimeService();
    private ExpirationManager expirationManager1;
    private ExpirationManager expirationManager2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ControlledConsistentHashFactory.Default chf = new ControlledConsistentHashFactory.Default(0, 1);
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)chf).expiration().lifespan(10L, TimeUnit.SECONDS).transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.OPTIMISTIC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createCluster(builder, 2);
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.timeService, true);
        this.expirationManager1 = this.cache(0).getAdvancedCache().getExpirationManager();
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.timeService, true);
        this.expirationManager2 = this.cache(1).getAdvancedCache().getExpirationManager();
    }

    public void testDefaultExpirationInTransaction() throws Exception {
        Cache cache0 = this.cache(0);
        this.tm(0).begin();
        AssertJUnit.assertNull((Object)cache0.get((Object)KEY));
        cache0.put((Object)KEY, (Object)VALUE);
        CacheEntry entryInTx = cache0.getAdvancedCache().getCacheEntry((Object)KEY);
        AssertJUnit.assertEquals((long)10000L, (long)entryInTx.getLifespan());
        this.tm(0).commit();
        CacheEntry entryAfterCommit = cache0.getAdvancedCache().getCacheEntry((Object)KEY);
        AssertJUnit.assertEquals((long)10000L, (long)entryAfterCommit.getLifespan());
        this.timeService.advance(TimeUnit.SECONDS.toMillis(10L) + 1L);
        this.expirationManager1.processExpiration();
        this.expirationManager2.processExpiration();
        AssertJUnit.assertEquals((int)0, (int)cache0.size());
    }
}

