/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class ExpiredCacheListener {
    private static final Log log = LogFactory.getLog(ExpiredCacheListener.class);
    private final List<CacheEntryExpiredEvent> events = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger invocationCount = new AtomicInteger();

    public void reset() {
        this.events.clear();
        this.invocationCount.set(0);
    }

    public List<CacheEntryExpiredEvent> getEvents() {
        return this.events;
    }

    public int getInvocationCount() {
        return this.invocationCount.get();
    }

    @CacheEntryExpired
    public void handle(CacheEntryExpiredEvent e) {
        log.trace((Object)("Received event: " + e));
        this.events.add(e);
        this.invocationCount.incrementAndGet();
    }
}

