/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.MaxIdlePessimisticTxTest")
public class MaxIdlePessimisticTxTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 3;
    private static final long MAX_IDLE = 10L;
    private final ControlledTimeService timeService = new ControlledTimeService();

    public void testWriteLock(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method, 0);
        String value2 = TestingUtil.v(method, 1);
        Cache<String, String> cache = this.findNonOwnerCache(key);
        cache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS);
        long lastWallClock = this.timeService.wallClockTime();
        this.timeService.advance(9L);
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        cache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertEquals((String)value, (String)((String)cache.put((Object)key, (Object)value2, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS)));
        AssertJUnit.assertEquals((String)value2, (String)((String)cache.get((Object)key)));
        cache.getAdvancedCache().getTransactionManager().rollback();
        lastWallClock = this.timeService.wallClockTime();
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        this.timeService.advance(2L);
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        this.timeService.advance(10L);
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)key));
    }

    public void testReadLock(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method, 0);
        Cache<String, String> cache = this.findNonOwnerCache(key);
        cache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS);
        long lastWallClock = this.timeService.wallClockTime();
        this.timeService.advance(9L);
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        cache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertEquals((String)value, (String)((String)cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)key)));
        cache.getAdvancedCache().getTransactionManager().rollback();
        lastWallClock = this.timeService.wallClockTime();
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        this.timeService.advance(2L);
        this.assertNotExpired(key);
        this.assertLastUsed(key, lastWallClock);
        this.timeService.advance(10L);
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)key));
    }

    public void testReadLockExpired(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method, 0);
        Cache<String, String> cache = this.findNonOwnerCache(key);
        cache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS);
        long lastWallClock = this.timeService.wallClockTime();
        this.timeService.advance(11L);
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        cache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertNull((Object)cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)key));
        cache.getAdvancedCache().getTransactionManager().rollback();
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)key));
    }

    public void testWriteLockExpired(Method method) throws Exception {
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method, 0);
        String value2 = TestingUtil.v(method, 1);
        Cache<String, String> cache = this.findNonOwnerCache(key);
        cache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS);
        long lastWallClock = this.timeService.wallClockTime();
        this.timeService.advance(11L);
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        cache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertNull((Object)cache.put((Object)key, (Object)value2, -1L, TimeUnit.SECONDS, 10L, TimeUnit.MILLISECONDS));
        AssertJUnit.assertEquals((String)value2, (String)((String)cache.get((Object)key)));
        cache.getAdvancedCache().getTransactionManager().rollback();
        lastWallClock = this.timeService.wallClockTime();
        this.assertExpired(key);
        this.assertLastUsed(key, lastWallClock);
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)key));
    }

    private Cache<String, String> findNonOwnerCache(String key) {
        for (Cache cache : this.caches()) {
            if (TestingUtil.extractComponent(cache, ClusteringDependentLogic.class).getCacheTopology().isReadOwner((Object)key)) continue;
            return cache;
        }
        AssertJUnit.fail();
        throw new IllegalStateException();
    }

    private void assertNotExpired(String key) {
        this.getKeyFromAllCaches(key).forEach(entry -> AssertJUnit.assertFalse((boolean)entry.isExpired(this.timeService.wallClockTime())));
    }

    private void assertLastUsed(String key, long expected) {
        this.getKeyFromAllCaches(key).forEach(entry -> AssertJUnit.assertEquals((long)expected, (long)entry.getLastUsed()));
    }

    private void assertExpired(String key) {
        this.getKeyFromAllCaches(key).forEach(entry -> AssertJUnit.assertTrue((boolean)entry.isExpired(this.timeService.wallClockTime())));
    }

    private Stream<? extends InternalCacheEntry<?, ?>> getKeyFromAllCaches(String key) {
        return this.caches().stream().map(cache -> {
            InternalDataContainer dc = TestingUtil.extractComponent(cache, InternalDataContainer.class);
            KeyPartitioner keyPartitioner = TestingUtil.extractComponent(cache, KeyPartitioner.class);
            return dc.peek(keyPartitioner.getSegment((Object)key), (Object)key);
        }).filter(Objects::nonNull);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = MaxIdlePessimisticTxTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(builder, 3);
        this.cacheManagers.forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true));
    }
}

