/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.manager.TestModuleRepository;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="factories.impl.FactoryAutoInstantiationTest")
public class FactoryAutoInstantiationTest
extends AbstractInfinispanTest {
    private ModuleRepository moduleRepository;
    private BasicComponentRegistryImpl globalRegistry;
    private BasicComponentRegistryImpl cacheRegistry;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.moduleRepository = TestModuleRepository.defaultModuleRepository();
        this.globalRegistry = new BasicComponentRegistryImpl(this.moduleRepository, true, null);
        this.cacheRegistry = new BasicComponentRegistryImpl(this.moduleRepository, false, (BasicComponentRegistry)this.globalRegistry);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cacheRegistry.stop();
        this.globalRegistry.stop();
    }

    public void testConcurrentAutoInstantiation() throws Exception {
        int i;
        this.globalRegistry.registerComponent(AFactoryDependency.class, (Object)new AFactoryDependency(), true);
        int numThreads = 2;
        CyclicBarrier barrier = new CyclicBarrier(numThreads + 1);
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(threadPool);
        for (i = 0; i < numThreads; ++i) {
            completionService.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                ComponentRef aRef = this.cacheRegistry.getComponent(AComponent.class);
                return aRef.wired();
            });
        }
        Thread.sleep(1L);
        barrier.await(10L, TimeUnit.SECONDS);
        threadPool.shutdown();
        for (i = 0; i < numThreads; ++i) {
            Future future = completionService.poll(111L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull(future);
            AssertJUnit.assertNotNull(future.get());
        }
    }

    @Scope(value=Scopes.GLOBAL)
    @DefaultFactoryFor(classes={AComponent.class})
    public static class AComponentFactory
    implements ComponentFactory,
    AutoInstantiableFactory {
        @Inject
        void inject(AFactoryDependency aDependency) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public Object construct(String componentName) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return new AComponent();
        }
    }

    @Scope(value=Scopes.GLOBAL)
    public static class AFactoryDependency {
    }

    @Scope(value=Scopes.GLOBAL)
    public static class AComponent {
    }
}

