/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.metadata.Metadata;

@SerializeWith(value=Externalizer.class)
public class CompositeKeyValueFilterConverter<K, V, C>
implements KeyValueFilterConverter<K, V, C> {
    private final KeyValueFilter<? super K, ? super V> filter;
    private final Converter<? super K, ? super V, ? extends C> converter;

    public CompositeKeyValueFilterConverter(KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter) {
        this.filter = filter;
        this.converter = converter;
    }

    public C filterAndConvert(K key, V value, Metadata metadata) {
        if (this.accept(key, value, metadata)) {
            return this.convert(key, value, metadata);
        }
        return null;
    }

    public C convert(K key, V value, Metadata metadata) {
        return (C)this.converter.convert(key, value, metadata);
    }

    public boolean accept(K key, V value, Metadata metadata) {
        return this.filter.accept(key, value, metadata);
    }

    public static class Externalizer
    implements org.infinispan.commons.marshall.Externalizer<CompositeKeyValueFilterConverter> {
        public void writeObject(ObjectOutput output, CompositeKeyValueFilterConverter object) throws IOException {
            output.writeObject(object.filter);
            output.writeObject(object.converter);
        }

        public CompositeKeyValueFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            KeyValueFilter kvf = (KeyValueFilter)input.readObject();
            Converter converter = (Converter)input.readObject();
            return new CompositeKeyValueFilterConverter(kvf, converter);
        }
    }
}

