/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import javax.transaction.RollbackException;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.functional.AbstractFunctionalOpTest;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.RemoteException;
import org.infinispan.test.TestException;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalInMemoryTest")
public class FunctionalInMemoryTest
extends AbstractFunctionalOpTest {
    public FunctionalInMemoryTest() {
        this.persistence = false;
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testWriteLoad(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "dist");
        method.eval(key, this.wo, this.rw, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value", new MetaParam.Writable[0]), this.getClass());
        this.assertInvocations(Boolean.TRUE.equals(this.transactional) && !isOwner && !method.doesRead ? 3 : 2);
        this.caches("dist").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString()));
        this.caches("dist").forEach(cache -> {
            if (cache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)) {
                Assert.assertTrue((boolean)this.cacheContainsKey(key, (Cache<Object, Object>)cache), (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString());
            } else {
                Assert.assertFalse((boolean)this.cacheContainsKey(key, (Cache<Object, Object>)cache), (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString());
            }
        });
        this.resetInvocationCount();
        method.eval(key, this.wo, this.rw, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
        if (method.isMany) {
            this.assertInvocations(Boolean.TRUE.equals(this.transactional) && !isOwner && !method.doesRead ? 3 : 2);
        } else {
            this.assertInvocations(Boolean.TRUE.equals(this.transactional) && !isOwner && method.doesRead ? 2 : 1);
        }
    }

    @Test(dataProvider="writeMethods")
    public void testWriteLoadLocal(AbstractFunctionalOpTest.WriteMethod method) {
        Integer key = 1;
        method.eval(key, this.lwo, this.lrw, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value", new MetaParam.Writable[0]), this.getClass());
        this.assertInvocations(1);
        Assert.assertEquals((Object)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache().get((Object)key), (Object)"value");
        method.eval(key, this.lwo, this.lrw, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
        this.assertInvocations(2);
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testExceptionPropagation(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "dist");
        try {
            method.eval(key, this.wo, this.rw, (SerializableFunction & Serializable)view -> null, (SerializableBiConsumer & Serializable)(view, nil) -> {
                throw new TestException();
            }, this.getClass());
            Assert.fail((String)"Should throw CompletionException:CacheException:[RemoteException:]*TestException");
        }
        catch (CompletionException | CacheException e) {
            Throwable[] suppressed;
            Throwable t = e;
            if (Boolean.TRUE.equals(this.transactional) && t.getCause() instanceof RollbackException && (suppressed = t.getCause().getSuppressed()) != null && suppressed.length > 0) {
                t = suppressed[0];
                Assert.assertEquals(XAException.class, t.getClass());
                t = t.getCause();
            }
            Exceptions.assertException(CompletionException.class, (Throwable)t);
            Exceptions.assertExceptionNonStrict(CacheException.class, (Throwable)t);
            for (t = t.getCause(); t.getCause() instanceof RemoteException && t != t.getCause(); t = t.getCause()) {
            }
            Exceptions.assertException(TestException.class, (Throwable)t.getCause());
        }
    }

    @Test(dataProvider="owningModeAndReadWrites")
    public void testWriteOnMissingValue(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "dist");
        try {
            method.eval(key, null, this.rw, (SerializableFunction & Serializable)view -> (String)view.get(), (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
            Assert.fail((String)"Should throw CompletionException:CacheException:[RemoteException:]*NoSuchElementException");
        }
        catch (CompletionException e) {
            Throwable t = e;
            Exceptions.assertException(CompletionException.class, (Throwable)t);
            Exceptions.assertExceptionNonStrict(CacheException.class, (Throwable)t);
            for (t = t.getCause(); t.getCause() instanceof RemoteException && t != t.getCause(); t = t.getCause()) {
            }
            Exceptions.assertException(NoSuchElementException.class, (Throwable)t.getCause());
        }
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadLoad(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) {
        Object key = this.getKey(isOwner, "dist");
        Assert.assertTrue((boolean)((Boolean)method.eval(key, this.ro, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return true;
        })));
        this.cache(0, "dist").put(key, (Object)"value");
        this.caches("dist").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString()));
        this.caches("dist").forEach(cache -> {
            if (cache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)) {
                Assert.assertTrue((boolean)this.cacheContainsKey(key, (Cache<Object, Object>)cache), (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString());
            } else {
                Assert.assertFalse((boolean)this.cacheContainsKey(key, (Cache<Object, Object>)cache), (String)FunctionalInMemoryTest.getAddress((Cache<Object, Object>)cache).toString());
            }
        });
        Assert.assertEquals((String)((String)method.eval(key, this.ro, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return "OK";
        })), (String)"OK");
    }

    @Test(dataProvider="readMethods")
    public void testReadLoadLocal(AbstractFunctionalOpTest.ReadMethod method) {
        Integer key = 1;
        Assert.assertTrue((boolean)((Boolean)method.eval(key, this.lro, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return true;
        })));
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache();
        cache.put((Object)key, (Object)"value");
        Assert.assertEquals((String)((String)cache.get((Object)key)), (String)"value");
        Assert.assertEquals((String)((String)method.eval(key, this.lro, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return "OK";
        })), (String)"OK");
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadOnMissingValue(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) {
        this.testReadOnMissingValue(this.getKey(isOwner, "dist"), this.ro, method);
    }

    @Test(dataProvider="readMethods")
    public void testOnMissingValueLocal(AbstractFunctionalOpTest.ReadMethod method) {
        this.testReadOnMissingValue(0, ReadOnlyMapImpl.create((FunctionalMapImpl)this.fmapL1), method);
    }

    protected boolean cacheContainsKey(Object key, Cache<Object, Object> cache) {
        return cache.getAdvancedCache().getDataContainer().containsKey(key);
    }
}

