/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.AbstractFunctionalTest;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.decorators.FunctionalJCache;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalJCacheTest")
public class FunctionalJCacheTest
extends AbstractFunctionalTest {
    Cache<Integer, String> local1;
    Cache<Integer, String> local2;
    Cache<Object, String> dist1;
    Cache<Object, String> dist2;
    Cache<Object, String> repl1;
    Cache<Object, String> repl2;

    @Override
    @BeforeClass
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        this.local1 = FunctionalJCache.create(this.fmapL1);
        this.local2 = FunctionalJCache.create(this.fmapL2);
        this.dist1 = FunctionalJCache.create(this.fmapD1);
        this.dist2 = FunctionalJCache.create(this.fmapD2);
        this.repl1 = FunctionalJCache.create(this.fmapR1);
        this.repl2 = FunctionalJCache.create(this.fmapR2);
    }

    public void testLocalEmptyGetThenPut() {
        this.doEmptyGetThenPut(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplEmptyGetThenPutOnNonOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplEmptyGetThenPutOnOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistEmptyGetThenPutOnNonOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistEmptyGetThenPutOnOwner() {
        this.doEmptyGetThenPut(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doEmptyGetThenPut(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        writeCache.put(key, (Object)"one");
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
    }

    public void testLocalPutGet() {
        this.doPutGet(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplPutGetOnNonOwner() {
        this.doPutGet(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutGetOnOwner() {
        this.doPutGet(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutGetOnNonOwner() {
        this.doPutGet(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutGetOnOwner() {
        this.doPutGet(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutGet(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
    }

    public void testLocalGetAndPut() {
        this.doGetAndPut(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplGetAndPutOnNonOwner() {
        this.doGetAndPut(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplGetAndPutOnOwner() {
        this.doGetAndPut(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistGetAndPutOnNonOwner() {
        this.doGetAndPut(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistGetAndPutOnOwner() {
        this.doGetAndPut(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doGetAndPut(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)writeCache.getAndPut(key, (Object)"uno")));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readCache.get(key)));
    }

    public void testLocalGetAndRemove() {
        this.doGetAndRemove(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplGetAndRemoveOnNonOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplGetAndRemoveOnOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistGetAndRemoveOnNonOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistGetAndRemoveOnOwner() {
        this.doGetAndRemove(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doGetAndRemove(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        AssertJUnit.assertFalse((boolean)writeCache.remove(key1));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndRemove(key1)));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key1, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key1)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key1));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key1)));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key2, (Object)"two")));
        AssertJUnit.assertEquals((String)"two", (String)((String)readCache.get(key2)));
        AssertJUnit.assertEquals((String)"two", (String)((String)writeCache.getAndRemove(key2)));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key2)));
    }

    public void testLocalContainsKey() {
        this.doContainsKey(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplContainsKeyOnNonOwner() {
        this.doContainsKey(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplContainsKeyOnOwner() {
        this.doContainsKey(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistContainsKeyOnNonOwner() {
        this.doContainsKey(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistContainsKeyOnOwner() {
        this.doContainsKey(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doContainsKey(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals((boolean)false, (boolean)readCache.containsKey(key));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)readCache.containsKey(key));
    }

    public void testLocalClear() {
        this.doClear(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplClearOnNonOwner() {
        this.doClear(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplClearOnOwner() {
        this.doClear(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistClearOnNonOwner() {
        this.doClear(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistClearOnOwner() {
        this.doClear(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doClear(Supplier<K> keySupplier, Cache<K, String> map1, Cache<K, String> map2) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "two");
        map2.putAll(data);
        map2.clear();
        AssertJUnit.assertEquals(null, (String)((String)map1.get(key1)));
        AssertJUnit.assertEquals(null, (String)((String)map1.get(key2)));
        AssertJUnit.assertEquals(null, (String)((String)map1.get(key3)));
    }

    public void testLocalPutIfAbsent() {
        this.doPutIfAbsent(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplPutIfAbsentOnNonOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutIfAbsentOnOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutIfAbsentOnNonOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutIfAbsentOnOwner() {
        this.doPutIfAbsent(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutIfAbsent(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.putIfAbsent(key, (Object)"one"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.putIfAbsent(key, (Object)"uno"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
    }

    public void testLocalConditionalRemove() {
        this.doConditionalRemove(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplConditionalRemoveOnNonOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplConditionalRemoveOnOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistConditionalRemoveOnNonOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistConditionalRemoveOnOwner() {
        this.doConditionalRemove(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doConditionalRemove(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.remove(key, (Object)"xxx"));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.remove(key, (Object)"xxx"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key, (Object)"one"));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
    }

    public void testLocalReplace() {
        this.doReplace(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplReplaceOnNonOwner() {
        this.doReplace(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplReplaceOnOwner() {
        this.doReplace(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistReplaceOnNonOwner() {
        this.doReplace(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistReplaceOnOwner() {
        this.doReplace(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doReplace(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.replace(key, (Object)"xxx"));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.replace(key, (Object)"uno"));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
    }

    public void testLocalGetAndReplace() {
        this.doGetAndReplace(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplGetAndReplaceOnNonOwner() {
        this.doGetAndReplace(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplGetAndReplaceOnOwner() {
        this.doGetAndReplace(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistGetAndReplaceOnNonOwner() {
        this.doGetAndReplace(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistGetAndReplaceOnOwner() {
        this.doGetAndReplace(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doGetAndReplace(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndReplace(key, (Object)"xxx")));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertEquals((String)"one", (String)((String)writeCache.getAndReplace(key, (Object)"uno")));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
    }

    public void testLocalReplaceWithValue() {
        this.doReplaceWithValue(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplReplaceWithValueOnNonOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplReplaceWithValueOnOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistReplaceWithValueOnNonOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistReplaceWithValueOnOwner() {
        this.doReplaceWithValue(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doReplaceWithValue(Supplier<K> keySupplier, Cache<K, String> readCache, Cache<K, String> writeCache) {
        K key = keySupplier.get();
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.replace(key, (Object)"xxx", (Object)"uno"));
        AssertJUnit.assertEquals(null, (String)((String)writeCache.getAndPut(key, (Object)"one")));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertFalse((boolean)writeCache.replace(key, (Object)"xxx", (Object)"uno"));
        AssertJUnit.assertEquals((String)"one", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.replace(key, (Object)"one", (Object)"uno"));
        AssertJUnit.assertEquals((String)"uno", (String)((String)readCache.get(key)));
        AssertJUnit.assertTrue((boolean)writeCache.remove(key));
        AssertJUnit.assertEquals(null, (String)((String)readCache.get(key)));
    }

    public void testLocalPutAll() {
        this.doPutAllGetAllRemoveAll(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplPutAllOnNonOwner() {
        this.doPutAllGetAllRemoveAll(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplPutAllOnOwner() {
        this.doPutAllGetAllRemoveAll(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistPutAllOnNonOwner() {
        this.doPutAllGetAllRemoveAll(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistPutAllOnOwner() {
        this.doPutAllGetAllRemoveAll(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doPutAllGetAllRemoveAll(Supplier<K> keySupplier, Cache<K, String> map1, Cache<K, String> map2) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        K key4 = keySupplier.get();
        K key5 = keySupplier.get();
        K key6 = keySupplier.get();
        AssertJUnit.assertTrue((boolean)map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key3))).isEmpty());
        AssertJUnit.assertTrue((boolean)map1.getAll(new HashSet()).isEmpty());
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "three");
        data.put(key4, "four");
        data.put(key5, "five");
        data.put(key6, "five");
        map2.putAll(data);
        AssertJUnit.assertEquals((String)"one", (String)((String)map1.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)map1.get(key2)));
        AssertJUnit.assertEquals((String)"three", (String)((String)map1.get(key3)));
        AssertJUnit.assertEquals((String)"four", (String)((String)map1.get(key4)));
        AssertJUnit.assertEquals((String)"five", (String)((String)map1.get(key5)));
        AssertJUnit.assertEquals((String)"five", (String)((String)map1.get(key6)));
        Map res0 = map1.getAll(new HashSet());
        AssertJUnit.assertTrue((boolean)res0.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)res0.size());
        Map res1 = map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key5, key6)));
        AssertJUnit.assertFalse((boolean)res1.isEmpty());
        AssertJUnit.assertEquals((int)4, (int)res1.size());
        AssertJUnit.assertEquals((String)"one", (String)((String)res1.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)res1.get(key2)));
        AssertJUnit.assertEquals((String)"five", (String)((String)res1.get(key5)));
        AssertJUnit.assertEquals((String)"five", (String)((String)res1.get(key6)));
        Map res2 = map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key3, key4, key5, key6)));
        AssertJUnit.assertFalse((boolean)res2.isEmpty());
        AssertJUnit.assertEquals((int)6, (int)res2.size());
        AssertJUnit.assertEquals((String)"one", (String)((String)res2.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)res2.get(key2)));
        AssertJUnit.assertEquals((String)"three", (String)((String)res2.get(key3)));
        AssertJUnit.assertEquals((String)"four", (String)((String)res2.get(key4)));
        AssertJUnit.assertEquals((String)"five", (String)((String)res2.get(key5)));
        AssertJUnit.assertEquals((String)"five", (String)((String)res2.get(key6)));
        map2.removeAll(new HashSet());
        Map res3 = map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key3, key4, key5, key6)));
        AssertJUnit.assertFalse((boolean)res3.isEmpty());
        AssertJUnit.assertEquals((int)6, (int)res3.size());
        map2.removeAll(new HashSet<Object>(Arrays.asList(key3, key4, key5, key6)));
        Map res4 = map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key3, key4, key5, key6)));
        AssertJUnit.assertFalse((boolean)res4.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)res4.size());
        AssertJUnit.assertEquals((String)"one", (String)((String)res4.get(key1)));
        AssertJUnit.assertEquals((String)"two", (String)((String)res4.get(key2)));
        map2.removeAll();
        Map res5 = map1.getAll(new HashSet<Object>(Arrays.asList(key1, key2, key3, key4, key5, key6)));
        AssertJUnit.assertTrue((boolean)res5.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)res5.size());
    }

    public void testLocalIterator() {
        this.doIterator(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplIteratorOnNonOwner() {
        this.doIterator(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplIteratorOnOwner() {
        this.doIterator(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistIteratorOnNonOwner() {
        this.doIterator(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistIteratorOnOwner() {
        this.doIterator(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doIterator(Supplier<K> keySupplier, Cache<K, String> map1, Cache<K, String> map2) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        K key4 = keySupplier.get();
        K key5 = keySupplier.get();
        K key6 = keySupplier.get();
        AssertJUnit.assertFalse((boolean)map1.iterator().hasNext());
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "three");
        data.put(key4, "four");
        data.put(key5, "five");
        data.put(key6, "five");
        map2.putAll(data);
        HashMap<Object, String> res0 = new HashMap<Object, String>();
        for (Cache.Entry e : map1) {
            res0.put(e.getKey(), (String)e.getValue());
        }
        AssertJUnit.assertEquals(data, res0);
        map2.clear();
    }

    public void testLocalInvoke() {
        this.doInvoke(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplInvokeOnNonOwner() {
        this.doInvoke(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplInvokeOnOwner() {
        this.doInvoke(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistInvokeOnNonOwner() {
        this.doInvoke(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistInvokeOnOwner() {
        this.doInvoke(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doInvoke(Supplier<K> keySupplier, Cache<K, String> map1, Cache<K, String> map2) {
        K key = keySupplier.get();
        String res0 = (String)map1.invoke(key, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals(null, (String)res0);
        map2.invoke(key, (EntryProcessor)SetFirstArgValueProcessor.getInstance(), new Object[]{"one"});
        String res1 = (String)map1.invoke(key, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals((String)"one", (String)res1);
        map2.invoke(key, (EntryProcessor)RemoveProcessor.getInstance(), new Object[0]);
        String res2 = (String)map1.invoke(key, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals(null, (String)res2);
    }

    public void testLocalInvokeAll() {
        this.doInvokeAll(FunctionalTestUtils.supplyIntKey(), this.local1, this.local2);
    }

    public void testReplInvokeAllOnNonOwner() {
        this.doInvokeAll(this.supplyKeyForCache(0, "repl"), this.repl1, this.repl2);
    }

    public void testReplInvokeAllOnOwner() {
        this.doInvokeAll(this.supplyKeyForCache(1, "repl"), this.repl1, this.repl2);
    }

    public void testDistInvokeAllOnNonOwner() {
        this.doInvokeAll(this.supplyKeyForCache(0, "dist"), this.dist1, this.dist2);
    }

    public void testDistInvokeAllOnOwner() {
        this.doInvokeAll(this.supplyKeyForCache(1, "dist"), this.dist1, this.dist2);
    }

    private <K> void doInvokeAll(Supplier<K> keySupplier, Cache<K, String> map1, Cache<K, String> map2) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        HashSet<Object> keys = new HashSet<Object>(Arrays.asList(key1, key2, key3));
        Map res0 = map1.invokeAll(keys, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res0.get(key1)).get()));
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res0.get(key2)).get()));
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res0.get(key3)).get()));
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "three");
        map2.invokeAll(keys, (EntryProcessor)SetArgsValuesProcessor.getInstance(), new Object[]{data});
        Map res1 = map1.invokeAll(keys, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals((String)"one", (String)((String)((EntryProcessorResult)res1.get(key1)).get()));
        AssertJUnit.assertEquals((String)"two", (String)((String)((EntryProcessorResult)res1.get(key2)).get()));
        AssertJUnit.assertEquals((String)"three", (String)((String)((EntryProcessorResult)res1.get(key3)).get()));
        map2.invokeAll(keys, (EntryProcessor)RemoveProcessor.getInstance(), new Object[0]);
        Map res2 = map1.invokeAll(keys, (EntryProcessor)GetValueProcessor.getInstance(), new Object[0]);
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res2.get(key1)).get()));
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res2.get(key2)).get()));
        AssertJUnit.assertEquals(null, (String)((String)((EntryProcessorResult)res2.get(key3)).get()));
    }

    public void testClose() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder())){

            @Override
            public void call() throws Exception {
                AdvancedCache advCache = this.cm.getCache().getAdvancedCache();
                Cache local = FunctionalJCache.create(advCache);
                AssertJUnit.assertFalse((boolean)local.isClosed());
                local.close();
                AssertJUnit.assertTrue((boolean)local.isClosed());
            }
        });
    }

    public void testGetName() {
        AssertJUnit.assertEquals((String)"", (String)this.local1.getName());
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class SetArgsValuesProcessor<K>
    implements EntryProcessor<K, String, Void> {
        private static final SetArgsValuesProcessor INSTANCE = new SetArgsValuesProcessor();

        private SetArgsValuesProcessor() {
        }

        public Void process(MutableEntry<K, String> entry, Object ... args) throws EntryProcessorException {
            Map data = (Map)args[0];
            entry.setValue((Object)((String)data.get(entry.getKey())));
            return null;
        }

        private static <K> SetArgsValuesProcessor<K> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class RemoveProcessor<K, V>
    implements EntryProcessor<K, V, Void> {
        private static final RemoveProcessor INSTANCE = new RemoveProcessor();

        private RemoveProcessor() {
        }

        public Void process(MutableEntry<K, V> entry, Object ... args) throws EntryProcessorException {
            entry.remove();
            return null;
        }

        private static <K, V> RemoveProcessor<K, V> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class SetFirstArgValueProcessor<K>
    implements EntryProcessor<K, String, Void> {
        private static final SetFirstArgValueProcessor INSTANCE = new SetFirstArgValueProcessor();

        private SetFirstArgValueProcessor() {
        }

        public Void process(MutableEntry<K, String> entry, Object ... args) throws EntryProcessorException {
            entry.setValue((Object)((String)args[0]));
            return null;
        }

        private static <K> SetFirstArgValueProcessor<K> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class GetValueProcessor<K, V>
    implements EntryProcessor<K, V, V> {
        private static final GetValueProcessor INSTANCE = new GetValueProcessor();

        private GetValueProcessor() {
        }

        public V process(MutableEntry<K, V> entry, Object ... args) throws EntryProcessorException {
            return (V)entry.getValue();
        }

        private static <K, V> GetValueProcessor<K, V> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }
}

