/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.functional.AbstractFunctionalTest;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.TestFunctionalInterfaces;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalListenersTest")
public class FunctionalListenersTest
extends AbstractFunctionalTest {
    public void testLocalLambdaReadWriteListeners() throws Exception {
        this.doLambdaReadWriteListeners(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.wo(this.fmapL1), FunctionalTestUtils.rw(this.fmapL2), true);
    }

    public void testReplLambdaReadWriteListeners() throws Exception {
        this.doLambdaReadWriteListeners(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.wo(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2), true);
        this.doLambdaReadWriteListeners(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.wo(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2), true);
    }

    @Test
    public void testDistLambdaReadWriteListeners() throws Exception {
        this.doLambdaReadWriteListeners(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.wo(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2), false);
        this.doLambdaReadWriteListeners(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.wo(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2), true);
    }

    private <K> void doLambdaReadWriteListeners(Supplier<K> keySupplier, FunctionalMap.WriteOnlyMap<K, String> woMap, FunctionalMap.ReadWriteMap<K, String> rwMap, boolean isOwner) throws Exception {
        K key1 = keySupplier.get();
        ArrayList<CountDownLatch> latches = new ArrayList<CountDownLatch>();
        latches.addAll(Arrays.asList(new CountDownLatch(1), new CountDownLatch(1), new CountDownLatch(1)));
        AutoCloseable onCreate = rwMap.listeners().onCreate(created -> {
            AssertJUnit.assertEquals((String)"created", (String)((String)created.get()));
            ((CountDownLatch)latches.get(0)).countDown();
        });
        AutoCloseable onModify = rwMap.listeners().onModify((before, after) -> {
            AssertJUnit.assertEquals((String)"created", (String)((String)before.get()));
            AssertJUnit.assertEquals((String)"modified", (String)((String)after.get()));
            ((CountDownLatch)latches.get(1)).countDown();
        });
        AutoCloseable onRemove = rwMap.listeners().onRemove(removed -> {
            AssertJUnit.assertEquals((String)"modified", (String)((String)removed.get()));
            ((CountDownLatch)latches.get(2)).countDown();
        });
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key1, (Object)"created", MarshallableFunctions.setValueConsumer()), (CountDownLatch)latches.get(0));
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key1, (Object)"modified", MarshallableFunctions.setValueConsumer()), (CountDownLatch)latches.get(1));
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key1, MarshallableFunctions.removeConsumer()), (CountDownLatch)latches.get(2));
        K key2 = keySupplier.get();
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key2, (Object)"created", MarshallableFunctions.setValueReturnPrevOrNull()), (CountDownLatch)latches.get(0));
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key2, (Object)"modified", MarshallableFunctions.setValueReturnPrevOrNull()), (CountDownLatch)latches.get(1));
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key2, MarshallableFunctions.removeReturnPrevOrNull()), (CountDownLatch)latches.get(2));
        FunctionalListenersTest.launderLatches(latches, 3);
        K key3 = keySupplier.get();
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key3, new TestFunctionalInterfaces.SetConstantOnReadWrite("created")), (CountDownLatch)latches.get(0));
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key3, new TestFunctionalInterfaces.SetConstantOnReadWrite("modified")), (CountDownLatch)latches.get(1));
        FunctionalListenersTest.awaitEventIfOwner(isOwner, rwMap.eval(key3, MarshallableFunctions.removeReturnPrevOrNull()), (CountDownLatch)latches.get(2));
        onCreate.close();
        onModify.close();
        onRemove.close();
        FunctionalListenersTest.launderLatches(latches, 3);
        K key4 = keySupplier.get();
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key4, (Object)"tres", MarshallableFunctions.setValueConsumer()), (CountDownLatch)latches.get(0));
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key4, (Object)"three", MarshallableFunctions.setValueConsumer()), (CountDownLatch)latches.get(1));
        FunctionalListenersTest.awaitNoEvent(woMap.eval(key4, MarshallableFunctions.removeConsumer()), (CountDownLatch)latches.get(2));
        K key5 = keySupplier.get();
        FunctionalListenersTest.awaitNoEvent(rwMap.eval(key5, (Object)"cuatro", MarshallableFunctions.setValueReturnPrevOrNull()), (CountDownLatch)latches.get(0));
        FunctionalListenersTest.awaitNoEvent(rwMap.eval(key5, (Object)"four", MarshallableFunctions.setValueReturnPrevOrNull()), (CountDownLatch)latches.get(1));
        FunctionalListenersTest.awaitNoEvent(rwMap.eval(key5, MarshallableFunctions.removeReturnPrevOrNull()), (CountDownLatch)latches.get(2));
    }

    public void testLocalLambdaWriteListeners() throws Exception {
        this.doLambdaWriteListeners(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.wo(this.fmapL1), true);
    }

    @Test
    public void testReplLambdaWriteListeners() throws Exception {
        this.doLambdaWriteListeners(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.wo(this.fmapR1), true);
        this.doLambdaWriteListeners(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.wo(this.fmapR2), true);
    }

    @Test
    public void testDistLambdaWriteListeners() throws Exception {
        this.doLambdaWriteListeners(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.wo(this.fmapD1), true);
        this.doLambdaWriteListeners(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.wo(this.fmapD2), false);
    }

    private <K> void doLambdaWriteListeners(Supplier<K> keySupplier, FunctionalMap.WriteOnlyMap<K, String> wo, boolean isOwner) throws Exception {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        List<CountDownLatch> latches = FunctionalListenersTest.launderLatches(new ArrayList<CountDownLatch>(), 1);
        AutoCloseable onWrite = wo.listeners().onWrite(read -> {
            AssertJUnit.assertEquals((String)"write", (String)((String)read.get()));
            ((CountDownLatch)latches.get(0)).countDown();
        });
        FunctionalListenersTest.awaitEventIfOwnerAndLaunderLatch(isOwner, wo.eval(key1, new TestFunctionalInterfaces.SetConstantOnWriteOnly("write")), latches);
        FunctionalListenersTest.awaitEventIfOwnerAndLaunderLatch(isOwner, wo.eval(key1, new TestFunctionalInterfaces.SetConstantOnWriteOnly("write")), latches);
        onWrite.close();
        FunctionalListenersTest.awaitNoEvent(wo.eval(key2, new TestFunctionalInterfaces.SetConstantOnWriteOnly("write")), latches.get(0));
        FunctionalListenersTest.awaitNoEvent(wo.eval(key2, new TestFunctionalInterfaces.SetConstantOnWriteOnly("write")), latches.get(0));
        AutoCloseable onWriteRemove = wo.listeners().onWrite(read -> {
            AssertJUnit.assertFalse((boolean)read.find().isPresent());
            ((CountDownLatch)latches.get(0)).countDown();
        });
        FunctionalListenersTest.awaitEventIfOwnerAndLaunderLatch(isOwner, wo.eval(key1, MarshallableFunctions.removeConsumer()), latches);
        onWriteRemove.close();
        FunctionalListenersTest.awaitNoEvent(wo.eval(key2, MarshallableFunctions.removeConsumer()), latches.get(0));
    }

    private static List<CountDownLatch> launderLatches(List<CountDownLatch> latches, int numLatches) {
        latches.clear();
        for (int i = 0; i < numLatches; ++i) {
            latches.add(new CountDownLatch(1));
        }
        return latches;
    }

    public static <T> T awaitEvent(CompletableFuture<T> cf, CountDownLatch eventLatch) {
        try {
            T t = cf.get();
            AssertJUnit.assertTrue((boolean)eventLatch.await(500L, TimeUnit.MILLISECONDS));
            return t;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error(e);
        }
    }

    public static <T> T awaitNoEvent(CompletableFuture<T> cf, CountDownLatch eventLatch) {
        try {
            T t = cf.get();
            AssertJUnit.assertFalse((boolean)eventLatch.await(50L, TimeUnit.MILLISECONDS));
            return t;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error(e);
        }
    }

    public static <T> T awaitEventIfOwner(boolean isOwner, CompletableFuture<T> cf, CountDownLatch eventLatch) {
        return isOwner ? FunctionalListenersTest.awaitEvent(cf, eventLatch) : FunctionalListenersTest.awaitNoEvent(cf, eventLatch);
    }

    public static <T> T awaitEventAndLaunderLatch(CompletableFuture<T> cf, List<CountDownLatch> latches) {
        T t = FunctionalListenersTest.awaitEvent(cf, latches.get(0));
        FunctionalListenersTest.launderLatches(latches, 1);
        return t;
    }

    public static <T> T awaitEventIfOwnerAndLaunderLatch(boolean isOwner, CompletableFuture<T> cf, List<CountDownLatch> latches) {
        if (isOwner) {
            T t = FunctionalListenersTest.awaitEvent(cf, latches.get(0));
            FunctionalListenersTest.launderLatches(latches, 1);
            return t;
        }
        return FunctionalListenersTest.awaitNoEvent(cf, latches.get(0));
    }

    public static final class TrackingRemoveOnWriteListener<K, V>
    implements Listeners.WriteListeners.WriteListener<K, V> {
        CountDownLatch latch = new CountDownLatch(1);

        public void onWrite(EntryView.ReadEntryView<K, V> write) {
            AssertJUnit.assertFalse((boolean)write.find().isPresent());
            this.latchCountAndLaunder();
        }

        private void latchCountAndLaunder() {
            this.latch.countDown();
            this.latch = new CountDownLatch(1);
        }
    }

    public static final class TrackingWriteListener<K, V>
    implements Listeners.WriteListeners.WriteListener<K, V> {
        CountDownLatch latch = new CountDownLatch(1);

        public void onWrite(EntryView.ReadEntryView<K, V> write) {
            AssertJUnit.assertEquals((Object)"write", (Object)write.get());
            this.latchCountAndLaunder();
        }

        private void latchCountAndLaunder() {
            this.latch.countDown();
            this.latch = new CountDownLatch(1);
        }
    }

    private static final class TrackingReadWriteListener<K, V>
    implements Listeners.ReadWriteListeners.ReadWriteListener<K, V> {
        CountDownLatch latch = new CountDownLatch(1);

        private TrackingReadWriteListener() {
        }

        public void onCreate(EntryView.ReadEntryView<K, V> created) {
            AssertJUnit.assertEquals((Object)"created", (Object)created.get());
            this.latchCountAndLaunder();
        }

        public void onModify(EntryView.ReadEntryView<K, V> before, EntryView.ReadEntryView<K, V> after) {
            AssertJUnit.assertEquals((Object)"created", (Object)before.get());
            AssertJUnit.assertEquals((Object)"modified", (Object)after.get());
            this.latchCountAndLaunder();
        }

        public void onRemove(EntryView.ReadEntryView<K, V> removed) {
            AssertJUnit.assertEquals((Object)"modified", (Object)removed.get());
            this.latchCountAndLaunder();
        }

        private void latchCountAndLaunder() {
            this.latch.countDown();
            this.latch = new CountDownLatch(1);
        }
    }
}

