/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeFunctionWith;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.functional.AbstractFunctionalTest;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalMapTest")
public class FunctionalMapTest
extends AbstractFunctionalTest {
    public void testLocalWriteConstantAndReadGetsValue() {
        this.doWriteConstantAndReadGetsValue(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.ro(this.fmapL1), FunctionalTestUtils.wo(this.fmapL2));
    }

    public void testReplWriteConstantAndReadGetsValueOnNonOwner() {
        this.doWriteConstantAndReadGetsValue(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testReplWriteConstantAndReadGetsValueOnOwner() {
        this.doWriteConstantAndReadGetsValue(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testDistWriteConstantAndReadGetsValueOnNonOwner() {
        this.doWriteConstantAndReadGetsValue(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    public void testDistWriteConstantAndReadGetsValueOnOwner() {
        this.doWriteConstantAndReadGetsValue(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    private <K> void doWriteConstantAndReadGetsValue(Supplier<K> keySupplier, FunctionalMap.ReadOnlyMap<K, String> map1, FunctionalMap.WriteOnlyMap<K, String> map2) {
        Object key = keySupplier.get();
        FunctionalTestUtils.await(map2.eval(key, (Consumer)SetStringConstant.INSTANCE).thenCompose(r -> map1.eval(key, MarshallableFunctions.returnReadOnlyFindOrNull()).thenAccept(v -> {
            AssertJUnit.assertNull((Object)r);
            AssertJUnit.assertEquals((String)"one", (String)v);
        })));
    }

    public void testLocalWriteValueAndReadValueAndMetadata() {
        this.doWriteValueAndReadValueAndMetadata(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.ro(this.fmapL1), FunctionalTestUtils.wo(this.fmapL2));
    }

    public void testReplWriteValueAndReadValueAndMetadataOnNonOwner() {
        this.doWriteValueAndReadValueAndMetadata(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testReplWriteValueAndReadValueAndMetadataOnOwner() {
        this.doWriteValueAndReadValueAndMetadata(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testDistWriteValueAndReadValueAndMetadataOnNonOwner() {
        this.doWriteValueAndReadValueAndMetadata(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    public void testDistWriteValueAndReadValueAndMetadataOnOwner() {
        this.doWriteValueAndReadValueAndMetadata(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    private <K> void doWriteValueAndReadValueAndMetadata(Supplier<K> keySupplier, FunctionalMap.ReadOnlyMap<K, String> map1, FunctionalMap.WriteOnlyMap<K, String> map2) {
        Object key = keySupplier.get();
        FunctionalTestUtils.await(map2.eval(key, (Object)"one", (BiConsumer)SetValueAndConstantLifespan.getInstance()).thenCompose(r -> map1.eval(key, MarshallableFunctions.identity()).thenAccept(ro -> {
            AssertJUnit.assertNull((Object)r);
            AssertJUnit.assertEquals(Optional.of("one"), (Object)ro.find());
            AssertJUnit.assertEquals((String)"one", (String)((String)ro.get()));
            AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaLifespan(100000L)), (Object)ro.findMetaParam(MetaParam.MetaLifespan.class));
        })));
    }

    public void testLocalReadWriteGetsEmpty() {
        this.doReadWriteGetsEmpty(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.rw(this.fmapL1));
    }

    public void testReplReadWriteGetsEmptyOnNonOwner() {
        this.doReadWriteGetsEmpty(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.rw(this.fmapR1));
    }

    public void testReplReadWriteGetsEmptyOnOwner() {
        this.doReadWriteGetsEmpty(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.rw(this.fmapR1));
    }

    public void testDistReadWriteGetsEmptyOnNonOwner() {
        this.doReadWriteGetsEmpty(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.rw(this.fmapD1));
    }

    public void testDistReadWriteGetsEmptyOnOwner() {
        this.doReadWriteGetsEmpty(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.rw(this.fmapD1));
    }

    <K> void doReadWriteGetsEmpty(Supplier<K> keySupplier, FunctionalMap.ReadWriteMap<K, String> map) {
        K key = keySupplier.get();
        FunctionalTestUtils.await(map.eval(key, MarshallableFunctions.returnReadWriteFind()).thenAccept(v -> AssertJUnit.assertEquals(Optional.empty(), (Object)v)));
    }

    public void testLocalReadWriteValuesReturnPrevious() {
        this.doReadWriteConstantReturnPrev(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.rw(this.fmapL1), FunctionalTestUtils.rw(this.fmapL2));
    }

    public void testReplReadWriteValuesReturnPreviousOnNonOwner() {
        this.doReadWriteConstantReturnPrev(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testReplReadWriteValuesReturnPreviousOnOwner() {
        this.doReadWriteConstantReturnPrev(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testDistReadWriteValuesReturnPreviousOnNonOwner() {
        this.doReadWriteConstantReturnPrev(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    public void testDistReadWriteValuesReturnPreviousOnOwner() {
        this.doReadWriteConstantReturnPrev(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    private <K> void doReadWriteConstantReturnPrev(Supplier<K> keySupplier, FunctionalMap.ReadWriteMap<K, String> map1, FunctionalMap.ReadWriteMap<K, String> map2) {
        Object key = keySupplier.get();
        FunctionalTestUtils.await(map2.eval(key, (Function)SetStringConstantReturnPrevious.getInstance()).thenCompose(r -> map1.eval(key, MarshallableFunctions.returnReadWriteGet()).thenAccept(v -> {
            AssertJUnit.assertFalse((boolean)r.isPresent());
            AssertJUnit.assertEquals((String)"one", (String)v);
        })));
    }

    public void testLocalReadWriteForConditionalParamBasedReplace() {
        this.assumeNonTransactional();
        this.doReadWriteForConditionalParamBasedReplace(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.rw(this.fmapL1), FunctionalTestUtils.rw(this.fmapL2));
    }

    public void testReplReadWriteForConditionalParamBasedReplaceOnNonOwner() {
        this.assumeNonTransactional();
        this.doReadWriteForConditionalParamBasedReplace(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testReplReadWriteForConditionalParamBasedReplaceOnOwner() {
        this.assumeNonTransactional();
        this.doReadWriteForConditionalParamBasedReplace(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testDistReadWriteForConditionalParamBasedReplaceOnNonOwner() {
        this.assumeNonTransactional();
        this.doReadWriteForConditionalParamBasedReplace(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    public void testDistReadWriteForConditionalParamBasedReplaceOnOwner() {
        this.assumeNonTransactional();
        this.doReadWriteForConditionalParamBasedReplace(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    <K> void doReadWriteForConditionalParamBasedReplace(Supplier<K> keySupplier, FunctionalMap.ReadWriteMap<K, String> map1, FunctionalMap.ReadWriteMap<K, String> map2) {
        this.replaceWithVersion(keySupplier, map1, map2, 100L, rw -> {
            AssertJUnit.assertEquals((String)"uno", (String)((String)rw.get()));
            AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L))), (Object)rw.findMetaParam(MetaParam.MetaEntryVersion.class));
        });
        this.replaceWithVersion(keySupplier, map1, map2, 900L, rw -> {
            AssertJUnit.assertEquals(Optional.of("one"), (Object)rw.find());
            AssertJUnit.assertEquals(Optional.of(new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(100L))), (Object)rw.findMetaParam(MetaParam.MetaEntryVersion.class));
        });
    }

    private <K> void replaceWithVersion(Supplier<K> keySupplier, FunctionalMap.ReadWriteMap<K, String> map1, FunctionalMap.ReadWriteMap<K, String> map2, long version, Consumer<EntryView.ReadWriteEntryView<K, String>> asserts) {
        Object key = keySupplier.get();
        FunctionalTestUtils.await(map1.eval(key, (Function)SetStringAndVersionConstant.getInstance()).thenCompose(r -> map2.eval(key, new VersionBasedConditionalReplace(version)).thenAccept(rw -> {
            AssertJUnit.assertNull((Object)r);
            asserts.accept((EntryView.ReadWriteEntryView)rw);
        })));
    }

    public void testAutoClose() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() throws Exception {
                Configuration configBuilder = new ConfigurationBuilder().build();
                this.cm.defineConfiguration("read-only", configBuilder);
                AdvancedCache readOnlyCache = FunctionalMapTest.this.getAdvancedCache(this.cm, "read-only");
                try (FunctionalMap.ReadOnlyMap ro = ReadOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(readOnlyCache));){
                    AssertJUnit.assertNotNull((Object)ro);
                }
                AssertJUnit.assertTrue((boolean)readOnlyCache.getStatus().isTerminated());
                this.cm.defineConfiguration("write-only", configBuilder);
                AdvancedCache writeOnlyCache = FunctionalMapTest.this.getAdvancedCache(this.cm, "write-only");
                try (FunctionalMap.WriteOnlyMap wo = WriteOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(writeOnlyCache));){
                    AssertJUnit.assertNotNull((Object)wo);
                }
                AssertJUnit.assertTrue((boolean)writeOnlyCache.getStatus().isTerminated());
                this.cm.defineConfiguration("read-write", configBuilder);
                AdvancedCache readWriteCache = FunctionalMapTest.this.getAdvancedCache(this.cm, "read-write");
                try (FunctionalMap.ReadWriteMap rw = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(readWriteCache));){
                    AssertJUnit.assertNotNull((Object)rw);
                }
                AssertJUnit.assertTrue((boolean)readWriteCache.getStatus().isTerminated());
            }
        });
    }

    public void testLocalReadOnlyEvalManyEmpty() {
        this.doReadOnlyEvalManyEmpty(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.ro(this.fmapL1));
    }

    public void testReplReadOnlyEvalManyEmptyOnNonOwner() {
        this.doReadOnlyEvalManyEmpty(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.ro(this.fmapR1));
    }

    public void testReplReadOnlyEvalManyEmptyOnOwner() {
        this.doReadOnlyEvalManyEmpty(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.ro(this.fmapR1));
    }

    public void testDistReadOnlyEvalManyEmptyOnNonOwner() {
        this.doReadOnlyEvalManyEmpty(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.ro(this.fmapD1));
    }

    public void testDistReadOnlyEvalManyEmptyOnOwner() {
        this.doReadOnlyEvalManyEmpty(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.ro(this.fmapD1));
    }

    private <K> void doReadOnlyEvalManyEmpty(Supplier<K> keySupplier, FunctionalMap.ReadOnlyMap<K, String> map) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        Traversable t = map.evalMany(new HashSet<Object>(Arrays.asList(key1, key2, key3)), MarshallableFunctions.identity());
        t.forEach(ro -> AssertJUnit.assertFalse((boolean)ro.find().isPresent()));
    }

    public void testLocalUpdateSubsetAndReturnPrevs() {
        this.doUpdateSubsetAndReturnPrevs(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.ro(this.fmapL1), FunctionalTestUtils.wo(this.fmapL2), FunctionalTestUtils.rw(this.fmapL2));
    }

    public void testReplUpdateSubsetAndReturnPrevsOnNonOwner() {
        this.doUpdateSubsetAndReturnPrevs(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testReplUpdateSubsetAndReturnPrevsOnOwner() {
        this.doUpdateSubsetAndReturnPrevs(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testDistUpdateSubsetAndReturnPrevsOnNonOwner() {
        this.doUpdateSubsetAndReturnPrevs(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2), FunctionalTestUtils.rw(this.fmapD2));
    }

    public void testDistUpdateSubsetAndReturnPrevsOnOwner() {
        this.doUpdateSubsetAndReturnPrevs(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2), FunctionalTestUtils.rw(this.fmapD2));
    }

    private <K> void doUpdateSubsetAndReturnPrevs(Supplier<K> keySupplier, FunctionalMap.ReadOnlyMap<K, String> map1, FunctionalMap.WriteOnlyMap<K, String> map2, FunctionalMap.ReadWriteMap<K, String> map3) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "three");
        FunctionalTestUtils.await(map2.evalMany(data, MarshallableFunctions.setValueConsumer()));
        Traversable currentValues = map1.evalMany(data.keySet(), MarshallableFunctions.returnReadOnlyFindOrNull());
        List collectedValues = (List)currentValues.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.sort(collectedValues);
        ArrayList dataValues = new ArrayList(data.values());
        Collections.sort(dataValues);
        AssertJUnit.assertEquals((Object)collectedValues, dataValues);
        HashMap<K, String> newData = new HashMap<K, String>();
        newData.put(key1, "bat");
        newData.put(key2, "bi");
        newData.put(key3, "hiru");
        Traversable prevTraversable = map3.evalMany(newData, MarshallableFunctions.setValueReturnPrevOrNull());
        List collectedPrev = (List)prevTraversable.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.sort(collectedPrev);
        AssertJUnit.assertEquals(dataValues, (Object)collectedPrev);
        Traversable updatedValues = map1.evalMany(data.keySet(), MarshallableFunctions.returnReadOnlyFindOrNull());
        List collectedUpdates = (List)updatedValues.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.sort(collectedUpdates);
        ArrayList newDataValues = new ArrayList(newData.values());
        Collections.sort(newDataValues);
        AssertJUnit.assertEquals(newDataValues, (Object)collectedUpdates);
    }

    public void testLocalReadWriteToRemoveAllAndReturnPrevs() {
        this.doReadWriteToRemoveAllAndReturnPrevs(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.wo(this.fmapL1), FunctionalTestUtils.rw(this.fmapL2));
    }

    public void testReplReadWriteToRemoveAllAndReturnPrevsOnNonOwner() {
        this.doReadWriteToRemoveAllAndReturnPrevs(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.wo(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testReplReadWriteToRemoveAllAndReturnPrevsOnOwner() {
        this.doReadWriteToRemoveAllAndReturnPrevs(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.wo(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testDistReadWriteToRemoveAllAndReturnPrevsOnNonOwner() {
        this.doReadWriteToRemoveAllAndReturnPrevs(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.wo(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    public void testDistReadWriteToRemoveAllAndReturnPrevsOnOwner() {
        this.doReadWriteToRemoveAllAndReturnPrevs(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.wo(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    <K> void doReadWriteToRemoveAllAndReturnPrevs(Supplier<K> keySupplier, FunctionalMap.WriteOnlyMap<K, String> map1, FunctionalMap.ReadWriteMap<K, String> map2) {
        K key1 = keySupplier.get();
        K key2 = keySupplier.get();
        K key3 = keySupplier.get();
        HashMap<K, String> data = new HashMap<K, String>();
        data.put(key1, "one");
        data.put(key2, "two");
        data.put(key3, "three");
        FunctionalTestUtils.await(map1.evalMany(data, MarshallableFunctions.setValueConsumer()));
        Traversable prevTraversable = map2.evalAll(MarshallableFunctions.removeReturnPrevOrNull());
        Set prevValues = (Set)prevTraversable.collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        AssertJUnit.assertEquals(new HashSet(data.values()), (Object)prevValues);
    }

    public void testLocalReturnViewFromReadOnlyEval() {
        this.doReturnViewFromReadOnlyEval(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.ro(this.fmapL1), FunctionalTestUtils.wo(this.fmapL2));
    }

    public void testReplReturnViewFromReadOnlyEvalOnNonOwner() {
        this.doReturnViewFromReadOnlyEval(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testReplReturnViewFromReadOnlyEvalOnOwner() {
        this.doReturnViewFromReadOnlyEval(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.ro(this.fmapR1), FunctionalTestUtils.wo(this.fmapR2));
    }

    public void testDistReturnViewFromReadOnlyEvalOnNonOwner() {
        this.doReturnViewFromReadOnlyEval(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    public void testDistReturnViewFromReadOnlyEvalOnOwner() {
        this.doReturnViewFromReadOnlyEval(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.ro(this.fmapD1), FunctionalTestUtils.wo(this.fmapD2));
    }

    <K> void doReturnViewFromReadOnlyEval(Supplier<K> keySupplier, FunctionalMap.ReadOnlyMap<K, String> ro, FunctionalMap.WriteOnlyMap<K, String> wo) {
        K k = keySupplier.get();
        FunctionalTestUtils.assertReadOnlyViewEmpty(k, (EntryView.ReadEntryView)FunctionalTestUtils.await(ro.eval(k, MarshallableFunctions.identity())));
        FunctionalTestUtils.await(wo.eval(k, (SerializableConsumer & Serializable)wv -> wv.set((Object)"one", new MetaParam.Writable[0])));
        FunctionalTestUtils.assertReadOnlyViewEquals(k, "one", (EntryView.ReadEntryView)FunctionalTestUtils.await(ro.eval(k, MarshallableFunctions.identity())));
    }

    public void testLocalReturnViewFromReadWriteEval() {
        this.doReturnViewFromReadWriteEval(FunctionalTestUtils.supplyIntKey(), FunctionalTestUtils.rw(this.fmapL1), FunctionalTestUtils.rw(this.fmapL2));
    }

    public void testReplReturnViewFromReadWriteEvalOnNonOwner() {
        this.doReturnViewFromReadWriteEval(this.supplyKeyForCache(0, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testReplReturnViewFromReadWriteEvalOnOwner() {
        this.doReturnViewFromReadWriteEval(this.supplyKeyForCache(1, "repl"), FunctionalTestUtils.rw(this.fmapR1), FunctionalTestUtils.rw(this.fmapR2));
    }

    public void testDistReturnViewFromReadWriteEvalOnNonOwner() {
        this.doReturnViewFromReadWriteEval(this.supplyKeyForCache(0, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    public void testDistReturnViewFromReadWriteEvalOnOwner() {
        this.doReturnViewFromReadWriteEval(this.supplyKeyForCache(1, "dist"), FunctionalTestUtils.rw(this.fmapD1), FunctionalTestUtils.rw(this.fmapD2));
    }

    <K> void doReturnViewFromReadWriteEval(Supplier<K> keySupplier, FunctionalMap.ReadWriteMap<K, String> readMap, FunctionalMap.ReadWriteMap<K, String> writeMap) {
        K k = keySupplier.get();
        FunctionalTestUtils.assertReadWriteViewEmpty(k, (EntryView.ReadWriteEntryView)FunctionalTestUtils.await(readMap.eval(k, MarshallableFunctions.returnReadWriteView())));
        FunctionalTestUtils.assertReadWriteViewEquals(k, "one", (EntryView.ReadWriteEntryView)FunctionalTestUtils.await(writeMap.eval(k, this.setOneReadWrite())));
        FunctionalTestUtils.assertReadWriteViewEquals(k, "one", (EntryView.ReadWriteEntryView)FunctionalTestUtils.await(readMap.eval(k, MarshallableFunctions.returnReadWriteView())));
        FunctionalTestUtils.assertReadWriteViewEquals(k, "uno", (EntryView.ReadWriteEntryView)FunctionalTestUtils.await(writeMap.eval(k, (Object)"uno", MarshallableFunctions.setValueReturnView())));
        FunctionalTestUtils.assertReadWriteViewEquals(k, "uno", (EntryView.ReadWriteEntryView)FunctionalTestUtils.await(readMap.eval(k, MarshallableFunctions.returnReadWriteView())));
    }

    private <K> SerializableFunction<EntryView.ReadWriteEntryView<K, String>, EntryView.ReadWriteEntryView<K, String>> setOneReadWrite() {
        return (SerializableFunction & Serializable)rw -> {
            rw.set((Object)"one", new MetaParam.Writable[0]);
            return rw;
        };
    }

    private void assumeNonTransactional() {
        SkipTestNG.skipIf((this.transactional == Boolean.TRUE ? 1 : 0) != 0, (String)"Transactions use SimpleClusteredVersions, not NumericVersions, and user is not supposed to modify those");
    }

    @SerializeFunctionWith(value=Externalizer0.class)
    private static final class VersionBasedConditionalReplace<K>
    implements Function<EntryView.ReadWriteEntryView<K, String>, EntryView.ReadWriteEntryView<K, String>> {
        private final long version;

        private VersionBasedConditionalReplace(long version) {
            this.version = version;
        }

        @Override
        public EntryView.ReadWriteEntryView<K, String> apply(EntryView.ReadWriteEntryView<K, String> rw) {
            Optional metaParam = rw.findMetaParam(MetaParam.MetaEntryVersion.class);
            metaParam.ifPresent(metaVersion -> {
                if (metaVersion.get().compareTo((EntryVersion)new NumericVersion(this.version)) == InequalVersionComparisonResult.EQUAL) {
                    rw.set((Object)"uno", new MetaParam.Writable[]{new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(200L))});
                }
            });
            return rw;
        }

        public static final class Externalizer0
        implements Externalizer<VersionBasedConditionalReplace<?>> {
            public void writeObject(ObjectOutput output, VersionBasedConditionalReplace<?> object) throws IOException {
                output.writeLong(((VersionBasedConditionalReplace)object).version);
            }

            public VersionBasedConditionalReplace<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                long version = input.readLong();
                return new VersionBasedConditionalReplace(version);
            }
        }
    }

    @SerializeFunctionWith(value=Externalizer0.class)
    private static final class SetStringAndVersionConstant<K>
    implements Function<EntryView.ReadWriteEntryView<K, String>, Void> {
        private static final SetStringAndVersionConstant INSTANCE = new SetStringAndVersionConstant();

        private SetStringAndVersionConstant() {
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, String> rw) {
            rw.set((Object)"one", new MetaParam.Writable[]{new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(100L))});
            return null;
        }

        private static <K> SetStringAndVersionConstant<K> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeFunctionWith(value=Externalizer0.class)
    private static final class SetStringConstantReturnPrevious<K>
    implements Function<EntryView.ReadWriteEntryView<K, String>, Optional<String>> {
        private static final SetStringConstantReturnPrevious INSTANCE = new SetStringConstantReturnPrevious();

        private SetStringConstantReturnPrevious() {
        }

        @Override
        public Optional<String> apply(EntryView.ReadWriteEntryView<K, String> rw) {
            Optional prev = rw.find();
            rw.set((Object)"one", new MetaParam.Writable[0]);
            return prev;
        }

        private static <K> SetStringConstantReturnPrevious<K> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class SetValueAndConstantLifespan<K, V>
    implements BiConsumer<V, EntryView.WriteEntryView<K, V>> {
        private static final SetValueAndConstantLifespan INSTANCE = new SetValueAndConstantLifespan();

        private SetValueAndConstantLifespan() {
        }

        @Override
        public void accept(V v, EntryView.WriteEntryView<K, V> wo) {
            wo.set(v, new MetaParam.Writable[]{new MetaParam.MetaLifespan(100000L)});
        }

        private static <K, V> SetValueAndConstantLifespan<K, V> getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class SetStringConstant<K>
    implements Consumer<EntryView.WriteEntryView<K, String>> {
        private static final SetStringConstant INSTANCE = new SetStringConstant();

        private SetStringConstant() {
        }

        @Override
        public void accept(EntryView.WriteEntryView<K, String> wo) {
            wo.set((Object)"one", new MetaParam.Writable[0]);
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }
}

