/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.functional.AbstractFunctionalOpTest;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.RemoteException;
import org.infinispan.scattered.Utils;
import org.infinispan.test.TestException;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalScatteredInMemoryTest")
public class FunctionalScatteredInMemoryTest
extends AbstractFunctionalOpTest {
    AdvancedCache<Object, String> scatteredCache;
    FunctionalMapImpl<Object, String> fmapS1;
    FunctionalMapImpl<Object, String> fmapS2;
    FunctionalMap.ReadOnlyMap<Object, String> sro;
    FunctionalMap.WriteOnlyMap<Object, String> swo;
    FunctionalMap.ReadWriteMap<Object, String> srw;

    @Override
    public Object[] factory() {
        return new Object[]{new FunctionalScatteredInMemoryTest().biasAcquisition(BiasAcquisition.NEVER), new FunctionalScatteredInMemoryTest().biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    @Override
    protected void initMaps() {
        super.initMaps();
        this.scatteredCache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("scattered").getAdvancedCache();
        this.fmapS1 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(0), "scattered"));
        this.fmapS2 = FunctionalMapImpl.create(this.getAdvancedCache((EmbeddedCacheManager)this.cacheManagers.get(1), "scattered"));
        this.sro = ReadOnlyMapImpl.create(this.fmapS1);
        this.swo = WriteOnlyMapImpl.create(this.fmapS1);
        this.srw = ReadWriteMapImpl.create(this.fmapS1);
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testWrite(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "scattered");
        method.eval(key, this.swo, this.srw, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value", new MetaParam.Writable[0]), this.getClass());
        this.assertInvocations(1);
        this.caches("scattered").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalScatteredInMemoryTest.getAddress((Cache<Object, Object>)cache).toString()));
        Utils.assertOwnershipAndNonOwnership(this.caches("scattered"), key);
        method.eval(key, this.swo, this.srw, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
        this.assertInvocations(2);
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testExceptionPropagation(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "scattered");
        try {
            method.eval(key, this.swo, this.srw, (SerializableFunction & Serializable)view -> null, (SerializableBiConsumer & Serializable)(view, nil) -> {
                throw new TestException();
            }, this.getClass());
            Assert.fail((String)"Should throw CompletionException:CacheException:[RemoteException:]*TestException");
        }
        catch (CompletionException | CacheException e) {
            Throwable t = e;
            Exceptions.assertException(CompletionException.class, (Throwable)t);
            Exceptions.assertExceptionNonStrict(CacheException.class, (Throwable)t);
            for (t = t.getCause(); t.getCause() instanceof RemoteException && t != t.getCause(); t = t.getCause()) {
            }
            Exceptions.assertException(TestException.class, (Throwable)t.getCause());
        }
    }

    @Test(dataProvider="owningModeAndReadWrites")
    public void testWriteOnMissingValue(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Object key = this.getKey(isOwner, "scattered");
        try {
            method.eval(key, null, this.srw, (SerializableFunction & Serializable)view -> (String)view.get(), (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
            Assert.fail((String)"Should throw CompletionException:CacheException:[RemoteException:]*NoSuchElementException");
        }
        catch (CompletionException e) {
            Throwable t = e;
            Exceptions.assertException(CompletionException.class, (Throwable)t);
            Exceptions.assertExceptionNonStrict(CacheException.class, (Throwable)t);
            for (t = t.getCause(); t.getCause() instanceof RemoteException && t != t.getCause(); t = t.getCause()) {
            }
            Exceptions.assertException(NoSuchElementException.class, (Throwable)t.getCause());
        }
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadLoad(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) {
        Object key = this.getKey(isOwner, "scattered");
        Assert.assertTrue((boolean)((Boolean)method.eval(key, this.sro, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return true;
        })));
        this.cache(0, "scattered").put(key, (Object)"value");
        this.caches("scattered").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalScatteredInMemoryTest.getAddress((Cache<Object, Object>)cache).toString()));
        Utils.assertOwnershipAndNonOwnership(this.caches("scattered"), key);
        Assert.assertEquals((String)((String)method.eval(key, this.sro, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return "OK";
        })), (String)"OK");
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadOnMissingValue(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) {
        this.testReadOnMissingValue(this.getKey(isOwner, "scattered"), this.sro, method);
    }
}

