/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;

public final class FunctionalTestUtils {
    public static final int MAX_WAIT_SECS = 30;
    private static final Random R = new Random();

    public static <K> FunctionalMap.ReadOnlyMap<K, String> ro(FunctionalMapImpl<K, String> fmap) {
        return ReadOnlyMapImpl.create(fmap);
    }

    public static <K> FunctionalMap.WriteOnlyMap<K, String> wo(FunctionalMapImpl<K, String> fmap) {
        return WriteOnlyMapImpl.create(fmap);
    }

    public static <K> FunctionalMap.ReadWriteMap<K, String> rw(FunctionalMapImpl<K, String> fmap) {
        return ReadWriteMapImpl.create(fmap);
    }

    public static <K, V> FunctionalMap.ReadOnlyMap<K, V> ro(AdvancedCache<K, V> cache) {
        FunctionalMapImpl impl = FunctionalMapImpl.create(cache);
        return ReadOnlyMapImpl.create((FunctionalMapImpl)impl);
    }

    public static <K, V> FunctionalMap.ReadWriteMap<K, V> rw(Cache<K, V> cache) {
        FunctionalMapImpl impl = FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache());
        return ReadWriteMapImpl.create((FunctionalMapImpl)impl);
    }

    public static <K, V> FunctionalMap.WriteOnlyMap<K, V> wo(Cache<K, V> cache) {
        FunctionalMapImpl impl = FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache());
        return WriteOnlyMapImpl.create((FunctionalMapImpl)impl);
    }

    static Supplier<Integer> supplyIntKey() {
        return () -> R.nextInt(Integer.MAX_VALUE);
    }

    public static <T> T await(CompletableFuture<T> cf) {
        return (T)CompletionStages.join(cf);
    }

    public static <T> T await(CompletionStage<T> cf) {
        try {
            return cf.toCompletableFuture().get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Error(e);
        }
    }

    public static <T> List<T> await(List<CompletableFuture<T>> cf) {
        return (List)FunctionalTestUtils.await(CompletableFutures.sequence(cf));
    }

    public static <K> void assertReadOnlyViewEmpty(K k, EntryView.ReadEntryView<K, ?> ro) {
        AssertJUnit.assertEquals(k, (Object)ro.key());
        AssertJUnit.assertFalse((boolean)ro.find().isPresent());
    }

    public static <K, V> void assertReadOnlyViewEquals(K k, V expected, EntryView.ReadEntryView<K, V> ro) {
        AssertJUnit.assertEquals(k, (Object)ro.key());
        AssertJUnit.assertTrue((boolean)ro.find().isPresent());
        AssertJUnit.assertEquals(expected, ro.find().get());
        AssertJUnit.assertEquals(expected, (Object)ro.get());
    }

    public static <K> void assertReadWriteViewEmpty(K k, EntryView.ReadWriteEntryView<K, ?> rw) {
        AssertJUnit.assertEquals(k, (Object)rw.key());
        AssertJUnit.assertFalse((boolean)rw.find().isPresent());
    }

    public static <K, V> void assertReadWriteViewEquals(K k, V expected, EntryView.ReadWriteEntryView<K, V> rw) {
        AssertJUnit.assertEquals(k, (Object)rw.key());
        AssertJUnit.assertTrue((boolean)rw.find().isPresent());
        AssertJUnit.assertEquals(expected, rw.find().get());
        AssertJUnit.assertEquals(expected, (Object)rw.get());
        try {
            rw.set(null, new MetaParam.Writable[0]);
            AssertJUnit.fail((String)"Expected IllegalStateException since entry view cannot be modified outside lambda");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private FunctionalTestUtils() {
    }
}

