/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.stream.IntStream;
import javax.transaction.TransactionManager;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.functional.AbstractFunctionalOpTest;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalInMemoryTest;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalTxInMemoryTest")
public class FunctionalTxInMemoryTest
extends FunctionalInMemoryTest {
    private static final int NUM_KEYS = 2;
    private static final Integer[] INT_KEYS = (Integer[])IntStream.range(0, 2).boxed().toArray(Integer[]::new);
    TransactionManager tm;

    @Override
    public Object[] factory() {
        return new Object[]{new FunctionalTxInMemoryTest().transactional(true).lockingMode(LockingMode.OPTIMISTIC).isolationLevel(IsolationLevel.READ_COMMITTED), new FunctionalTxInMemoryTest().transactional(true).lockingMode(LockingMode.PESSIMISTIC).isolationLevel(IsolationLevel.READ_COMMITTED), new FunctionalTxInMemoryTest().transactional(true).lockingMode(LockingMode.PESSIMISTIC).isolationLevel(IsolationLevel.REPEATABLE_READ)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache(0)).getComponent(TransactionManager.class);
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadLoads(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        Object[] keys;
        for (Object key : keys = this.getKeys(isOwner, 2)) {
            this.cache(0, "dist").put(key, key);
        }
        this.tm.begin();
        for (Object key : keys) {
            AssertJUnit.assertEquals((String)((String)method.eval(key, this.ro, (SerializableFunction & Serializable)e -> {
                AssertJUnit.assertTrue((boolean)e.find().isPresent());
                AssertJUnit.assertEquals((Object)e.get(), (Object)e.key());
                return "OK";
            })), (String)"OK");
        }
        this.tm.commit();
    }

    @Test(dataProvider="readMethods")
    public void testReadLoadsLocal(AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        Integer[] keys;
        for (Integer key : keys = INT_KEYS) {
            this.cache(0).put((Object)key, (Object)key);
        }
        this.tm.begin();
        for (Integer key : keys) {
            AssertJUnit.assertEquals((String)((String)method.eval(key, this.lro, (SerializableFunction & Serializable)e -> {
                AssertJUnit.assertTrue((boolean)e.find().isPresent());
                AssertJUnit.assertEquals((Object)e.get(), (Object)e.key());
                return "OK";
            })), (String)"OK");
        }
        this.tm.commit();
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadsAfterMods(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        Object KEY = this.getKey(isOwner, "dist");
        this.cache(0, "dist").put(KEY, (Object)"a");
        this.tm.begin();
        AssertJUnit.assertEquals((String)"a", (String)((String)this.rw.eval(KEY, FunctionalTxInMemoryTest.append("b")).join()));
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.rw.evalMany(Collections.singleton(KEY), FunctionalTxInMemoryTest.append("c")).findAny().get()));
        AssertJUnit.assertEquals(null, (String)((String)this.rw.eval((Object)"otherKey", FunctionalTxInMemoryTest.append("d")).join()));
        AssertJUnit.assertEquals((String)"abc", (String)((String)method.eval(KEY, this.ro, MarshallableFunctions.returnReadOnlyFindOrNull())));
        this.tm.commit();
    }

    @Test(dataProvider="owningModeAndReadWrites")
    public void testReadWriteAfterMods(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) throws Exception {
        Object KEY = this.getKey(isOwner, "dist");
        this.cache(0, "dist").put(KEY, (Object)"a");
        this.tm.begin();
        AssertJUnit.assertEquals((String)"a", (String)((String)this.rw.eval(KEY, FunctionalTxInMemoryTest.append("b")).join()));
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.rw.evalMany(Collections.singleton(KEY), FunctionalTxInMemoryTest.append("c")).findAny().get()));
        AssertJUnit.assertEquals(null, (String)((String)this.rw.eval((Object)"otherKey", FunctionalTxInMemoryTest.append("d")).join()));
        AssertJUnit.assertEquals((String)"abc", (String)((String)method.eval(KEY, this.wo, this.rw, MarshallableFunctions.returnReadOnlyFindOrNull(), (SerializableBiConsumer & Serializable)(e, prev) -> {}, this.getClass())));
        this.tm.commit();
    }

    public void testNonFunctionalReadsAfterMods() throws Exception {
        Object KEY = this.getKey(false, "dist");
        this.cache(0, "dist").put(KEY, (Object)"a");
        this.tm.begin();
        AssertJUnit.assertEquals((String)"a", (String)((String)this.rw.eval(KEY, FunctionalTxInMemoryTest.append("b")).join()));
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.cache.get(KEY)));
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.cache.get(KEY)));
        this.tm.commit();
        this.tm.begin();
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.rw.evalMany(Collections.singleton(KEY), FunctionalTxInMemoryTest.append("c")).findAny().get()));
        AssertJUnit.assertEquals((String)"abc", (String)((String)this.cache.put(KEY, (Object)"abcd")));
        this.tm.commit();
        this.tm.begin();
        AssertJUnit.assertEquals((String)"abcd", (String)((String)this.cache.get(KEY)));
        this.tm.commit();
        this.tm.begin();
        this.wo.eval(KEY, (Object)"x", MarshallableFunctions.setValueConsumer()).join();
        AssertJUnit.assertEquals((String)"x", (String)((String)this.cache.putIfAbsent(KEY, (Object)"otherValue")));
        this.tm.commit();
        this.tm.begin();
        this.wo.eval(KEY, MarshallableFunctions.removeConsumer()).join();
        AssertJUnit.assertNull((Object)this.cache.putIfAbsent(KEY, (Object)"y"));
        AssertJUnit.assertEquals((String)"y", (String)((String)this.ro.eval(KEY, MarshallableFunctions.returnReadOnlyFindOrNull()).join()));
        this.tm.commit();
        this.tm.begin();
        AssertJUnit.assertEquals((String)"y", (String)((String)this.rw.eval(KEY, (Object)"z", MarshallableFunctions.setValueReturnPrevOrNull()).join()));
        AssertJUnit.assertTrue((boolean)this.cache.replace(KEY, (Object)"z", (Object)"a"));
        this.tm.commit();
        this.tm.begin();
        AssertJUnit.assertEquals((String)"a", (String)((String)this.rw.eval(KEY, FunctionalTxInMemoryTest.append("b")).join()));
        AssertJUnit.assertEquals((String)"ab", (String)((String)this.cache.getAll(Collections.singleton(KEY)).get(KEY)));
        this.tm.commit();
    }

    @Test(dataProvider="owningModeAndReadWrites")
    public void testWriteModsInTxContext(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) throws Exception {
        Object KEY = this.getKey(isOwner, "dist");
        this.cache(0, "dist").put(KEY, (Object)"a");
        this.tm.begin();
        AssertJUnit.assertEquals((Object)"a", (Object)this.cache(0, "dist").put(KEY, (Object)"b"));
        AssertJUnit.assertEquals((String)"b", (String)((String)method.eval(KEY, null, this.rw, EntryView.ReadEntryView::get, (SerializableBiConsumer & Serializable)(e, prev) -> e.set((Object)(prev + "c"), new MetaParam.Writable[0]), this.getClass())));
        AssertJUnit.assertEquals((String)"bc", (String)((String)this.ro.eval(KEY, MarshallableFunctions.returnReadOnlyFindOrNull()).join()));
        this.tm.commit();
    }

    public static SerializableFunction<EntryView.ReadWriteEntryView<Object, String>, String> append(String str) {
        return (SerializableFunction & Serializable)ev -> {
            Optional prev = ev.find();
            if (prev.isPresent()) {
                ev.set((Object)((String)prev.get() + str), new MetaParam.Writable[0]);
                return (String)prev.get();
            }
            ev.set((Object)str, new MetaParam.Writable[0]);
            return null;
        };
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadOnMissingValues(boolean isOwner, AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        this.testReadOnMissingValues(this.getKeys(isOwner, 2), this.ro, method);
    }

    @Test(dataProvider="readMethods")
    public void testReadOnMissingValuesLocal(AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        this.testReadOnMissingValues(INT_KEYS, this.lro, method);
    }

    private <K> void testReadOnMissingValues(K[] keys, FunctionalMap.ReadOnlyMap<K, String> ro, AbstractFunctionalOpTest.ReadMethod method) throws Exception {
        this.tm.begin();
        for (Object key : keys) {
            Assert.assertEquals(ro.eval(key, (SerializableFunction & Serializable)view -> view.find().isPresent()).join(), (Object)Boolean.FALSE);
        }
        this.tm.commit();
        this.tm.begin();
        K[] KArray = keys;
        int n = KArray.length;
        int n2 = 0;
        if (n2 < n) {
            Object key;
            key = KArray[n2];
            Exceptions.expectExceptionNonStrict(CompletionException.class, CacheException.class, NoSuchElementException.class, () -> method.eval(key, ro, EntryView.ReadEntryView::get));
            AssertJUnit.assertEquals((int)1, (int)this.tm.getStatus());
            this.tm.rollback();
        }
        if (this.tm.getStatus() == 0) {
            this.tm.commit();
        }
    }

    private Object[] getKeys(boolean isOwner, int num) {
        return IntStream.iterate(0, i -> i + 1).mapToObj(i -> "key" + i).filter(k -> this.cache(0, "dist").getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(k) == isOwner).limit(num).toArray(Object[]::new);
    }
}

