/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.FunctionalTxInMemoryTest;
import org.infinispan.remoting.RemoteException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalWriteSkewInMemoryTest")
public class FunctionalWriteSkewInMemoryTest
extends FunctionalTxInMemoryTest {
    public FunctionalWriteSkewInMemoryTest() {
        this.transactional(true).lockingMode(LockingMode.OPTIMISTIC).isolationLevel(IsolationLevel.REPEATABLE_READ);
    }

    @Override
    protected String parameters() {
        return null;
    }

    @DataProvider(name="readCombos")
    public static Object[][] readCombos() {
        return (Object[][])Stream.of(Boolean.TRUE, Boolean.FALSE).flatMap(isOwner -> Stream.of(ReadOp.values()).flatMap(op1 -> Stream.of(ReadOp.values()).map(op2 -> new Object[]{isOwner, op1, op2}))).filter(args -> ((ReadOp)((Object)((Object)args[1]))).isFunctional() || ((ReadOp)((Object)((Object)args[2]))).isFunctional()).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="readCombos")
    public void testWriteSkew(boolean isOwner, ReadOp op1, ReadOp op2) throws Throwable {
        block7: {
            Object key = this.getKey(isOwner, "dist");
            this.cache(0, "dist").put(key, (Object)"value0");
            this.tm.begin();
            AssertJUnit.assertEquals((Object)"value0", (Object)op1.action.eval(this.cache(0, "dist"), key, (FunctionalMap.ReadOnlyMap<Object, String>)this.ro, (FunctionalMap.ReadWriteMap<Object, String>)this.rw));
            Transaction transaction = this.tm.suspend();
            this.cache(0, "dist").put(key, (Object)"value1");
            this.tm.resume(transaction);
            try {
                AssertJUnit.assertEquals((Object)"value0", (Object)op2.action.eval(this.cache(0, "dist"), key, (FunctionalMap.ReadOnlyMap<Object, String>)this.ro, (FunctionalMap.ReadWriteMap<Object, String>)this.rw));
            }
            catch (CompletionException e) {
                Exceptions.assertException(WriteSkewException.class, (Throwable)e.getCause());
                this.tm.rollback();
            }
            catch (WriteSkewException e) {
                if ($assertionsDisabled || op2 == ReadOp.GET) break block7;
                throw new AssertionError();
            }
        }
        if (this.tm.getStatus() == 0) {
            try {
                this.tm.commit();
            }
            catch (RollbackException e) {
                Throwable[] suppressed = e.getSuppressed();
                AssertJUnit.assertTrue((suppressed != null && suppressed.length == 1 ? 1 : 0) != 0);
                AssertJUnit.assertEquals(XAException.class, suppressed[0].getClass());
                Throwable cause = suppressed[0].getCause();
                while (cause instanceof RemoteException) {
                    cause = cause.getCause();
                }
                AssertJUnit.assertNotNull((Object)cause);
                AssertJUnit.assertEquals(WriteSkewException.class, cause.getClass());
            }
        }
    }

    static enum ReadOp {
        READ(true, (cache, key, ro, rw) -> ro.eval(key, EntryView.ReadEntryView::get).join()),
        READ_MANY(true, (cache, key, ro, rw) -> ro.evalMany(Collections.singleton(key), EntryView.ReadEntryView::get).findAny().get()),
        READ_WRITE_KEY(true, (cache, key, ro, rw) -> rw.eval(key, EntryView.ReadEntryView::get).join()),
        READ_WRITE_KEY_VALUE(true, (cache, key, ro, rw) -> rw.eval(key, null, (SerializableBiFunction & Serializable)(value, v) -> (String)v.get()).join()),
        READ_WRITE_MANY(true, (cache, key, ro, rw) -> rw.evalMany(Collections.singleton(key), EntryView.ReadEntryView::get).findAny().get()),
        READ_WRITE_MANY_ENTRIES(true, (cache, key, ro, rw) -> rw.evalMany(Collections.singletonMap(key, null), (SerializableBiFunction & Serializable)(value, v) -> (String)v.get()).findAny().get()),
        GET(false, (cache, key, ro, rw) -> cache.get(key));

        final Performer action;
        final boolean functional;

        private ReadOp(boolean functional, Performer action) {
            this.functional = functional;
            this.action = action;
        }

        public boolean isFunctional() {
            return this.functional;
        }

        @FunctionalInterface
        private static interface Performer {
            public Object eval(Cache var1, Object var2, FunctionalMap.ReadOnlyMap<Object, String> var3, FunctionalMap.ReadWriteMap<Object, String> var4) throws Throwable;
        }
    }
}

