/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.decorators;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.AbstractDelegatingCollection;
import org.infinispan.commons.util.AbstractDelegatingSet;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.Param;
import org.infinispan.functional.decorators.FunctionalConcurrentMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;

public final class FunctionalAdvancedCache<K, V>
implements AdvancedCache<K, V> {
    final AdvancedCache<K, V> cache;
    final ConcurrentMap<K, V> map;
    final FunctionalMap.ReadWriteMap<K, V> rw;
    final FunctionalMap.WriteOnlyMap<K, V> wo;

    private FunctionalAdvancedCache(ConcurrentMap<K, V> map, AdvancedCache<K, V> cache) {
        this.map = map;
        this.cache = cache;
        FunctionalMapImpl fmap = FunctionalMapImpl.create(cache);
        this.rw = ReadWriteMapImpl.create((FunctionalMapImpl)fmap);
        this.wo = WriteOnlyMapImpl.create((FunctionalMapImpl)fmap);
    }

    public static <K, V> AdvancedCache<K, V> create(AdvancedCache<K, V> cache) {
        return new FunctionalAdvancedCache<K, V>(FunctionalConcurrentMap.create(cache), cache);
    }

    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    public V get(Object key) {
        return this.map.get(key);
    }

    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    public V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    public V remove(Object key) {
        return this.map.remove(key);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    public int size() {
        return this.map.size();
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.cache.sizeAsync();
    }

    public CacheSet<Map.Entry<K, V>> entrySet() {
        return new SetAsCacheSet<Map.Entry<K, V>>(this.map.entrySet());
    }

    public CacheCollection<V> values() {
        return new CollectionAsCacheCollection(this.map.values());
    }

    public void clear() {
        this.map.clear();
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, lifespanUnit);
        MetaParam.MetaMaxIdle metaMaxIdle = this.createMetaMaxIdle(maxIdleTime, maxIdleTimeUnit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan, metaMaxIdle})));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, lifespanUnit);
        MetaParam.MetaMaxIdle metaMaxIdle = this.createMetaMaxIdle(maxIdleTime, maxIdleTimeUnit);
        FunctionalAdvancedCache.await(this.wo.evalMany(map, MarshallableFunctions.setValueMetasConsumer((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan, metaMaxIdle})));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, lifespanUnit);
        MetaParam.MetaMaxIdle metaMaxIdle = this.createMetaMaxIdle(maxIdleTime, maxIdleTimeUnit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasIfAbsentReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan, metaMaxIdle})));
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, lifespanUnit);
        MetaParam.MetaMaxIdle metaMaxIdle = this.createMetaMaxIdle(maxIdleTime, maxIdleTimeUnit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasIfPresentReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan, metaMaxIdle})));
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, lifespanUnit);
        MetaParam.MetaMaxIdle metaMaxIdle = this.createMetaMaxIdle(maxIdleTime, maxIdleTimeUnit);
        return (Boolean)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueIfEqualsReturnBoolean(oldValue, (MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan, metaMaxIdle})));
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, unit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan})));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, unit);
        FunctionalAdvancedCache.await(this.wo.evalMany(map, MarshallableFunctions.setValueMetasConsumer((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan})));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, unit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasIfAbsentReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan})));
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, unit);
        return (V)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueMetasIfPresentReturnPrevOrNull((MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan})));
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        MetaParam.MetaLifespan metaLifespan = this.createMetaLifespan(lifespan, unit);
        return (Boolean)FunctionalAdvancedCache.await(this.rw.eval(key, value, MarshallableFunctions.setValueIfEqualsReturnBoolean(oldValue, (MetaParam.Writable[])new MetaParam.Writable[]{metaLifespan})));
    }

    public void evict(K key) {
        FunctionalAdvancedCache.await(this.wo.withParams(new Param[]{Param.PersistenceMode.SKIP}).eval(key, MarshallableFunctions.removeConsumer()));
    }

    public void putForExternalRead(K key, V value) {
        this.map.putIfAbsent(key, value);
    }

    private MetaParam.MetaLifespan createMetaLifespan(long lifespan, TimeUnit lifespanUnit) {
        return new MetaParam.MetaLifespan(lifespanUnit.toMillis(lifespan));
    }

    private MetaParam.MetaMaxIdle createMetaMaxIdle(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new MetaParam.MetaMaxIdle(maxIdleTimeUnit.toMillis(maxIdleTime));
    }

    public RpcManager getRpcManager() {
        return this.cache.getRpcManager();
    }

    public ComponentRegistry getComponentRegistry() {
        return this.cache.getComponentRegistry();
    }

    public AdvancedCache<K, V> getAdvancedCache() {
        return this.cache.getAdvancedCache();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this.cache.withFlags(flags);
    }

    public AdvancedCache<K, V> withSubject(Subject subject) {
        return this.cache.withSubject(subject);
    }

    public Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public void stop() {
        this.cache.stop();
    }

    public void start() {
        this.cache.start();
    }

    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        return this.cache.touch(key, segment, touchEvenIfExpired);
    }

    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        return this.cache.touch(key, -1, touchEvenIfExpired);
    }

    @Deprecated
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        return this.cache.getAsyncInterceptorChain();
    }

    public EvictionManager getEvictionManager() {
        return null;
    }

    public ExpirationManager<K, V> getExpirationManager() {
        return null;
    }

    public DistributionManager getDistributionManager() {
        return null;
    }

    public AuthorizationManager getAuthorizationManager() {
        return null;
    }

    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        throw new UnsupportedOperationException("lockAs is not supported with Functional Cache!");
    }

    public boolean lock(K ... keys) {
        return false;
    }

    public boolean lock(Collection<? extends K> keys) {
        return false;
    }

    public BatchContainer getBatchContainer() {
        return null;
    }

    public DataContainer<K, V> getDataContainer() {
        return null;
    }

    public TransactionManager getTransactionManager() {
        return null;
    }

    public LockManager getLockManager() {
        return null;
    }

    public Stats getStats() {
        return null;
    }

    public XAResource getXAResource() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return null;
    }

    public V put(K key, V value, Metadata metadata) {
        return null;
    }

    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
    }

    public V replace(K key, V value, Metadata metadata) {
        return null;
    }

    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        return false;
    }

    public V putIfAbsent(K key, V value, Metadata metadata) {
        return null;
    }

    public void putForExternalRead(K key, V value, Metadata metadata) {
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        throw new UnsupportedOperationException();
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        throw new UnsupportedOperationException();
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        throw new UnsupportedOperationException();
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return null;
    }

    public Map<K, V> getAll(Set<?> keys) {
        return null;
    }

    public CacheEntry<K, V> getCacheEntry(Object key) {
        return null;
    }

    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return null;
    }

    public Map<K, V> getGroup(String groupName) {
        return null;
    }

    public void removeGroup(String groupName) {
    }

    public AvailabilityMode getAvailability() {
        return null;
    }

    public void setAvailability(AvailabilityMode availabilityMode) {
    }

    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return null;
    }

    public LockedStream<K, V> lockedStream() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> encoder) {
        return this.cache.withEncoding(encoder);
    }

    public AdvancedCache<?, ?> withKeyEncoding(Class<? extends Encoder> encoder) {
        return this.cache.withKeyEncoding(encoder);
    }

    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> keyEncoder, Class<? extends Encoder> valueEncoder) {
        return this.cache.withEncoding(keyEncoder, valueEncoder);
    }

    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapper, Class<? extends Wrapper> valueWrapper) {
        return this.cache.withWrapping(keyWrapper, valueWrapper);
    }

    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapper) {
        return this.cache.withWrapping(wrapper);
    }

    public AdvancedCache<?, ?> withMediaType(String keyMediaType, String valueMediaType) {
        return this.cache.withMediaType(keyMediaType, valueMediaType);
    }

    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        return this.cache.withMediaType(keyMediaType, valueMediaType);
    }

    public AdvancedCache<K, V> withStorageMediaType() {
        return this.cache.withStorageMediaType();
    }

    public DataConversion getKeyDataConversion() {
        return this.cache.getKeyDataConversion();
    }

    public DataConversion getValueDataConversion() {
        return this.cache.getValueDataConversion();
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
    }

    public ComponentStatus getStatus() {
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public boolean containsValue(Object value) {
        return false;
    }

    public CacheSet<K> keySet() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return null;
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return null;
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return null;
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return null;
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return null;
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return null;
    }

    public CompletableFuture<Void> clearAsync() {
        return null;
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return null;
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return null;
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return null;
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return null;
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return null;
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return null;
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return null;
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return null;
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return null;
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return null;
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return null;
    }

    public CompletableFuture<V> getAsync(K key) {
        return null;
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return null;
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return null;
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return null;
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return null;
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return null;
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return null;
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return null;
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    public boolean startBatch() {
        return false;
    }

    public void endBatch(boolean successful) {
    }

    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return null;
    }

    public CompletionStage<Void> addListenerAsync(Object listener) {
        return null;
    }

    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return null;
    }

    @Deprecated
    public Set<Object> getListeners() {
        return null;
    }

    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return null;
    }

    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return null;
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error(e);
        }
    }

    private static class CollectionAsCacheCollection<E>
    extends AbstractDelegatingCollection<E>
    implements CacheCollection<E> {
        private final Collection<E> col;

        public CollectionAsCacheCollection(Collection<E> col) {
            this.col = col;
        }

        protected Collection<E> delegate() {
            return this.col;
        }

        public CloseableIterator<E> iterator() {
            return Closeables.iterator(this.col.iterator());
        }

        public CloseableSpliterator<E> spliterator() {
            return Closeables.spliterator(this.col.spliterator());
        }

        public CacheStream<E> stream() {
            return null;
        }

        public CacheStream<E> parallelStream() {
            return null;
        }
    }

    private static final class SetAsCacheSet<E>
    extends AbstractDelegatingSet<E>
    implements CacheSet<E> {
        final Set<E> set;

        private SetAsCacheSet(Set<E> set) {
            this.set = set;
        }

        protected Set<E> delegate() {
            return this.set;
        }

        public CacheStream<E> stream() {
            return null;
        }

        public CacheStream<E> parallelStream() {
            return null;
        }

        public CloseableIterator<E> iterator() {
            return Closeables.iterator(this.set.iterator());
        }

        public CloseableSpliterator<E> spliterator() {
            return Closeables.spliterator(this.set.spliterator());
        }

        public String toString() {
            return "SetAsCacheSet{set=" + this.set + '}';
        }
    }
}

