/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.decorators;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.decorators.FunctionalListeners;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableSupplier;

public final class FunctionalConcurrentMap<K, V>
implements ConcurrentMap<K, V>,
FunctionalListeners<K, V> {
    final FunctionalMap.ReadOnlyMap<K, V> readOnly;
    final FunctionalMap.WriteOnlyMap<K, V> writeOnly;
    final FunctionalMap.ReadWriteMap<K, V> readWrite;

    private FunctionalConcurrentMap(FunctionalMapImpl<K, V> map) {
        this.readOnly = ReadOnlyMapImpl.create(map);
        this.writeOnly = WriteOnlyMapImpl.create(map);
        this.readWrite = ReadWriteMapImpl.create(map);
    }

    public static <K, V> FunctionalConcurrentMap<K, V> create(AdvancedCache<K, V> cache) {
        return new FunctionalConcurrentMap<K, V>(FunctionalMapImpl.create(cache));
    }

    @Override
    public Listeners.ReadWriteListeners<K, V> readWriteListeners() {
        return this.readWrite.listeners();
    }

    @Override
    public Listeners.WriteListeners<K, V> writeOnlyListeners() {
        return this.writeOnly.listeners();
    }

    @Override
    public int size() {
        return (int)this.readOnly.keys().count();
    }

    @Override
    public boolean isEmpty() {
        return !this.readOnly.keys().findAny().isPresent();
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)FunctionalConcurrentMap.await(this.readOnly.eval(this.toK(key), MarshallableFunctions.returnReadOnlyFindIsPresent()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.readOnly.entries().anyMatch(ro -> ro.get().equals(value));
    }

    @Override
    public V get(Object key) {
        return (V)FunctionalConcurrentMap.await(this.readOnly.eval(this.toK(key), MarshallableFunctions.returnReadOnlyFindOrNull()));
    }

    private K toK(Object key) {
        return (K)key;
    }

    private V toV(Object value) {
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        return (V)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), value, MarshallableFunctions.setValueReturnPrevOrNull()));
    }

    @Override
    public V remove(Object key) {
        return (V)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), MarshallableFunctions.removeReturnPrevOrNull()));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        FunctionalConcurrentMap.await(this.writeOnly.evalMany(m, MarshallableFunctions.setValueConsumer()));
    }

    @Override
    public void clear() {
        FunctionalConcurrentMap.await(this.writeOnly.truncate());
    }

    @Override
    public Set<K> keySet() {
        return (Set)this.readOnly.keys().collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.toSet()));
    }

    @Override
    public Collection<V> values() {
        return (Collection)this.readOnly.entries().collect(ArrayList::new, (l, v) -> l.add(v.get()), ArrayList::addAll);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.readOnly.entries().collect(HashSet::new, (s, ro) -> s.add(new FunctionalMapEntry((EntryView.ReadEntryView)ro, (FunctionalMap.WriteOnlyMap)this.writeOnly)), AbstractCollection::addAll);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), value, MarshallableFunctions.setValueIfAbsentReturnPrevOrNull()));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return (Boolean)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), this.toV(value), MarshallableFunctions.removeIfValueEqualsReturnBoolean()));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), newValue, MarshallableFunctions.setValueIfEqualsReturnBoolean(oldValue, (MetaParam.Writable[])new MetaParam.Writable[0])));
    }

    @Override
    public V replace(K key, V value) {
        return (V)FunctionalConcurrentMap.await(this.readWrite.eval(this.toK(key), value, MarshallableFunctions.setValueIfPresentReturnPrevOrNull()));
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error(e);
        }
    }

    private static final class FunctionalMapEntry<K, V>
    implements Map.Entry<K, V> {
        final EntryView.ReadEntryView<K, V> view;
        final FunctionalMap.WriteOnlyMap<K, V> writeOnly;

        private FunctionalMapEntry(EntryView.ReadEntryView<K, V> view, FunctionalMap.WriteOnlyMap<K, V> writeOnly) {
            this.view = view;
            this.writeOnly = writeOnly;
        }

        @Override
        public K getKey() {
            return (K)this.view.key();
        }

        @Override
        public V getValue() {
            return (V)this.view.get();
        }

        @Override
        public V setValue(V value) {
            Object prev = this.view.get();
            FunctionalConcurrentMap.await(this.writeOnly.eval(this.view.key(), value, MarshallableFunctions.setValueConsumer()));
            return (V)prev;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.view.key(), e.getKey()) && Objects.equals(this.view.get(), e.getValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.view.hashCode();
        }

        public String toString() {
            return "FunctionalMapEntry{view=" + this.view + '}';
        }
    }
}

