/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.decorators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.decorators.FunctionalListeners;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;

public final class FunctionalJCache<K, V>
implements Cache<K, V>,
FunctionalListeners<K, V> {
    final FunctionalMap.ReadOnlyMap<K, V> readOnly;
    final FunctionalMap.WriteOnlyMap<K, V> writeOnly;
    final FunctionalMap.ReadWriteMap<K, V> readWrite;

    private FunctionalJCache(FunctionalMapImpl<K, V> map) {
        this.readOnly = ReadOnlyMapImpl.create(map);
        this.writeOnly = WriteOnlyMapImpl.create(map);
        this.readWrite = ReadWriteMapImpl.create(map);
    }

    public static <K, V> Cache<K, V> create(AdvancedCache<K, V> cache) {
        return new FunctionalJCache<K, V>(FunctionalMapImpl.create(cache));
    }

    public static <K, V> Cache<K, V> create(FunctionalMapImpl<K, V> map) {
        return new FunctionalJCache<K, V>(map);
    }

    @Override
    public Listeners.WriteListeners<K, V> writeOnlyListeners() {
        return this.writeOnly.listeners();
    }

    @Override
    public Listeners.ReadWriteListeners<K, V> readWriteListeners() {
        return this.readWrite.listeners();
    }

    public V get(K key) {
        return (V)FunctionalJCache.await(this.readOnly.eval(key, MarshallableFunctions.returnReadOnlyFindOrNull()));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        Traversable t = this.readOnly.evalMany(keys, MarshallableFunctions.identity());
        return (Map)t.collect(HashMap::new, (m, ro) -> ro.find().ifPresent(v -> m.put(ro.key(), v)), HashMap::putAll);
    }

    public boolean containsKey(K key) {
        return (Boolean)FunctionalJCache.await(this.readOnly.eval(key, MarshallableFunctions.returnReadOnlyFindIsPresent()));
    }

    public void put(K key, V value) {
        FunctionalJCache.await(this.writeOnly.eval(key, value, MarshallableFunctions.setValueConsumer()));
    }

    public V getAndPut(K key, V value) {
        return (V)FunctionalJCache.await(this.readWrite.eval(key, value, MarshallableFunctions.setValueReturnPrevOrNull()));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        FunctionalJCache.await(this.writeOnly.evalMany(map, MarshallableFunctions.setValueConsumer()));
    }

    public boolean putIfAbsent(K key, V value) {
        return (Boolean)FunctionalJCache.await(this.readWrite.eval(key, value, MarshallableFunctions.setValueIfAbsentReturnBoolean()));
    }

    public boolean remove(K key) {
        return (Boolean)FunctionalJCache.await(this.readWrite.eval(key, MarshallableFunctions.removeReturnBoolean()));
    }

    public boolean remove(K key, V oldValue) {
        return (Boolean)FunctionalJCache.await(this.readWrite.eval(key, oldValue, MarshallableFunctions.removeIfValueEqualsReturnBoolean()));
    }

    public V getAndRemove(K key) {
        return (V)FunctionalJCache.await(this.readWrite.eval(key, MarshallableFunctions.removeReturnPrevOrNull()));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)FunctionalJCache.await(this.readWrite.eval(key, newValue, MarshallableFunctions.setValueIfEqualsReturnBoolean(oldValue, (MetaParam.Writable[])new MetaParam.Writable[0])));
    }

    public boolean replace(K key, V value) {
        return (Boolean)FunctionalJCache.await(this.readWrite.eval(key, value, MarshallableFunctions.setValueIfPresentReturnBoolean()));
    }

    public V getAndReplace(K key, V value) {
        return (V)FunctionalJCache.await(this.readWrite.eval(key, value, MarshallableFunctions.setValueIfPresentReturnPrevOrNull()));
    }

    public void removeAll(Set<? extends K> keys) {
        FunctionalJCache.await(this.writeOnly.evalMany(keys, MarshallableFunctions.removeConsumer()));
    }

    public void removeAll() {
        FunctionalJCache.await(this.writeOnly.evalAll(MarshallableFunctions.removeConsumer()));
    }

    public void clear() {
        FunctionalJCache.await(this.writeOnly.truncate());
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        Traversable t = this.readOnly.entries().map(rw -> new Cache.Entry<K, V>((EntryView.ReadEntryView)rw){
            final /* synthetic */ EntryView.ReadEntryView val$rw;
            {
                this.val$rw = readEntryView;
            }

            public K getKey() {
                return this.val$rw.key();
            }

            public V getValue() {
                return this.val$rw.get();
            }

            public <T> T unwrap(Class<T> clazz) {
                return null;
            }
        });
        return Traversables.asIterator((Traversable)t);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return FunctionalJCache.await(this.readWrite.eval(key, new InvokeFunction(entryProcessor, arguments)));
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        Traversable t = this.readWrite.evalMany(keys, new InvokeAllFunction(entryProcessor, arguments));
        return (Map)t.collect(HashMap::new, (m, res) -> m.put(res.key, res), HashMap::putAll);
    }

    public void close() {
        try {
            this.readOnly.close();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isClosed() {
        return this.readOnly.getStatus().isTerminated();
    }

    public String getName() {
        return this.readOnly.getName();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        return null;
    }

    public CacheManager getCacheManager() {
        return null;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
    }

    private static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error(e);
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class EntryProcessorResultWithKey<K, T>
    implements EntryProcessorResult<T> {
        final K key;
        final T t;

        public EntryProcessorResultWithKey(K key, T t) {
            this.key = key;
            this.t = t;
        }

        public T get() throws EntryProcessorException {
            return this.t;
        }

        public static final class Externalizer0
        implements Externalizer<EntryProcessorResultWithKey<?, ?>> {
            public void writeObject(ObjectOutput oo, EntryProcessorResultWithKey<?, ?> o) throws IOException {
                oo.writeObject(o.key);
                oo.writeObject(o.t);
            }

            public EntryProcessorResultWithKey<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                Object key = input.readObject();
                Object t = input.readObject();
                return new EntryProcessorResultWithKey<Object, Object>(key, t);
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class InvokeAllFunction<K, V, T>
    implements Function<EntryView.ReadWriteEntryView<K, V>, EntryProcessorResultWithKey<K, T>> {
        private final EntryProcessor<K, V, T> entryProcessor;
        private final Object[] arguments;

        private InvokeAllFunction(EntryProcessor<K, V, T> entryProcessor, Object[] arguments) {
            this.entryProcessor = entryProcessor;
            this.arguments = arguments;
        }

        @Override
        public EntryProcessorResultWithKey<K, T> apply(EntryView.ReadWriteEntryView<K, V> rw) {
            Object res = this.entryProcessor.process(new ReadWriteMutableEntry(rw), this.arguments);
            return new EntryProcessorResultWithKey<Object, Object>(rw.key(), res);
        }

        public static final class Externalizer0
        implements Externalizer<InvokeAllFunction<?, ?, ?>> {
            public void writeObject(ObjectOutput oo, InvokeAllFunction<?, ?, ?> o) throws IOException {
                oo.writeObject(((InvokeAllFunction)o).entryProcessor);
                oo.writeInt(((InvokeAllFunction)o).arguments.length);
                for (Object argument : ((InvokeAllFunction)o).arguments) {
                    oo.writeObject(argument);
                }
            }

            public InvokeAllFunction<?, ?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                EntryProcessor entryProcessor = (EntryProcessor)input.readObject();
                int length = input.readInt();
                Object[] arguments = new Object[length];
                for (int i = 0; i < length; ++i) {
                    arguments[i] = input.readObject();
                }
                return new InvokeAllFunction(entryProcessor, arguments);
            }
        }
    }

    private static final class ReadWriteMutableEntry<K, V>
    implements MutableEntry<K, V> {
        final EntryView.ReadWriteEntryView<K, V> rw;

        private ReadWriteMutableEntry(EntryView.ReadWriteEntryView<K, V> rw) {
            this.rw = rw;
        }

        public boolean exists() {
            return this.rw.find().isPresent();
        }

        public void remove() {
            this.rw.remove();
        }

        public void setValue(V value) {
            this.rw.set(value, new MetaParam.Writable[0]);
        }

        public K getKey() {
            return (K)this.rw.key();
        }

        public V getValue() {
            return this.rw.find().orElse(null);
        }

        public <T> T unwrap(Class<T> clazz) {
            return null;
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class InvokeFunction<K, V, T>
    implements Function<EntryView.ReadWriteEntryView<K, V>, T> {
        private final EntryProcessor<K, V, T> entryProcessor;
        private final Object[] arguments;

        private InvokeFunction(EntryProcessor<K, V, T> entryProcessor, Object[] arguments) {
            this.entryProcessor = entryProcessor;
            this.arguments = arguments;
        }

        @Override
        public T apply(EntryView.ReadWriteEntryView<K, V> rw) {
            return (T)this.entryProcessor.process(new ReadWriteMutableEntry(rw), this.arguments);
        }

        public static final class Externalizer0
        implements Externalizer<InvokeFunction<?, ?, ?>> {
            public void writeObject(ObjectOutput oo, InvokeFunction<?, ?, ?> o) throws IOException {
                oo.writeObject(((InvokeFunction)o).entryProcessor);
                oo.writeInt(((InvokeFunction)o).arguments.length);
                for (Object argument : ((InvokeFunction)o).arguments) {
                    oo.writeObject(argument);
                }
            }

            public InvokeFunction<?, ?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                EntryProcessor entryProcessor = (EntryProcessor)input.readObject();
                int length = input.readInt();
                Object[] arguments = new Object[length];
                for (int i = 0; i < length; ++i) {
                    arguments[i] = input.readObject();
                }
                return new InvokeFunction(entryProcessor, arguments);
            }
        }
    }
}

