/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.stress;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.GetAllCommandStressTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="ReadOnlyManyCommandStressTest", timeOut=900000L)
@InCacheMode(value={CacheMode.SCATTERED_SYNC})
public class ReadOnlyManyCommandStressTest
extends GetAllCommandStressTest {
    @Override
    protected void workerLogic(Cache<Integer, Integer> cache, Set<Integer> threadKeys, int iteration) {
        FunctionalMap.ReadOnlyMap ro = ReadOnlyMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache()));
        Traversable results = ro.evalMany(threadKeys, (SerializableFunction & Serializable)view -> new Pair((Integer)view.key(), (Integer)view.get() + 1));
        Counter counter = new Counter();
        results.forEach(p -> {
            counter.inc();
            AssertJUnit.assertEquals((int)(p.key + 1), (int)p.value);
        });
        AssertJUnit.assertEquals((int)threadKeys.size(), (int)counter.get());
    }

    private static class Counter {
        private int counter;

        private Counter() {
        }

        public void inc() {
            ++this.counter;
        }

        public int get() {
            return this.counter;
        }
    }

    private static class Pair
    implements Serializable {
        public final int key;
        public final int value;

        public Pair(int key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

