/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ConfigurationChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="globalstate.GlobalStateTest", groups={"functional"})
public class GlobalStateTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedState(Method m) {
        String state1 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "1"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1, true);
        String state2 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "2"});
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(state2, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, null, new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, null, new TransportFlags());
        try {
            Configuration cacheConfig = new ConfigurationBuilder().build();
            Configuration template = new ConfigurationBuilder().template(true).build();
            cm1.start();
            cm2.start();
            cm1.defineConfiguration("not-replicated-template", template);
            cm1.createCache("not-replicated-cache", cacheConfig);
            AssertJUnit.assertNull((Object)cm2.getCacheConfiguration("not-replicated-template"));
            AssertJUnit.assertFalse((boolean)cm2.cacheExists("not-replicated-cache"));
            cm1.administration().getOrCreateCache("replicated-cache", cacheConfig);
            cm1.administration().getOrCreateTemplate("replicated-template", template);
            AssertJUnit.assertNotNull((Object)cm2.getCache("replicated-cache"));
            AssertJUnit.assertNotNull((Object)cm2.getCacheConfiguration("replicated-template"));
            AssertJUnit.assertEquals((int)2, (int)cm1.getCacheNames().size());
            AssertJUnit.assertEquals((int)1, (int)cm2.getCacheNames().size());
            cm1.stop();
            cm2.stop();
            global1 = this.statefulGlobalBuilder(state1, false);
            EmbeddedCacheManager newCm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
            AssertJUnit.assertNotNull((Object)newCm1.getCache("replicated-cache"));
            AssertJUnit.assertNotNull((Object)newCm1.getCacheConfiguration("replicated-template"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockPersistentLocation() {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), "COMMON"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(stateDirectory, true);
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(stateDirectory, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, new ConfigurationBuilder(), new TransportFlags());
        try {
            cm1.start();
            Exceptions.expectException(EmbeddedCacheManagerStartupException.class, (String)"org.infinispan.commons.CacheConfigurationException: ISPN000512: Cannot acquire lock.*", () -> cm2.start());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorruptGlobalState(Method m) throws Exception {
        String state1 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "1"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1, true);
        String state2 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "2"});
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(state2, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, new ConfigurationBuilder(), new TransportFlags());
        try {
            cm1.start();
            cm2.start();
            cm1.stop();
            cm2.stop();
            FileWriter w = new FileWriter(new File(state1, "___global.state"));
            w.write("'Cause I want to be anarchy\nIt's the only way to be");
            ((Writer)w).close();
            global1 = this.statefulGlobalBuilder(state1, false);
            EmbeddedCacheManager newCm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
            Exceptions.expectException(EmbeddedCacheManagerStartupException.class, (String)"org.infinispan.commons.CacheConfigurationException: ISPN000516: The state file for '___global' is invalid.*", () -> newCm1.start());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompatibleGlobalState(Method m) throws Exception {
        String state1 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "1"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1, true);
        String state2 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "2"});
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(state2, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, new ConfigurationBuilder(), new TransportFlags());
        try {
            cm1.start();
            cm2.start();
            ConfigurationBuilder distBuilder = new ConfigurationBuilder();
            distBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
            cm1.administration().createCache("cache1", distBuilder.build());
            cm1.administration().createCache("cache2", distBuilder.build());
            cm2.stop();
            cm1.administration().removeCache("cache1");
            cm1.administration().removeCache("cache2");
            ConfigurationBuilder replBuilder = new ConfigurationBuilder();
            replBuilder.clustering().cacheMode(CacheMode.REPL_SYNC);
            cm1.administration().createCache("cache1", replBuilder.build());
            global2 = this.statefulGlobalBuilder(state2, false);
            EmbeddedCacheManager newCm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, new ConfigurationBuilder(), new TransportFlags());
            Exceptions.expectException(EmbeddedCacheManagerStartupException.class, (String)"(?s)org.infinispan.commons.CacheConfigurationException: ISPN000500: Cannot create clustered configuration for cache.*", () -> newCm2.start());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigurationUpdate(Method m) {
        String state1 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "1"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1, true);
        String state2 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "2"});
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(state2, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, new ConfigurationBuilder(), new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, new ConfigurationBuilder(), new TransportFlags());
        try {
            cm1.start();
            cm2.start();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.clustering().cacheMode(CacheMode.DIST_SYNC).memory().maxCount(1000L);
            cm1.administration().getOrCreateCache("cache1", builder.build());
            AssertJUnit.assertEquals((long)1000L, (long)cm1.getCache("cache1").getCacheConfiguration().memory().maxCount());
            AssertJUnit.assertEquals((long)1000L, (long)cm2.getCache("cache1").getCacheConfiguration().memory().maxCount());
            builder.clustering().cacheMode(CacheMode.DIST_SYNC).memory().maxCount(2000L);
            ((EmbeddedCacheManagerAdmin)cm1.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.UPDATE})).getOrCreateCache("cache1", builder.build());
            AssertJUnit.assertEquals((long)2000L, (long)cm1.getCache("cache1").getCacheConfiguration().memory().maxCount());
            AssertJUnit.assertEquals((long)2000L, (long)cm2.getCache("cache1").getCacheConfiguration().memory().maxCount());
            builder.clustering().cacheMode(CacheMode.DIST_SYNC).memory().maxCount(3000L);
            cm1.administration().getOrCreateCache("cache1", builder.build());
            AssertJUnit.assertEquals((long)2000L, (long)cm1.getCache("cache1").getCacheConfiguration().memory().maxCount());
            AssertJUnit.assertEquals((long)2000L, (long)cm2.getCache("cache1").getCacheConfiguration().memory().maxCount());
            builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            Exceptions.expectRootCause(IllegalArgumentException.class, () -> ((EmbeddedCacheManagerAdmin)cm1.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.UPDATE})).getOrCreateCache("cache1", builder.build()));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    private GlobalConfigurationBuilder statefulGlobalBuilder(String stateDirectory, boolean clear) {
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).sharedPersistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        return global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailStartup(Method m) throws Exception {
        String state = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName()});
        GlobalConfigurationBuilder global = this.statefulGlobalBuilder(state, true);
        global.transport().transport((Transport)new FailingJGroupsTransport());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(false, global, new ConfigurationBuilder(), new TransportFlags());
        try {
            cm.start();
            AssertJUnit.fail((String)"Should not reach here");
        }
        catch (Exception e) {
            try {
                File globalStateFile = new File(state, "___global.state");
                AssertJUnit.assertFalse((boolean)globalStateFile.exists());
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(cm);
                throw throwable;
            }
            TestingUtil.killCacheManagers(cm);
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheManagerNotifications(Method m) {
        String state1 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "1"});
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1, true);
        String state2 = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), m.getName() + "2"});
        GlobalConfigurationBuilder global2 = this.statefulGlobalBuilder(state2, true);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(false, global1, null, new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(false, global2, null, new TransportFlags());
        try {
            Configuration cacheConfig = new ConfigurationBuilder().build();
            Configuration template = new ConfigurationBuilder().template(true).build();
            cm1.start();
            cm2.start();
            cm1.addListener((Object)new StateListener());
            cm2.addListener((Object)new StateListener());
            cm1.administration().getOrCreateCache("replicated-cache", cacheConfig);
            cm1.administration().getOrCreateTemplate("replicated-template", template);
            AssertJUnit.assertNotNull((Object)cm2.getCache("replicated-cache"));
            AssertJUnit.assertNotNull((Object)cm2.getCacheConfiguration("replicated-template"));
            AssertJUnit.assertEquals((int)1, (int)cm1.getCacheNames().size());
            AssertJUnit.assertEquals((int)1, (int)cm2.getCacheNames().size());
            cm1.stop();
            cm2.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    public static class FailingJGroupsTransport
    extends JGroupsTransport {
        public void start() {
            throw new RuntimeException("fail");
        }
    }

    @Listener
    public class StateListener {
        @ConfigurationChanged
        public void configurationChanged(ConfigurationChangedEvent event) {
        }
    }
}

