/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="health.impl.CacheHealthImplTest", groups={"functional"})
public class CacheHealthImplTest {
    @Test
    public void testHealthyStatus() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        DistributionManager distributionManagerMock = (DistributionManager)Mockito.mock(DistributionManager.class);
        ((DistributionManager)Mockito.doReturn((Object)false).when((Object)distributionManagerMock)).isRehashInProgress();
        ((CacheImpl)Mockito.doReturn((Object)distributionManagerMock).when((Object)cache)).getDistributionManager();
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)cache)).getStatus();
        ((CacheImpl)Mockito.doReturn((Object)AvailabilityMode.AVAILABLE).when((Object)cache)).getAvailability();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.HEALTHY);
    }

    @Test
    public void testUnhealthyStatusWithFailedComponent() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.FAILED).when((Object)cache)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithTerminatedComponent() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.TERMINATED).when((Object)cache)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithStoppingComponent() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.STOPPING).when((Object)cache)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithDegradedPartition() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)cache)).getStatus();
        ((CacheImpl)Mockito.doReturn((Object)AvailabilityMode.DEGRADED_MODE).when((Object)cache)).getAvailability();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testRebalancingStatusOnRebalance() {
        CacheImpl cache = (CacheImpl)Mockito.spy((Object)new CacheImpl("test"));
        DistributionManager distributionManagerMock = (DistributionManager)Mockito.mock(DistributionManager.class);
        ((DistributionManager)Mockito.doReturn((Object)true).when((Object)distributionManagerMock)).isRehashInProgress();
        ((CacheImpl)Mockito.doReturn((Object)distributionManagerMock).when((Object)cache)).getDistributionManager();
        ((CacheImpl)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)cache)).getStatus();
        ((CacheImpl)Mockito.doReturn((Object)AvailabilityMode.AVAILABLE).when((Object)cache)).getAvailability();
        CacheHealthImpl cacheHealth = new CacheHealthImpl((Cache)cache);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.HEALTHY_REBALANCING);
    }

    @Test
    public void testReturningName() {
        CacheImpl cache = new CacheImpl("test");
        String name = cache.getName();
        Assert.assertEquals((String)name, (String)"test");
    }
}

