/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.Collections;
import java.util.EnumSet;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.ClusterHealthImpl;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="health.impl.ClusterHealthImplTest", groups={"functional"})
public class ClusterHealthImplTest
extends AbstractInfinispanTest {
    private static final String INTERNAL_CACHE_NAME = "internal_cache";
    private static final String CACHE_NAME = "test_cache";
    private EmbeddedCacheManager cacheManager;
    private DefaultCacheManager mockedCacheManager;
    private ClusterHealth clusterHealth;
    private InternalCacheRegistry internalCacheRegistry;

    @BeforeClass
    private void init() {
        this.cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        this.internalCacheRegistry = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        this.clusterHealth = new ClusterHealthImpl(this.cacheManager, this.internalCacheRegistry);
    }

    @BeforeMethod
    private void configureBeforeMethod() {
        this.mockedCacheManager = (DefaultCacheManager)Mockito.mock(DefaultCacheManager.class);
        Mockito.when((Object)this.mockedCacheManager.getGlobalComponentRegistry()).thenReturn((Object)this.cacheManager.getGlobalComponentRegistry());
        this.internalCacheRegistry.registerInternalCache(INTERNAL_CACHE_NAME, new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).build(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
        this.cacheManager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().build());
    }

    @AfterMethod(alwaysRun=true)
    private void cleanAfterMethod() {
        if (this.cacheManager != null) {
            this.cacheManager.administration().removeCache(CACHE_NAME);
            this.cacheManager.undefineConfiguration(CACHE_NAME);
            this.cacheManager.administration().removeCache(INTERNAL_CACHE_NAME);
        }
        if (this.internalCacheRegistry != null) {
            this.internalCacheRegistry.unregisterInternalCache(INTERNAL_CACHE_NAME);
        }
    }

    @AfterClass(alwaysRun=true)
    private void cleanUp() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
            this.cacheManager = null;
        }
    }

    public void testGetClusterName() {
        AssertJUnit.assertEquals((String)this.cacheManager.getClusterName(), (String)this.clusterHealth.getClusterName());
    }

    public void testCallingGetHealthStatusDoesNotCreateAnyCache() {
        this.clusterHealth.getHealthStatus();
        AssertJUnit.assertFalse((boolean)this.cacheManager.cacheExists(CACHE_NAME));
        AssertJUnit.assertFalse((boolean)this.cacheManager.cacheExists(INTERNAL_CACHE_NAME));
    }

    public void testHealthyStatusWithoutAnyUserCreatedCache() {
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testHealthyStatusWhenUserCacheIsHealthy() {
        this.cacheManager.getCache(CACHE_NAME, true);
        HealthStatus healthStatus = this.clusterHealth.getHealthStatus();
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)healthStatus);
    }

    public void testUnhealthyStatusWhenUserCacheIsStopped() {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME, true);
        testCache.stop();
        HealthStatus healthStatus = this.clusterHealth.getHealthStatus();
        AssertJUnit.assertEquals((Object)HealthStatus.DEGRADED, (Object)healthStatus);
    }

    public void testRebalancingStatusWhenUserCacheIsRebalancing() {
        Cache mockedCache = (Cache)Mockito.mock(Cache.class);
        AdvancedCache mockedAdvancedCache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        DistributionManager mockedDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)this.mockedCacheManager.getCacheNames()).thenReturn(Collections.singleton(CACHE_NAME));
        this.mockRehashInProgress(CACHE_NAME, mockedCache, mockedAdvancedCache, mockedDistributionManager);
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl((EmbeddedCacheManager)this.mockedCacheManager, (InternalCacheRegistry)this.mockedCacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class));
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY_REBALANCING, (Object)clusterHealth.getHealthStatus());
    }

    public void testHealthyStatusForInternalCaches() {
        this.cacheManager.getCache(INTERNAL_CACHE_NAME, true);
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testUnhealthyStatusWhenInternalCacheIsStopped() {
        Cache internalCache = this.cacheManager.getCache(INTERNAL_CACHE_NAME, true);
        internalCache.stop();
        AssertJUnit.assertEquals((Object)HealthStatus.DEGRADED, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testRebalancingStatusWhenInternalCacheIsRebalancing() {
        Cache mockedCache = (Cache)Mockito.mock(Cache.class);
        AdvancedCache mockedAdvancedCache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        DistributionManager mockedDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)this.mockedCacheManager.getCacheNames()).thenReturn(Collections.emptySet());
        this.mockRehashInProgress(INTERNAL_CACHE_NAME, mockedCache, mockedAdvancedCache, mockedDistributionManager);
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl((EmbeddedCacheManager)this.mockedCacheManager, (InternalCacheRegistry)this.mockedCacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class));
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY_REBALANCING, (Object)clusterHealth.getHealthStatus());
    }

    public void testGetNodeNames() {
        AssertJUnit.assertEquals((String)this.cacheManager.getAddress().toString(), (String)((String)this.clusterHealth.getNodeNames().get(0)));
    }

    public void testGetNumberOfNodes() {
        AssertJUnit.assertEquals((int)1, (int)this.clusterHealth.getNumberOfNodes());
    }

    public void testGetNumberOfNodesWithNullTransport() {
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl((EmbeddedCacheManager)this.mockedCacheManager, (InternalCacheRegistry)this.mockedCacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class));
        AssertJUnit.assertEquals((int)0, (int)clusterHealth.getNumberOfNodes());
    }

    public void testGetNodeNamesWithNullTransport() {
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl((EmbeddedCacheManager)this.mockedCacheManager, (InternalCacheRegistry)this.mockedCacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class));
        AssertJUnit.assertTrue((boolean)clusterHealth.getNodeNames().isEmpty());
    }

    private void mockRehashInProgress(String cacheName, Cache mockedCache, AdvancedCache mockedAdvancedCache, DistributionManager mockedDistributionManager) {
        Mockito.when((Object)this.mockedCacheManager.getCache(cacheName, false)).thenReturn((Object)mockedCache);
        Mockito.when((Object)mockedCache.getAdvancedCache()).thenReturn((Object)mockedAdvancedCache);
        Mockito.when((Object)mockedCache.getStatus()).thenReturn((Object)ComponentStatus.INSTANTIATED);
        Mockito.when((Object)mockedAdvancedCache.getDistributionManager()).thenReturn((Object)mockedDistributionManager);
        Mockito.when((Object)mockedDistributionManager.isRehashInProgress()).thenReturn((Object)true);
    }
}

