/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.FooInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.CustomInterceptorTest")
public class CustomInterceptorTest
extends AbstractInfinispanTest {
    public void testCustomInterceptorProperties() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new FooInterceptor()).position(InterceptorConfiguration.Position.FIRST).addProperty("foo", "bar");
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                AsyncInterceptor i = (AsyncInterceptor)cache.getAdvancedCache().getAsyncInterceptorChain().getInterceptors().get(0);
                AssertJUnit.assertTrue((String)"Expecting FooInterceptor in the interceptor chain", (boolean)(i instanceof FooInterceptor));
                AssertJUnit.assertEquals((String)"bar", (String)((FooInterceptor)i).getFoo());
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingPosition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new FooInterceptor());
        TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testLastInterceptor() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.LAST).interceptor((AsyncInterceptor)new FooInterceptor());
        final EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        cacheManager.defineConfiguration("interceptors", builder.build());
        TestingUtil.withCacheManager(new CacheManagerCallable(cacheManager){

            @Override
            public void call() {
                List interceptors = cacheManager.getCache("interceptors").getAdvancedCache().getAsyncInterceptorChain().getInterceptors();
                AssertJUnit.assertEquals(FooInterceptor.class, ((AsyncInterceptor)interceptors.get(interceptors.size() - 2)).getClass());
            }
        });
    }

    public void testOtherThanFirstOrLastInterceptor() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST).interceptor((AsyncInterceptor)new FooInterceptor());
        final EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        cacheManager.defineConfiguration("interceptors", builder.build());
        TestingUtil.withCacheManager(new CacheManagerCallable(cacheManager){

            @Override
            public void call() {
                AsyncInterceptorChain interceptorChain = cacheManager.getCache("interceptors").getAdvancedCache().getAsyncInterceptorChain();
                AssertJUnit.assertEquals(((AsyncInterceptor)interceptorChain.getInterceptors().get(1)).getClass(), FooInterceptor.class);
            }
        });
    }

    public void testLastInterceptorDefaultCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        final FooInterceptor interceptor = new FooInterceptor();
        builder.customInterceptors().addInterceptor().position(InterceptorConfiguration.Position.LAST).interceptor((AsyncInterceptor)interceptor);
        final EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(builder);
        TestingUtil.withCacheManager(new CacheManagerCallable(cacheManager){

            @Override
            public void call() {
                List interceptors = cacheManager.getCache().getAdvancedCache().getAsyncInterceptorChain().getInterceptors();
                Object o = interceptors.get(interceptors.size() - 2);
                AssertJUnit.assertEquals(FooInterceptor.class, o.getClass());
                AssertJUnit.assertFalse((boolean)interceptor.putInvoked);
                cacheManager.getCache().put((Object)"k", (Object)"v");
                AssertJUnit.assertEquals((Object)"v", (Object)cacheManager.getCache().get((Object)"k"));
                AssertJUnit.assertTrue((boolean)interceptor.putInvoked);
            }
        });
    }
}

