/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.LockManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseInvalidationTest
extends MultipleCacheManagersTest {
    boolean isSync;

    protected BaseInvalidationTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = BaseInvalidationTest.getDefaultClusteredCacheConfig(this.isSync ? CacheMode.INVALIDATION_SYNC : CacheMode.INVALIDATION_ASYNC, false);
        c.clustering().stateTransfer().timeout(30000L).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createClusteredCaches(2, "invalidation", c);
        if (this.isSync) {
            c = BaseInvalidationTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, true);
            c.clustering().stateTransfer().timeout(30000L).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).transaction().lockingMode(LockingMode.OPTIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
            this.defineConfigurationOnAllManagers("invalidationTx", c);
            this.waitForClusterToForm("invalidationTx");
        }
    }

    public void testRemove() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expectAny();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.remove((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((boolean)false, (boolean)cache2.containsKey((Object)"key"));
    }

    public void testResurrectEntry() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals(null, (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"newValue");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"newValue", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals(null, (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        AssertJUnit.assertEquals((String)"newValue", (String)((String)cache1.remove((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals(null, (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals(null, (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals(null, (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache1).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache2.put((Object)"key", (Object)"value2");
        this.replListener((Cache<?, ?>)cache1).waitForRpc();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertEquals(null, (String)((String)cache1.get((Object)"key")));
    }

    public void testDeleteNonExistentEntry() throws Exception {
        if (!this.isSync) {
            return;
        }
        AdvancedCache cache1 = this.advancedCache(0, "invalidationTx");
        AdvancedCache cache2 = this.advancedCache(1, "invalidationTx");
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)"key"));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)"key"));
        TransactionManager tm = TestingUtil.getTransactionManager(cache2);
        tm.begin();
        cache2.remove((Object)"key");
        this.replListener((Cache<?, ?>)cache1).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        tm.commit();
        this.replListener((Cache<?, ?>)cache1).waitForRpc();
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxSyncUnableToInvalidate() throws Exception {
        if (!this.isSync) {
            return;
        }
        AdvancedCache cache1 = this.advancedCache(0, "invalidationTx");
        AdvancedCache cache2 = this.advancedCache(1, "invalidationTx");
        TransactionManager mgr1 = TestingUtil.getTransactionManager(cache1);
        TransactionManager mgr2 = TestingUtil.getTransactionManager(cache2);
        LockManager lm1 = TestingUtil.extractComponent(cache1, LockManager.class);
        LockManager lm2 = TestingUtil.extractComponent(cache2, LockManager.class);
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
        TransactionImpl tx1 = null;
        mgr1.begin();
        try {
            cache1.put((Object)"key", (Object)"value2");
            tx1 = (TransactionImpl)mgr1.suspend();
            this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
            tx1.runPrepare();
            this.replListener((Cache<?, ?>)cache2).waitForRpc();
            mgr2.begin();
            cache2.put((Object)"key", (Object)"value3");
            this.replListener((Cache<?, ?>)cache1).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
            Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)mgr2).commit());
            this.replListener((Cache<?, ?>)cache2).assertNoRpc();
        }
        finally {
            if (tx1 != null) {
                tx1.runCommit(false);
            }
        }
        this.eventually(() -> !lm1.isLocked((Object)"key"));
        this.eventually(() -> !lm2.isLocked((Object)"key"));
        LockAssert.assertNoLocks(cache1);
        LockAssert.assertNoLocks(cache2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheMode() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport origTransport = TestingUtil.extractComponent(cache1, Transport.class);
        try {
            Transport mockTransport = (Transport)Mockito.mock(Transport.class);
            rpcManager.setTransport(mockTransport);
            Address addressOne = (Address)Mockito.mock(Address.class);
            Address addressTwo = (Address)Mockito.mock(Address.class);
            ArrayList<Address> members = new ArrayList<Address>(2);
            members.add(addressOne);
            members.add(addressTwo);
            Mockito.when((Object)mockTransport.getMembers()).thenReturn(members);
            Mockito.when((Object)mockTransport.getAddress()).thenReturn((Object)addressOne);
            Mockito.when((Object)mockTransport.invokeCommandOnAll((Collection)ArgumentMatchers.any(), (ReplicableCommand)ArgumentMatchers.any(), (ResponseCollector)ArgumentMatchers.any(), (DeliverOrder)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)CompletableFutures.completedNull());
            cache1.put((Object)"k", (Object)"v");
        }
        finally {
            if (rpcManager != null) {
                rpcManager.setTransport(origTransport);
            }
        }
    }

    public void testPutIfAbsent() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        String putPrevious = (String)cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value");
        AssertJUnit.assertNull((Object)putPrevious);
        AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        String putIfAbsentPrevious = (String)cache1.putIfAbsent((Object)"key", (Object)"value");
        AssertJUnit.assertNull((Object)putIfAbsentPrevious);
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        String value = (String)cache2.get((Object)"key");
        AssertJUnit.assertNull((Object)value);
        AssertJUnit.assertNull((Object)cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2"));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        cache1.putIfAbsent((Object)"key", (Object)"value3");
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
    }

    public void testRemoveIfPresent() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertFalse((boolean)cache1.remove((Object)"key", (Object)"value"));
        AssertJUnit.assertEquals((String)"Should not remove", (String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"Should not evict", (String)"value2", (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.remove((Object)"key", (Object)"value1");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
    }

    public void testClear() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)ClearCommand.class);
        cache1.clear();
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
    }

    public void testReplace() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache1.replace((Object)"key", (Object)"value1"));
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"valueN"));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        cache1.replace((Object)"key", (Object)"value1");
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
    }

    public void testReplaceWithOldVal() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertFalse((boolean)cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1"));
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"valueN"));
        AssertJUnit.assertFalse((boolean)cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1"));
        AssertJUnit.assertEquals((String)"valueN", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        this.replListener((Cache<?, ?>)cache2).expect((Class<? extends VisitableCommand>)InvalidateCommand.class);
        AssertJUnit.assertTrue((boolean)cache1.replace((Object)"key", (Object)"valueN", (Object)"value1"));
        this.replListener((Cache<?, ?>)cache2).waitForRpc();
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
    }

    public void testLocalOnlyClear() {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value1");
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)"key", (Object)"value2");
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).clear();
        AssertJUnit.assertNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertNotNull((Object)cache2.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
    }

    public void testPutForExternalRead() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "invalidation");
        AdvancedCache cache2 = this.advancedCache(1, "invalidation");
        cache1.putForExternalRead((Object)"key", (Object)"value1");
        Thread.sleep(500L);
        cache2.putForExternalRead((Object)"key", (Object)"value2");
        Thread.sleep(500L);
        AssertJUnit.assertNotNull((Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache1.get((Object)"key")));
        AssertJUnit.assertNotNull((Object)cache2.get((Object)"key"));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get((Object)"key")));
    }

    @DataProvider(name="tx")
    public Object[][] tx() {
        if (this.isSync) {
            return new Object[][]{{false}, {true}};
        }
        return new Object[][]{{false}};
    }

    @Test(dataProvider="tx")
    public void testLeaveDuringInvalidation(boolean tx) throws Exception {
        Cache c0 = this.cache(0, tx ? "invalidationTx" : "invalidation");
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(c0);
        TestingUtil.replaceComponent(c0, RpcManager.class, controlledRpcManager, true);
        Future<Object> future = this.fork(() -> c0.put((Object)"k1", (Object)"v1"));
        if (tx) {
            controlledRpcManager.expectCommand(PrepareCommand.class).send().expectResponse(this.address(1)).replace((Response)CacheNotFoundResponse.INSTANCE).finish();
            controlledRpcManager.expectCommand(CommitCommand.class).send().expectResponse(this.address(1)).replace((Response)CacheNotFoundResponse.INSTANCE).finish();
            controlledRpcManager.expectCommand(TxCompletionNotificationCommand.class).send();
        } else if (this.isSync) {
            controlledRpcManager.expectCommand(InvalidateCommand.class).send().expectResponse(this.address(1)).replace((Response)CacheNotFoundResponse.INSTANCE).finish();
        } else {
            controlledRpcManager.expectCommand(InvalidateCommand.class).send();
        }
        future.get(10L, TimeUnit.SECONDS);
        controlledRpcManager.stopBlocking();
    }
}

