/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.NonTxInvalidationLockingTest")
public class NonTxInvalidationLockingTest
extends MultipleCacheManagersTest {
    private static final String KEY = "key";
    private static final String VALUE1 = "value1";
    private static final Object VALUE2 = "value2";
    private static final String CACHE = "nontx";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager();
        this.addClusterEnabledCacheManager();
        this.defineCache(CACHE);
        this.waitForClusterToForm(CACHE);
    }

    private void defineCache(String cacheName) {
        ConfigurationBuilder config = this.buildConfig();
        this.manager(0).defineConfiguration(cacheName, config.build());
        this.manager(1).defineConfiguration(cacheName, config.build());
    }

    private ConfigurationBuilder buildConfig() {
        ConfigurationBuilder cacheConfig = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)cacheConfig.clustering().cacheMode(CacheMode.INVALIDATION_SYNC).stateTransfer().fetchInMemoryState(false).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(NonTxInvalidationLockingTest.class.getName()).build();
        return cacheConfig;
    }

    public void testConcurrentWritesFromDifferentNodes() throws Exception {
        Cache cache1 = this.cache(0, CACHE);
        ControlledRpcManager rpc1 = ControlledRpcManager.replaceRpcManager(cache1);
        Cache cache2 = this.cache(1, CACHE);
        ControlledRpcManager rpc2 = ControlledRpcManager.replaceRpcManager(cache2);
        CompletableFuture<ControlledRpcManager.BlockedRequest<InvalidateCommand>> invalidate1 = rpc1.expectCommandAsync(InvalidateCommand.class);
        CompletableFuture put1 = cache1.putAsync((Object)KEY, (Object)VALUE1);
        CompletableFuture<ControlledRpcManager.BlockedRequest<InvalidateCommand>> invalidate2 = rpc2.expectCommandAsync(InvalidateCommand.class);
        CompletableFuture put2 = cache2.putAsync((Object)KEY, VALUE2);
        ControlledRpcManager.SentRequest sentInvalidate1 = invalidate1.join().send();
        ControlledRpcManager.SentRequest sentInvalidate2 = invalidate2.join().send();
        sentInvalidate1.expectAllResponses().receive();
        sentInvalidate2.expectAllResponses().receive();
        put1.get(10L, TimeUnit.SECONDS);
        put2.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)VALUE1, (Object)cache1.get((Object)KEY));
        AssertJUnit.assertEquals((Object)VALUE2, (Object)cache2.get((Object)KEY));
    }
}

