/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.TxInvalidationLockingTest")
public class TxInvalidationLockingTest
extends MultipleCacheManagersTest {
    private static final String KEY = "key";
    private static final String VALUE1 = "value1";
    private static final Object VALUE2 = "value2";
    private static final String PESSIMISTIC_CACHE = "pessimistic";
    private static final String OPTIMISTIC_CACHE = "optimistic";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager();
        this.addClusterEnabledCacheManager();
        this.defineCache(PESSIMISTIC_CACHE, LockingMode.PESSIMISTIC);
        this.defineCache(OPTIMISTIC_CACHE, LockingMode.OPTIMISTIC);
        this.waitForClusterToForm(PESSIMISTIC_CACHE, OPTIMISTIC_CACHE);
    }

    private void defineCache(String cacheName, LockingMode lockingMode) {
        ConfigurationBuilder config = this.buildConfig(lockingMode);
        this.manager(0).defineConfiguration(cacheName, config.build());
        this.manager(1).defineConfiguration(cacheName, config.build());
    }

    private ConfigurationBuilder buildConfig(LockingMode lockingMode) {
        ConfigurationBuilder cacheConfig = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)cacheConfig.clustering().cacheMode(CacheMode.INVALIDATION_SYNC).stateTransfer().fetchInMemoryState(false).transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(lockingMode).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(TxInvalidationLockingTest.class.getName()).build();
        return cacheConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPessimisticWriteAcquiresGlobalLock() throws Exception {
        Future<Void> tx2Future;
        Cache cache1 = this.cache(0, PESSIMISTIC_CACHE);
        this.tm(cache1).begin();
        try {
            Object initialValue = cache1.put((Object)KEY, (Object)VALUE1);
            AssertJUnit.assertNull((Object)initialValue);
            tx2Future = this.fork(() -> {
                AdvancedCache cache2 = this.advancedCache(1, PESSIMISTIC_CACHE);
                this.tm((Cache<?, ?>)cache2).begin();
                try {
                    Object value = cache2.put((Object)KEY, VALUE2);
                    AssertJUnit.assertEquals((Object)VALUE1, (Object)value);
                }
                finally {
                    this.tm((Cache<?, ?>)cache2).commit();
                }
            });
            Thread.sleep(10L);
            AssertJUnit.assertFalse((boolean)tx2Future.isDone());
        }
        finally {
            this.tm(cache1).commit();
        }
        tx2Future.get();
        AssertJUnit.assertEquals((Object)VALUE2, (Object)cache1.get((Object)KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPessimisticForceWriteLockAcquiresGlobalLock() throws Exception {
        Future<Void> tx2Future;
        AdvancedCache cache1 = this.advancedCache(0, PESSIMISTIC_CACHE);
        this.tm((Cache<?, ?>)cache1).begin();
        try {
            Object initialValue = cache1.withFlags(Flag.FORCE_WRITE_LOCK).get((Object)KEY);
            AssertJUnit.assertNull((Object)initialValue);
            tx2Future = this.fork(() -> {
                AdvancedCache cache2 = this.advancedCache(1, PESSIMISTIC_CACHE);
                this.tm((Cache<?, ?>)cache2).begin();
                try {
                    Object value = cache2.withFlags(Flag.FORCE_WRITE_LOCK).get((Object)KEY);
                    AssertJUnit.assertEquals((Object)VALUE1, (Object)value);
                    cache2.withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)KEY, VALUE2);
                }
                finally {
                    this.tm((Cache<?, ?>)cache2).commit();
                }
            });
            Thread.sleep(10L);
            AssertJUnit.assertFalse((boolean)tx2Future.isDone());
            cache1.put((Object)KEY, (Object)VALUE1);
        }
        finally {
            this.tm((Cache<?, ?>)cache1).commit();
        }
        tx2Future.get();
        AssertJUnit.assertEquals((Object)VALUE2, (Object)cache1.get((Object)KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticPrepareAcquiresGlobalLock() throws Exception {
        Future<Void> tx2Future;
        CheckPoint checkPoint = new CheckPoint();
        Cache cache1 = this.cache(0, OPTIMISTIC_CACHE);
        this.tm(cache1).begin();
        EmbeddedTransaction tx1 = null;
        try {
            Object initialValue = cache1.put((Object)KEY, (Object)VALUE1);
            AssertJUnit.assertNull((Object)initialValue);
            tx1 = (EmbeddedTransaction)this.tm(cache1).getTransaction();
            tx1.runPrepare();
            tx2Future = this.fork(() -> {
                AdvancedCache cache2 = this.advancedCache(1, OPTIMISTIC_CACHE);
                this.tm((Cache<?, ?>)cache2).begin();
                try {
                    AssertJUnit.assertNull((Object)cache2.get((Object)KEY));
                    checkPoint.trigger("tx2_read");
                    cache2.put((Object)KEY, VALUE2);
                }
                finally {
                    this.tm((Cache<?, ?>)cache2).commit();
                }
            });
            checkPoint.awaitStrict("tx2_read", 10L, TimeUnit.SECONDS);
            Thread.sleep(10L);
            AssertJUnit.assertFalse((boolean)tx2Future.isDone());
        }
        finally {
            if (tx1 != null) {
                tx1.runCommit(false);
            }
        }
        tx2Future.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)VALUE2, (Object)cache1.get((Object)KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyTransaction() throws Exception {
        Object initialValue;
        AdvancedCache pessimisticCache1 = this.advancedCache(0, PESSIMISTIC_CACHE);
        this.tm((Cache<?, ?>)pessimisticCache1).begin();
        try {
            initialValue = pessimisticCache1.get((Object)KEY);
            AssertJUnit.assertNull((Object)initialValue);
        }
        finally {
            this.tm((Cache<?, ?>)pessimisticCache1).commit();
        }
        this.tm((Cache<?, ?>)pessimisticCache1).begin();
        try {
            initialValue = pessimisticCache1.withFlags(Flag.FORCE_WRITE_LOCK).get((Object)KEY);
            AssertJUnit.assertNull((Object)initialValue);
        }
        finally {
            this.tm((Cache<?, ?>)pessimisticCache1).commit();
        }
        AdvancedCache optimisticCache1 = this.advancedCache(0, OPTIMISTIC_CACHE);
        this.tm((Cache<?, ?>)optimisticCache1).begin();
        try {
            Object initialValue2 = optimisticCache1.get((Object)KEY);
            AssertJUnit.assertNull((Object)initialValue2);
        }
        finally {
            this.tm((Cache<?, ?>)optimisticCache1).commit();
        }
    }
}

