/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.ControlledTimeService;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheContainerStatsMBeanTest")
public class CacheContainerStatsMBeanTest
extends MultipleCacheManagersTest {
    private final String cachename = CacheContainerStatsMBeanTest.class.getName();
    private final String cachename2 = this.cachename + "2";
    private static final String JMX_DOMAIN = CacheContainerStatsMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private ControlledTimeService timeService;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.timeService = new ControlledTimeService();
        ConfigurationBuilder defaultConfig = new ConfigurationBuilder();
        GlobalConfigurationBuilder gcb1 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb1.cacheContainer().statistics(true).jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup).metrics().accurateSize(true);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(gcb1, defaultConfig, new TransportFlags());
        TestingUtil.replaceComponent((CacheContainer)cacheManager1, TimeService.class, this.timeService, true);
        cacheManager1.start();
        GlobalConfigurationBuilder gcb2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb2.cacheContainer().statistics(true).jmx().enabled(true).domain(JMX_DOMAIN + 2).mBeanServerLookup(this.mBeanServerLookup);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(gcb2, defaultConfig, new TransportFlags());
        TestingUtil.replaceComponent((CacheContainer)cacheManager2, TimeService.class, this.timeService, true);
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.REPL_SYNC).statistics().enable();
        this.defineConfigurationOnAllManagers(this.cachename, cb);
        this.defineConfigurationOnAllManagers(this.cachename2, cb);
        this.waitForClusterToForm(this.cachename);
    }

    public void testClusterStats() throws Exception {
        Cache cache1 = this.manager(0).getCache(this.cachename);
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName nodeStats = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN, "DefaultCacheManager", "CacheContainerStats");
        mBeanServer.setAttribute(nodeStats, new Attribute("StatisticsEnabled", Boolean.TRUE));
        cache1.put((Object)"a1", (Object)"b1");
        cache1.put((Object)"a2", (Object)"b2");
        cache1.put((Object)"a3", (Object)"b3");
        cache1.put((Object)"a4", (Object)"b4");
        this.assertAttributeValue(mBeanServer, nodeStats, "NumberOfEntries", 4L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Stores", 4L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Evictions", 0L);
        this.assertAttributeValueGreaterThanOrEqual(mBeanServer, nodeStats, "AverageWriteTime", 0L);
        cache1.remove((Object)"a1");
        this.timeService.advance(1000L);
        this.assertAttributeValue(mBeanServer, nodeStats, "RemoveHits", 1L);
        Cache cache3 = this.manager(0).getCache(this.cachename2);
        cache3.put((Object)"a10", (Object)"b1");
        cache3.put((Object)"a11", (Object)"b2");
        cache3.put((Object)"a12", (Object)"b3");
        cache3.put((Object)"a13", (Object)"b4");
        this.timeService.advance(1000L);
        this.assertAttributeValue(mBeanServer, nodeStats, "NumberOfEntries", 7L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Stores", 8L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Evictions", 0L);
        this.assertAttributeValueGreaterThanOrEqual(mBeanServer, nodeStats, "AverageWriteTime", 0L);
    }

    public void testClusterStatsDisabled() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName nodeStats = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN, "DefaultCacheManager", "CacheContainerStats");
        mBeanServer.setAttribute(nodeStats, new Attribute("StatisticsEnabled", Boolean.FALSE));
        this.assertAttributeValue(mBeanServer, nodeStats, "NumberOfEntries", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "AverageReadTime", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "AverageRemoveTime", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "AverageWriteTime", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Stores", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Evictions", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Hits", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "Misses", -1L);
        this.assertAttributeValue(mBeanServer, nodeStats, "RemoveHits", -1L);
    }

    private void assertAttributeValue(MBeanServer mBeanServer, ObjectName oName, String attrName, long expectedValue) throws Exception {
        String receivedVal = mBeanServer.getAttribute(oName, attrName).toString();
        assert (Long.parseLong(receivedVal) == expectedValue) : "expecting " + expectedValue + " for " + attrName + ", but received " + receivedVal;
    }

    private void assertAttributeValueGreaterThanOrEqual(MBeanServer mBeanServer, ObjectName oName, String attrName, long valueToCompare) throws Exception {
        String receivedVal = mBeanServer.getAttribute(oName, attrName).toString();
        assert (Long.parseLong(receivedVal) >= valueToCompare) : "expecting " + receivedVal + " for " + attrName + ", to be greater than" + valueToCompare;
    }
}

