/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheLoaderAndCacheWriterInterceptorMBeanTest")
public class CacheLoaderAndCacheWriterInterceptorMBeanTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = CacheLoaderAndCacheWriterInterceptorMBeanTest.class.getName();
    private ObjectName loaderInterceptorObjName;
    private ObjectName storeInterceptorObjName;
    private DummyInMemoryStore store;
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = this.getDefaultStandaloneCacheConfig(false);
        configuration.statistics().enable().persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        globalConfiguration.cacheContainer().statistics(true).jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        this.cacheManager.defineConfiguration("test", configuration.build());
        this.cache = this.cacheManager.getCache("test");
        this.loaderInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "CacheLoader");
        this.storeInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "CacheStore");
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        return this.cacheManager;
    }

    @AfterMethod
    public void resetStats() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        mBeanServer.invoke(this.loaderInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
        mBeanServer.invoke(this.storeInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
    }

    public void testJmxOperationMetadata() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        TestingUtil.checkMBeanOperationParameterNaming(mBeanServer, this.loaderInterceptorObjName);
        TestingUtil.checkMBeanOperationParameterNaming(mBeanServer, this.storeInterceptorObjName);
    }

    public void testPutKeyValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 1, 1);
        this.cache.put((Object)"key", (Object)"value2");
        this.assertStoreAccess(0, 1, 2);
        this.store.write(MarshalledEntryUtil.create("a", "b", this.cache));
        this.cache.put((Object)"a", (Object)"c");
        this.assertStoreAccess(1, 1, 3);
        assert (this.store.loadEntry("a").getValue().equals("c"));
    }

    public void testGetValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 1, 1);
        assert (this.cache.get((Object)"key").equals("value"));
        this.assertStoreAccess(0, 1, 1);
        this.store.write(MarshalledEntryUtil.create("a", "b", this.cache));
        assert (this.cache.get((Object)"a").equals("b"));
        this.assertStoreAccess(1, 1, 1);
        assert (this.cache.get((Object)"no_such_key") == null);
        this.assertStoreAccess(1, 2, 1);
    }

    public void testRemoveValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 1, 1);
        assert (this.cache.get((Object)"key").equals("value"));
        this.assertStoreAccess(0, 1, 1);
        assert (this.cache.remove((Object)"key").equals("value"));
        this.assertStoreAccess(0, 1, 1);
        this.cache.remove((Object)"no_such_key");
        this.assertStoreAccess(0, 2, 1);
        this.store.write(MarshalledEntryUtil.create("a", "b", this.cache));
        assert (this.cache.remove((Object)"a").equals("b"));
        this.assertStoreAccess(1, 2, 1);
    }

    public void testReplaceCommand() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 1, 1);
        assert (this.cache.replace((Object)"key", (Object)"value2").equals("value"));
        this.assertStoreAccess(0, 1, 2);
        this.store.write(MarshalledEntryUtil.create("a", "b", this.cache));
        assert (this.cache.replace((Object)"a", (Object)"c").equals("b"));
        this.assertStoreAccess(1, 1, 3);
        assert (this.cache.replace((Object)"no_such_key", (Object)"c") == null);
        this.assertStoreAccess(1, 2, 3);
    }

    public void testFlagMissNotCounted() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 1, 1);
        this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)"no_such_key");
        this.assertStoreAccess(0, 1, 1);
    }

    private void assertStoreAccess(int loadsCount, int missesCount, int storeCount) throws Exception {
        this.assertLoadCount(loadsCount, missesCount);
        this.assertStoreCount(storeCount);
    }

    private void assertLoadCount(int loadsCount, int missesCount) throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        String actualLoadCount = mBeanServer.getAttribute(this.loaderInterceptorObjName, "CacheLoaderLoads").toString();
        assert (Integer.valueOf(actualLoadCount).equals(loadsCount)) : "expected " + loadsCount + " loads count and received " + actualLoadCount;
        String actualMissesCount = mBeanServer.getAttribute(this.loaderInterceptorObjName, "CacheLoaderMisses").toString();
        assert (Integer.valueOf(actualMissesCount).equals(missesCount)) : "expected " + missesCount + " misses count, and received " + actualMissesCount;
    }

    private void assertStoreCount(int count) throws Exception {
        String actualStoreCount = this.mBeanServerLookup.getMBeanServer().getAttribute(this.storeInterceptorObjName, "WritesToTheStores").toString();
        assert (Integer.valueOf(actualStoreCount).equals(count)) : "expected " + count + " store counts, but received " + actualStoreCount;
    }
}

