/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import io.reactivex.rxjava3.exceptions.Exceptions;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheMgmtInterceptorMBeanTest")
public class CacheMgmtInterceptorMBeanTest
extends SingleCacheManagerTest {
    private ObjectName mgmtInterceptor;
    private AdvancedCache<?, ?> advanced;
    private DummyInMemoryStore loader;
    private static final String JMX_DOMAIN = CacheMgmtInterceptorMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        globalConfiguration.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup).metrics().accurateSize(true);
        ConfigurationBuilder configuration = this.getDefaultStandaloneCacheConfig(false);
        configuration.memory().size(1L).persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        configuration.statistics().enable();
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        this.cacheManager.defineConfiguration("test", configuration.build());
        this.cache = this.cacheManager.getCache("test");
        this.advanced = this.cache.getAdvancedCache();
        this.mgmtInterceptor = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "Statistics");
        this.loader = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        return this.cacheManager;
    }

    @AfterMethod
    public void resetStats() throws Exception {
        this.mBeanServerLookup.getMBeanServer().invoke(this.mgmtInterceptor, "resetStatistics", new Object[0], new String[0]);
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), this.mgmtInterceptor);
    }

    public void testEviction(Method m) throws Exception {
        this.assertEvictions(0L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)TestingUtil.k(m, "1")));
        this.cache.put((Object)TestingUtil.k(m, "1"), (Object)TestingUtil.v(m, 1));
        this.cache.evict((Object)TestingUtil.k(m, "1"));
        AssertJUnit.assertTrue((String)"the entry should have been evicted", (boolean)this.loader.contains(TestingUtil.k(m, "1")));
        this.assertEvictions(1L);
        AssertJUnit.assertEquals((Object)TestingUtil.v(m, 1), (Object)this.cache.get((Object)TestingUtil.k(m, "1")));
        this.cache.put((Object)TestingUtil.k(m, "2"), (Object)TestingUtil.v(m, 2));
        this.eventuallyAssertEvictions(2L);
        AssertJUnit.assertTrue((String)"the entry should have been evicted", (boolean)this.loader.contains(TestingUtil.k(m, "1")));
    }

    public void testGetKeyValue() throws Exception {
        this.assertMisses(0L);
        this.assertHits(0L);
        AssertJUnit.assertEquals((long)0L, (long)this.advanced.getStats().getHits());
        this.assertAttributeValue("HitRatio", 0.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.assertMisses(0L);
        this.assertHits(0L);
        this.assertAttributeValue("HitRatio", 0.0f);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get((Object)"key"));
        this.assertMisses(0L);
        this.assertHits(1L);
        this.assertAttributeValue("HitRatio", 1.0f);
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key_ne"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key_ne"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key_ne"));
        this.assertMisses(3L);
        this.assertHits(1L);
        this.assertAttributeValue("HitRatio", 0.25f);
    }

    public void testStores() throws Exception {
        this.assertEvictions(0L);
        this.assertStores(0L);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStores(1L);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStores(2L);
        this.assertCurrentNumberOfEntries(1);
        this.cache.evict((Object)"key");
        this.assertCurrentNumberOfEntriesInMemory(0);
        this.assertCurrentNumberOfEntries(1);
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put("key", "value");
        toAdd.put("key2", "value2");
        this.cache.putAll(toAdd);
        this.assertStores(4L);
        TestingUtil.cleanUpDataContainerForCache(this.cache);
        this.assertCurrentNumberOfEntriesInMemory(1);
        this.assertCurrentNumberOfEntries(2);
        this.resetStats();
        toAdd = new HashMap();
        toAdd.put("key3", "value3");
        toAdd.put("key4", "value4");
        this.cache.putAll(toAdd);
        this.assertStores(2L);
        TestingUtil.cleanUpDataContainerForCache(this.cache);
        this.assertCurrentNumberOfEntriesInMemory(1);
        this.eventuallyAssertEvictions(2L);
        this.assertCurrentNumberOfEntries(4);
    }

    public void testStoresPutForExternalRead() throws Exception {
        this.assertStores(0L);
        this.cache.putForExternalRead((Object)"key", (Object)"value");
        this.assertStores(1L);
        this.cache.putForExternalRead((Object)"key", (Object)"value");
        this.assertStores(1L);
    }

    public void testStoresPutIfAbsent() throws Exception {
        this.assertStores(0L);
        this.cache.putIfAbsent((Object)"voooo", (Object)"doooo");
        this.assertStores(1L);
        this.cache.putIfAbsent((Object)"voooo", (Object)"no-doooo");
        this.assertStores(1L);
    }

    public void testRemoves() throws Exception {
        this.assertStores(0L);
        this.assertRemoveHits(0L);
        this.assertRemoveMisses(0L);
        this.cache.put((Object)"key", (Object)"value");
        this.cache.put((Object)"key2", (Object)"value2");
        this.cache.put((Object)"key3", (Object)"value3");
        this.assertStores(3L);
        this.assertRemoveHits(0L);
        this.assertRemoveMisses(0L);
        this.cache.remove((Object)"key");
        this.cache.remove((Object)"key3");
        this.cache.remove((Object)"key4");
        this.assertRemoveHits(2L);
        this.assertRemoveMisses(1L);
        this.cache.remove((Object)"key2");
        this.assertRemoveHits(3L);
        this.assertRemoveMisses(1L);
    }

    public void testGetAll() throws Exception {
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        AssertJUnit.assertEquals((long)0L, (long)this.advanced.getStats().getMisses());
        AssertJUnit.assertEquals((long)0L, (long)this.advanced.getStats().getHits());
        String hitRatioString = server.getAttribute(this.mgmtInterceptor, "HitRatio").toString();
        Float hitRatio = Float.valueOf(Float.parseFloat(hitRatioString));
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)hitRatio);
        this.cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((long)0L, (long)this.advanced.getStats().getMisses());
        AssertJUnit.assertEquals((long)0L, (long)this.advanced.getStats().getHits());
        hitRatioString = server.getAttribute(this.mgmtInterceptor, "HitRatio").toString();
        hitRatio = Float.valueOf(Float.parseFloat(hitRatioString));
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)hitRatio);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("key");
        keySet.add("key1");
        this.advanced.getAll(keySet);
        AssertJUnit.assertEquals((long)1L, (long)this.advanced.getStats().getMisses());
        AssertJUnit.assertEquals((long)1L, (long)this.advanced.getStats().getHits());
        hitRatioString = server.getAttribute(this.mgmtInterceptor, "HitRatio").toString();
        hitRatio = Float.valueOf(Float.parseFloat(hitRatioString));
        AssertJUnit.assertEquals((Object)Float.valueOf(0.5f), (Object)hitRatio);
    }

    private void eventuallyAssertAttributeValue(String attrName, float expectedValue) {
        this.eventuallyEquals(Float.valueOf(expectedValue), () -> {
            try {
                String receivedVal = this.mBeanServerLookup.getMBeanServer().getAttribute(this.mgmtInterceptor, attrName).toString();
                return Float.valueOf(Float.parseFloat(receivedVal));
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    private void assertAttributeValue(String attrName, float expectedValue) throws Exception {
        String receivedVal = this.mBeanServerLookup.getMBeanServer().getAttribute(this.mgmtInterceptor, attrName).toString();
        AssertJUnit.assertEquals((String)("expecting " + expectedValue + " for " + attrName + ", but received " + receivedVal), (Object)Float.valueOf(expectedValue), (Object)Float.valueOf(Float.parseFloat(receivedVal)));
    }

    private void eventuallyAssertEvictions(long expectedValue) {
        this.eventuallyAssertAttributeValue("Evictions", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getEvictions());
    }

    private void assertEvictions(long expectedValue) throws Exception {
        this.assertAttributeValue("Evictions", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getEvictions());
    }

    private void assertMisses(long expectedValue) throws Exception {
        this.assertAttributeValue("Misses", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getMisses());
    }

    private void assertHits(long expectedValue) throws Exception {
        this.assertAttributeValue("Hits", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getHits());
    }

    private void assertStores(long expectedValue) throws Exception {
        this.assertAttributeValue("Stores", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getStores());
    }

    private void assertRemoveHits(long expectedValue) throws Exception {
        this.assertAttributeValue("RemoveHits", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getRemoveHits());
    }

    private void assertRemoveMisses(long expectedValue) throws Exception {
        this.assertAttributeValue("RemoveMisses", expectedValue);
        AssertJUnit.assertEquals((long)expectedValue, (long)this.advanced.getStats().getRemoveMisses());
    }

    private void assertCurrentNumberOfEntries(int expectedValue) throws Exception {
        this.assertAttributeValue("NumberOfEntries", expectedValue);
        AssertJUnit.assertEquals((int)expectedValue, (int)this.advanced.getStats().getCurrentNumberOfEntries());
    }

    private void assertCurrentNumberOfEntriesInMemory(int expectedValue) throws Exception {
        this.assertAttributeValue("NumberOfEntriesInMemory", expectedValue);
        AssertJUnit.assertEquals((int)expectedValue, (int)this.advanced.getStats().getCurrentNumberOfEntriesInMemory());
    }
}

