/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.jmx.AbstractClusterMBeanTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ClusterCacheStatsMBeanTest")
public class ClusterCacheStatsMBeanTest
extends AbstractClusterMBeanTest {
    public ClusterCacheStatsMBeanTest() {
        super(ClusterCacheStatsMBeanTest.class.getName());
    }

    public void testClusterStats() throws Exception {
        Cache cache1 = this.manager(0).getCache();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName clusterStats = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "ClusterCacheStats");
        mBeanServer.setAttribute(clusterStats, new Attribute("StatisticsEnabled", false));
        assert (!((Boolean)mBeanServer.getAttribute(clusterStats, "StatisticsEnabled")).booleanValue());
        mBeanServer.setAttribute(clusterStats, new Attribute("StatisticsEnabled", true));
        assert (((Boolean)mBeanServer.getAttribute(clusterStats, "StatisticsEnabled")).booleanValue());
        long newStaleThreshold = 2999L;
        mBeanServer.setAttribute(clusterStats, new Attribute("StaleStatsThreshold", newStaleThreshold));
        this.assertAttributeValue(mBeanServer, clusterStats, "StaleStatsThreshold", newStaleThreshold);
        cache1.put((Object)"a1", (Object)"b1");
        cache1.put((Object)"a2", (Object)"b2");
        cache1.put((Object)"a3", (Object)"b3");
        cache1.put((Object)"a4", (Object)"b4");
        this.assertAttributeValue(mBeanServer, clusterStats, "HitRatio", 0.0);
        this.assertAttributeValue(mBeanServer, clusterStats, "NumberOfEntries", 4L);
        this.assertAttributeValue(mBeanServer, clusterStats, "Stores", 4L);
        this.assertAttributeValue(mBeanServer, clusterStats, "Evictions", 0L);
        cache1.remove((Object)"a1");
        cache1.get((Object)"a1");
        cache1.get((Object)"a2");
        TestingUtil.sleepThread(4000L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "AverageWriteTime", 0L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "AverageReadTime", 0L);
        this.assertAttributeValueGreaterThanOrEqualTo(mBeanServer, clusterStats, "AverageRemoveTime", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "HitRatio", 0.5);
        this.assertAttributeValue(mBeanServer, clusterStats, "RemoveHits", 1L);
        this.assertAttributeValue(mBeanServer, clusterStats, "RemoveMisses", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "NumberOfLocksAvailable", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "NumberOfLocksHeld", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "Activations", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "Passivations", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "Invalidations", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "CacheLoaderLoads", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "CacheLoaderMisses", 0L);
        this.assertAttributeValue(mBeanServer, clusterStats, "StoreWrites", 0L);
    }
}

