/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.HealthJmxTest")
public class HealthJmxTest
extends MultipleCacheManagersTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder()).defineConfiguration("test", this.getConfigurationBuilder().build());
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(false).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return cb;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String rackId) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(gcb, this.getClass().getSimpleName(), this.mBeanServerLookup);
        gcb.transport().rackId(rackId);
        return gcb;
    }

    public void testHealthCheckAPI() throws Exception {
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("test").put((Object)"1", (Object)"1");
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        String domain0 = this.manager(0).getCacheManagerConfiguration().jmx().domain();
        ObjectName healthAPI0 = TestingUtil.getCacheManagerObjectName(domain0, "DefaultCacheManager", "CacheContainerHealth");
        Object numberOfCpus = mBeanServer.getAttribute(healthAPI0, "NumberOfCpus");
        Object totalMemoryKb = mBeanServer.getAttribute(healthAPI0, "TotalMemoryKb");
        Object freeMemoryKb = mBeanServer.getAttribute(healthAPI0, "FreeMemoryKb");
        Object clusterHealth = mBeanServer.getAttribute(healthAPI0, "ClusterHealth");
        Object clusterName = mBeanServer.getAttribute(healthAPI0, "ClusterName");
        Object numberOfNodes = mBeanServer.getAttribute(healthAPI0, "NumberOfNodes");
        Object cacheHealth = mBeanServer.getAttribute(healthAPI0, "CacheHealth");
        Assert.assertTrue(((Integer)numberOfCpus > 0 ? 1 : 0) != 0);
        Assert.assertTrue(((Long)totalMemoryKb > 0L ? 1 : 0) != 0);
        Assert.assertTrue(((Long)freeMemoryKb > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)clusterHealth), (String)HealthStatus.HEALTHY.toString());
        Assert.assertEquals((String)((String)clusterName), (String)TestResourceTracker.getCurrentTestName());
        Assert.assertEquals((int)((Integer)numberOfNodes), (int)1);
        Assert.assertEquals((String)((String[])cacheHealth)[0], (String)"test");
        Assert.assertEquals((String)((String[])cacheHealth)[1], (String)HealthStatus.HEALTHY.toString());
    }
}

