/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.distribution.MagicKey;
import org.infinispan.jmx.AbstractClusterMBeanTest;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.DelayedMarshallingPojo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.RpcManagerMBeanTest")
public class RpcManagerMBeanTest
extends AbstractClusterMBeanTest {
    public RpcManagerMBeanTest() {
        super(RpcManagerMBeanTest.class.getSimpleName());
    }

    public void testJmxOperationMetadata() throws Exception {
        ObjectName rpcManager = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), rpcManager);
    }

    public void testEnableJmxStats() throws Exception {
        Cache cache1 = this.manager(0).getCache();
        Cache cache2 = this.manager(1).getCache();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        ObjectName rpcManager2 = TestingUtil.getCacheObjectName(this.jmxDomain2, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        assert (mBeanServer.isRegistered(rpcManager1));
        assert (mBeanServer.isRegistered(rpcManager2));
        Object statsEnabled = mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled");
        assert (statsEnabled != null);
        Assert.assertEquals((Object)statsEnabled, (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager2, "StatisticsEnabled"), (Object)Boolean.TRUE);
        long initialReplicationCount1 = (Long)mBeanServer.getAttribute(rpcManager1, "ReplicationCount");
        cache1.put((Object)"key", (Object)"value2");
        Assert.assertEquals((String)((String)cache2.get((Object)"key")), (String)"value2");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)(initialReplicationCount1 + 1L));
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.invoke(rpcManager1, "resetStatistics", new Object[0], new String[0]);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.FALSE));
        cache1.put((Object)"key", (Object)"value");
        Assert.assertEquals((String)((String)cache2.get((Object)"key")), (String)"value");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)-1L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)-1L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testEnableJmxStats"})
    public void testSuccessRatio() throws Exception {
        Cache cache1 = this.manager(0).getCache();
        Cache cache2 = this.manager(1).getCache();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"N/A");
        cache1.put((Object)new MagicKey("a1", cache1), (Object)new DelayedMarshallingPojo(50, 0));
        cache1.put((Object)new MagicKey("a2", cache2), (Object)new DelayedMarshallingPojo(50, 0));
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)2L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"100%");
        Object avgReplTime = mBeanServer.getAttribute(rpcManager1, "AverageReplicationTime");
        Assert.assertNotEquals((Object)avgReplTime, (Object)0L);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = rpcManager.getTransport();
        try {
            Address mockAddress1 = (Address)Mockito.mock(Address.class);
            Address mockAddress2 = (Address)Mockito.mock(Address.class);
            ArrayList<Address> memberList = new ArrayList<Address>(2);
            memberList.add(mockAddress1);
            memberList.add(mockAddress2);
            Transport transport = (Transport)Mockito.mock(Transport.class);
            Mockito.when((Object)transport.getMembers()).thenReturn(memberList);
            Mockito.when((Object)transport.getAddress()).thenReturn((Object)mockAddress1);
            Mockito.when((Object)transport.invokeCommand((Address)ArgumentMatchers.any(Address.class), (ReplicableCommand)ArgumentMatchers.any(ReplicableCommand.class), (ResponseCollector)ArgumentMatchers.any(ResponseCollector.class), (DeliverOrder)ArgumentMatchers.any(DeliverOrder.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(new Throwable[]{new RuntimeException()});
            Mockito.when((Object)transport.invokeCommandOnAll(ArgumentMatchers.anyCollection(), (ReplicableCommand)ArgumentMatchers.any(ReplicableCommand.class), (ResponseCollector)ArgumentMatchers.any(ResponseCollector.class), (DeliverOrder)ArgumentMatchers.any(DeliverOrder.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(new Throwable[]{new RuntimeException()});
            rpcManager.setTransport(transport);
            Exceptions.expectException(CacheException.class, () -> cache1.put((Object)new MagicKey("a3", cache1), (Object)"b3"));
            Exceptions.expectException(CacheException.class, () -> cache1.put((Object)new MagicKey("a4", cache2), (Object)"b4"));
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"50%");
        }
        finally {
            rpcManager.setTransport(originalTransport);
        }
    }
}

