/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.TxInterceptorMBeanTest")
public class TxInterceptorMBeanTest
extends MultipleCacheManagersTest {
    private static final String JMX_DOMAIN = TxInterceptorMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private ObjectName txInterceptor;
    private ObjectName txInterceptor2;
    private TransactionManager tm;
    private Cache<String, String> cache1;
    private Cache<String, String> cache2;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalBuilder, JMX_DOMAIN, this.mBeanServerLookup);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(globalBuilder, new ConfigurationBuilder());
        this.registerCacheManager(new CacheContainer[]{cacheManager1});
        GlobalConfigurationBuilder globalBuilder2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder2.cacheManagerName("SecondDefaultCacheManager");
        TestCacheManagerFactory.configureJmx(globalBuilder2, JMX_DOMAIN + 2, this.mBeanServerLookup);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(globalBuilder2, new ConfigurationBuilder());
        this.registerCacheManager(new CacheContainer[]{cacheManager2});
        ConfigurationBuilder configuration = TxInterceptorMBeanTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configuration.statistics().enable();
        cacheManager1.defineConfiguration("test", configuration.build());
        cacheManager2.defineConfiguration("test", configuration.build());
        this.cache1 = cacheManager1.getCache("test");
        this.cache2 = cacheManager2.getCache("test");
        this.txInterceptor = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(repl_sync)", "Transactions");
        this.txInterceptor2 = TestingUtil.getCacheObjectName(JMX_DOMAIN + 2, "test(repl_sync)", "Transactions", "SecondDefaultCacheManager");
        this.tm = TestingUtil.getTransactionManager(this.cache1);
    }

    @AfterMethod
    public void resetStats() throws Exception {
        TestingUtil.getMBeanServer(this.cache1).invoke(this.txInterceptor, "resetStatistics", new Object[0], new String[0]);
        TestingUtil.getMBeanServer(this.cache2).invoke(this.txInterceptor2, "resetStatistics", new Object[0], new String[0]);
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(TestingUtil.getMBeanServer(this.cache1), this.txInterceptor);
    }

    public void testCommit() throws Exception {
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.tm.begin();
        this.tm.getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.cache1.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.tm.commit();
        this.assertCommitRollback(1, 0, this.cache1, this.txInterceptor);
    }

    public void testRollback() throws Exception {
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.cache1.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.cache1, this.txInterceptor);
        this.tm.rollback();
        this.assertCommitRollback(0, 1, this.cache1, this.txInterceptor);
    }

    public void testRemoteCommit() throws Exception {
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.tm.getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        this.cache2.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.tm.commit();
        this.assertCommitRollback(1, 0, this.cache2, this.txInterceptor2);
    }

    public void testRemoteRollback() throws Exception {
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.cache2.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.cache2, this.txInterceptor2);
        this.tm.rollback();
        this.assertCommitRollback(0, 1, this.cache2, this.txInterceptor2);
    }

    private void assertCommitRollback(int commit, int rollback, Cache<String, String> cache, ObjectName objectName) throws Exception {
        MBeanServer mBeanServer = TestingUtil.getMBeanServer(cache);
        Long commitCount = (Long)mBeanServer.getAttribute(objectName, "Commits");
        AssertJUnit.assertEquals((String)("expecting " + commit + " commits, received " + commitCount), (int)commit, (int)commitCount.intValue());
        Long rollbackCount = (Long)mBeanServer.getAttribute(objectName, "Rollbacks");
        AssertJUnit.assertEquals((String)("expecting " + rollback + " rollbacks, received " + rollbackCount), (int)rollback, (int)rollbackCount.intValue());
    }
}

