/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="lock.APIDistTest", groups={"functional"})
@CleanupAfterMethod
public class APIDistTest
extends MultipleCacheManagersTest {
    MagicKey key;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, this.createConfig(), 2);
        this.waitForClusterToForm();
        this.key = new MagicKey("Key mapped to Cache2", this.cache(1));
    }

    protected ConfigurationBuilder createConfig() {
        ConfigurationBuilder cfg = APIDistTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        cfg.transaction().lockingMode(LockingMode.PESSIMISTIC).clustering().l1().disable().hash().numOwners(1).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        return cfg;
    }

    public void testLockAndGet() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        log.trace((Object)"About to lock");
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        log.trace((Object)"About to get");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        this.tm(0).rollback();
    }

    public void testLockAndGetAndPut() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        String old = (String)cache1.put((Object)this.key, (Object)"new_value");
        assert ("v".equals(old)) : "Expected v, was " + old;
        log.trace((Object)"Before commit!");
        this.tm(0).commit();
        AssertJUnit.assertEquals((String)("Could not find key " + this.key + " on cache 1."), (String)"new_value", (String)((String)cache1.get((Object)this.key)));
        AssertJUnit.assertEquals((String)("Could not find key " + this.key + " on cache 2."), (String)"new_value", (String)((String)cache2.get((Object)this.key)));
    }

    public void testLockAndPutRetval() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        String old = (String)cache1.put((Object)this.key, (Object)"new_value");
        assert ("v".equals(old)) : "Expected v, was " + old;
        this.tm(0).commit();
        AssertJUnit.assertEquals((String)("Could not find key " + this.key + " on cache 1."), (String)"new_value", (String)((String)cache1.get((Object)this.key)));
        AssertJUnit.assertEquals((String)("Could not find key " + this.key + " on cache 2."), (String)"new_value", (String)((String)cache2.get((Object)this.key)));
    }

    public void testLockAndRemoveRetval() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        String old = (String)cache1.remove((Object)this.key);
        assert ("v".equals(old)) : "Expected v, was " + old;
        this.tm(0).commit();
        AssertJUnit.assertNull((String)("Could not find key " + this.key + " on cache 1."), (Object)cache1.get((Object)this.key));
        AssertJUnit.assertNull((String)("Could not find key " + this.key + " on cache 2."), (Object)cache2.get((Object)this.key));
    }
}

