/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ReplicatedControlledConsistentHashFactory;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="lock.APITest", groups={"functional"})
@CleanupAfterMethod
public class APITest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = APITest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        cfg.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
        cfg.transaction().lockingMode(LockingMode.PESSIMISTIC).cacheStopTimeout(0L).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createCluster(cfg, 2);
    }

    public void testProperties() {
        Properties p = new Properties();
        Object v = new Object();
        p.put("bla", v);
        Assert.assertEquals((Object)v, (Object)p.get("bla"));
        System.out.println(p.get("bla"));
    }

    public void testLockSuccess() throws Exception {
        Cache cache1 = this.cache(0);
        cache1.put((Object)"k", (Object)"v");
        this.tm(0).begin();
        assert (cache1.getAdvancedCache().lock((Object[])new String[]{"k"}));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testLockFailure() throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new String[]{"k"});
        this.tm(0).rollback();
    }

    public void testSilentLockFailure() throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        assert (!cache1.getAdvancedCache().withFlags(Flag.FAIL_SILENTLY).lock((Object[])new String[]{"k"}));
        this.tm(0).rollback();
    }

    public void testSilentLockFailureAffectsPostOperations() throws Exception {
        final Cache cache = this.cache(0);
        final TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final CountDownLatch continueLatch = new CountDownLatch(1);
        cache.put((Object)1, (Object)"v1");
        Future<Void> f1 = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                tm.begin();
                try {
                    cache.put((Object)1, (Object)"v2");
                    waitLatch.countDown();
                    continueLatch.await();
                }
                catch (Exception e) {
                    tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (tm.getStatus() == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                }
                return null;
            }
        });
        Future<Void> f2 = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                waitLatch.await();
                tm.begin();
                try {
                    AdvancedCache silentCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
                    silentCache.put((Object)1, (Object)"v3");
                    assert (!silentCache.lock((Object[])new Integer[]{1}));
                    String object = (String)cache.get((Object)1);
                    assert ("v1".equals(object)) : "Expected v1 but got " + object;
                    cache.get((Object)1);
                }
                catch (Exception e) {
                    tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (tm.getStatus() == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                    continueLatch.countDown();
                }
                return null;
            }
        });
        f1.get();
        f2.get();
    }

    public void testMultiLockSuccess() throws Exception {
        Cache cache1 = this.cache(0);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(0).begin();
        assert (cache1.getAdvancedCache().lock(Arrays.asList("k1", "k2", "k3")));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testMultiLockFailure() throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k3", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        cache1.getAdvancedCache().lock(Arrays.asList("k1", "k2", "k3"));
        this.tm(0).rollback();
    }

    public void testSilentMultiLockFailure() throws Exception {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k3", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        assert (!cache1.getAdvancedCache().withFlags(Flag.FAIL_SILENTLY).lock(Arrays.asList("k1", "k2", "k3")));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockOnNonTransactionalCache() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(false)){

            @Override
            public void call() {
                this.cm.getCache().getAdvancedCache().lock(new Object[]{"k"});
            }
        });
    }

    public void testLockingInterceptorType() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                AbstractLockingInterceptor lockingInterceptor = TestingUtil.findInterceptor(this.cm.getCache(), AbstractLockingInterceptor.class);
                Assert.assertTrue((boolean)(lockingInterceptor instanceof NonTransactionalLockingInterceptor));
            }
        });
    }
}

