/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.impl.LockContainer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.KeyLockTest")
@CleanupAfterTest
public class KeyLockTest
extends SingleCacheManagerTest {
    private static final int RETRIES = 100;

    public void testByteArrayStrippedLockTx() throws Exception {
        this.doTest(CacheName.STRIPPED_LOCK_TX);
    }

    public void testByteArrayStrippedLockNonTx() throws Exception {
        this.doTest(CacheName.STRIPPED_LOCK_NON_TX);
    }

    public void testByteArrayPerEntryLockTx() throws Exception {
        this.doTest(CacheName.PER_ENTRY_LOCK_TX);
    }

    public void testByteArrayPerEntryLockNonTx() throws Exception {
        this.doTest(CacheName.PER_ENTRY_LOCK_NON_TX);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = KeyLockTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL);
        builder.locking().lockAcquisitionTimeout(100L, TimeUnit.MILLISECONDS);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(builder);
        for (CacheName cacheName : CacheName.values()) {
            cacheName.configure(builder);
            cacheManager.defineConfiguration(cacheName.name(), builder.build());
        }
        return cacheManager;
    }

    private void doTest(CacheName cacheName) throws Exception {
        LockContainer lockContainer = TestingUtil.extractComponent(this.cache(cacheName.name()), LockContainer.class);
        Object lockOwner = new Object();
        try {
            lockContainer.acquire((Object)KeyLockTest.byteArray(), lockOwner, 10L, TimeUnit.MILLISECONDS).lock();
        }
        catch (InterruptedException | TimeoutException e) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertTrue((boolean)lockContainer.isLocked((Object)KeyLockTest.byteArray()));
        this.fork(() -> {
            for (int i = 0; i < 100; ++i) {
                AssertJUnit.assertTrue((boolean)lockContainer.isLocked((Object)KeyLockTest.byteArray()));
                try {
                    lockContainer.acquire((Object)KeyLockTest.byteArray(), new Object(), 10L, TimeUnit.MILLISECONDS).lock();
                    AssertJUnit.fail();
                    continue;
                }
                catch (InterruptedException | TimeoutException throwable) {
                    // empty catch block
                }
            }
            return null;
        }).get(10L, TimeUnit.SECONDS);
    }

    private static WrappedByteArray byteArray() {
        return new WrappedByteArray(new byte[]{1});
    }

    private static enum CacheName {
        STRIPPED_LOCK_TX{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(true);
                builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
            }
        }
        ,
        STRIPPED_LOCK_NON_TX{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(true);
                builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
            }
        }
        ,
        PER_ENTRY_LOCK_TX{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(false);
                builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
            }
        }
        ,
        PER_ENTRY_LOCK_NON_TX{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(false);
                builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
            }
        };


        abstract void configure(ConfigurationBuilder var1);
    }
}

