/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.L1LockTest")
public class L1LockTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = L1LockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        config.clustering().hash().numOwners(1).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.createCluster(TestDataSCI.INSTANCE, config, 2);
        this.waitForClusterToForm();
    }

    public void testConsistency() throws Exception {
        Object localKey = this.getKeyForCache(0);
        this.cache(0).put(localKey, (Object)"foo");
        this.assertNotLocked(localKey);
        AssertJUnit.assertEquals((Object)"foo", (Object)this.cache(0).get(localKey));
        this.assertNotLocked(localKey);
        log.trace((Object)"About to perform 2nd get...");
        AssertJUnit.assertEquals((Object)"foo", (Object)this.cache(1).get(localKey));
        this.assertNotLocked(localKey);
        this.cache(0).put(localKey, (Object)"foo2");
        this.assertNotLocked(localKey);
        AssertJUnit.assertEquals((Object)"foo2", (Object)this.cache(0).get(localKey));
        AssertJUnit.assertEquals((Object)"foo2", (Object)this.cache(1).get(localKey));
        this.cache(1).put(localKey, (Object)"foo3");
        AssertJUnit.assertEquals((Object)"foo3", (Object)this.cache(0).get(localKey));
        AssertJUnit.assertEquals((Object)"foo3", (Object)this.cache(1).get(localKey));
    }
}

