/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.infinispan.util.concurrent.locks.impl.PerKeyLockContainer;
import org.infinispan.util.concurrent.locks.impl.StripedLockContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.LockManagerTest")
public class LockManagerTest
extends AbstractInfinispanTest {
    private final ExecutorService asyncExecutor = new WithinThreadExecutor();
    private final ScheduledExecutorService mockScheduledExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);

    public LockManagerTest() {
        ScheduledFuture future = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when((Object)future.cancel(ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when(this.mockScheduledExecutor.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)future);
        Mockito.when(this.mockScheduledExecutor.schedule((Callable)ArgumentMatchers.any(Callable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)future);
    }

    public void testSingleCounterPerKey() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        PerKeyLockContainer lockContainer = new PerKeyLockContainer();
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, TestingUtil.named("org.infinispan.executors.non-blocking", this.asyncExecutor), TestingUtil.named("org.infinispan.executors.timeout", this.mockScheduledExecutor));
        this.doSingleCounterTest((LockManager)lockManager);
    }

    public void testSingleCounterStripped() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        StripedLockContainer lockContainer = new StripedLockContainer(16);
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, this.asyncExecutor, this.mockScheduledExecutor);
        this.doSingleCounterTest((LockManager)lockManager);
    }

    public void testMultipleCounterPerKey() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        PerKeyLockContainer lockContainer = new PerKeyLockContainer();
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, this.asyncExecutor, this.mockScheduledExecutor);
        this.doMultipleCounterTest((LockManager)lockManager);
    }

    public void testMultipleCounterStripped() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        StripedLockContainer lockContainer = new StripedLockContainer(16);
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, this.asyncExecutor, this.mockScheduledExecutor);
        this.doMultipleCounterTest((LockManager)lockManager);
    }

    public void testTimeoutPerKey() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        PerKeyLockContainer lockContainer = new PerKeyLockContainer();
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, this.asyncExecutor, this.mockScheduledExecutor);
        this.doTestWithFailAcquisition((LockManager)lockManager);
    }

    public void testTimeoutStripped() throws ExecutionException, InterruptedException {
        DefaultLockManager lockManager = new DefaultLockManager();
        StripedLockContainer lockContainer = new StripedLockContainer(16);
        TestingUtil.inject(lockContainer, AbstractCacheTest.TIME_SERVICE);
        TestingUtil.inject(lockManager, lockContainer, this.asyncExecutor, this.mockScheduledExecutor);
        this.doTestWithFailAcquisition((LockManager)lockManager);
    }

    private void doSingleCounterTest(LockManager lockManager) throws ExecutionException, InterruptedException {
        NotThreadSafeCounter counter = new NotThreadSafeCounter();
        String key = "key";
        int numThreads = 8;
        int maxCounterValue = 100;
        CyclicBarrier barrier = new CyclicBarrier(8);
        ArrayList<Future<Collection>> callableResults = new ArrayList<Future<Collection>>(8);
        for (int i = 0; i < 8; ++i) {
            callableResults.add(this.fork(() -> {
                Thread lockOwner = Thread.currentThread();
                AssertJUnit.assertEquals((int)0, (int)counter.getCount());
                LinkedList<Integer> seenValues = new LinkedList<Integer>();
                barrier.await();
                while (true) {
                    lockManager.lock((Object)"key", (Object)lockOwner, 1L, TimeUnit.MINUTES).lock();
                    AssertJUnit.assertEquals((Object)lockOwner, (Object)lockManager.getOwner((Object)"key"));
                    AssertJUnit.assertTrue((boolean)lockManager.isLocked((Object)"key"));
                    AssertJUnit.assertTrue((boolean)lockManager.ownsLock((Object)"key", (Object)lockOwner));
                    try {
                        int value = counter.getCount();
                        if (value == 100) {
                            LinkedList<Integer> linkedList = seenValues;
                            return linkedList;
                        }
                        seenValues.add(value);
                        counter.setCount(value + 1);
                        continue;
                    }
                    finally {
                        lockManager.unlock((Object)"key", (Object)lockOwner);
                        continue;
                    }
                    break;
                }
            }));
        }
        HashSet<Integer> seenResults = new HashSet<Integer>();
        for (Future future : callableResults) {
            for (Integer integer : (Collection)future.get()) {
                AssertJUnit.assertTrue((boolean)seenResults.add(integer));
            }
        }
        AssertJUnit.assertEquals((int)100, (int)seenResults.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)seenResults.contains(i));
        }
        AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
    }

    private void doMultipleCounterTest(LockManager lockManager) throws ExecutionException, InterruptedException {
        int numCounters = 8;
        NotThreadSafeCounter[] counters = new NotThreadSafeCounter[8];
        String[] keys = new String[8];
        int numThreads = 8;
        int maxCounterValue = 100;
        CyclicBarrier barrier = new CyclicBarrier(8);
        for (int i = 0; i < 8; ++i) {
            counters[i] = new NotThreadSafeCounter();
            keys[i] = "key-" + i;
        }
        ArrayList<Future<Collection>> callableResults = new ArrayList<Future<Collection>>(8);
        for (int i = 0; i < 8; ++i) {
            ArrayList<String> threadKeys = new ArrayList<String>(Arrays.asList(keys));
            Collections.shuffle(threadKeys);
            callableResults.add(this.fork(() -> {
                Thread lockOwner = Thread.currentThread();
                LinkedList<Integer> seenValues = new LinkedList<Integer>();
                barrier.await();
                block4: while (true) {
                    lockManager.lockAll((Collection)threadKeys, (Object)lockOwner, 1L, TimeUnit.MINUTES).lock();
                    for (String key : threadKeys) {
                        AssertJUnit.assertEquals((Object)lockOwner, (Object)lockManager.getOwner((Object)key));
                        AssertJUnit.assertTrue((boolean)lockManager.isLocked((Object)key));
                        AssertJUnit.assertTrue((boolean)lockManager.ownsLock((Object)key, (Object)lockOwner));
                    }
                    try {
                        int value = -1;
                        NotThreadSafeCounter[] notThreadSafeCounterArray = counters;
                        int n = notThreadSafeCounterArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block4;
                            NotThreadSafeCounter counter = notThreadSafeCounterArray[n2];
                            if (value == -1) {
                                value = counter.getCount();
                                if (value == 100) {
                                    LinkedList<Integer> linkedList = seenValues;
                                    return linkedList;
                                }
                                seenValues.add(value);
                            } else {
                                AssertJUnit.assertEquals((int)value, (int)counter.getCount());
                            }
                            counter.setCount(value + 1);
                            ++n2;
                        }
                    }
                    finally {
                        lockManager.unlockAll((Collection)threadKeys, (Object)lockOwner);
                        continue;
                    }
                    break;
                }
            }));
        }
        HashSet<Integer> seenResults = new HashSet<Integer>();
        for (Future future : callableResults) {
            for (Integer integer : (Collection)future.get()) {
                AssertJUnit.assertTrue((boolean)seenResults.add(integer));
            }
        }
        AssertJUnit.assertEquals((int)100, (int)seenResults.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)seenResults.contains(i));
        }
        AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
    }

    private void doTestWithFailAcquisition(LockManager lockManager) throws InterruptedException {
        String lockOwner1 = "LO1";
        String lockOwner2 = "LO2";
        String key = "key";
        String key2 = "key2";
        String key3 = "key2";
        lockManager.lock((Object)"key", (Object)"LO1", 0L, TimeUnit.MILLISECONDS).lock();
        AssertJUnit.assertEquals((Object)"LO1", (Object)lockManager.getOwner((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.isLocked((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.ownsLock((Object)"key", (Object)"LO1"));
        try {
            lockManager.lockAll(Arrays.asList("key", "key2", "key2"), (Object)"LO2", 0L, TimeUnit.MILLISECONDS).lock();
            AssertJUnit.assertEquals((int)1, (int)lockManager.getNumberOfLocksHeld());
            AssertJUnit.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((Object)"LO1", (Object)lockManager.getOwner((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.isLocked((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.ownsLock((Object)"key", (Object)"LO1"));
        KeyAwareLockPromise lockPromise = lockManager.lockAll(Arrays.asList("key", "key2", "key2"), (Object)"LO2", 1L, TimeUnit.MINUTES);
        AssertJUnit.assertFalse((boolean)lockPromise.isAvailable());
        lockManager.unlock((Object)"key", (Object)"LO1");
        AssertJUnit.assertTrue((boolean)lockPromise.isAvailable());
        lockPromise.lock();
        AssertJUnit.assertEquals((Object)"LO2", (Object)lockManager.getOwner((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.isLocked((Object)"key"));
        AssertJUnit.assertTrue((boolean)lockManager.ownsLock((Object)"key", (Object)"LO2"));
        lockManager.unlockAll(Arrays.asList("key", "key2", "key2"), (Object)"LO2");
        AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
    }

    private static class NotThreadSafeCounter {
        private int count;

        private NotThreadSafeCounter() {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

