/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.NonTxRemoteLockTest")
public class NonTxRemoteLockTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonTxRemoteLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numOwners(1);
        builder.clustering().stateTransfer().fetchInMemoryState(false);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
    }

    public void testExceptionBeforeLockingInterceptor() {
        MagicKey key = new MagicKey(this.cache(1));
        LockManager lockManager = TestingUtil.extractLockManager(this.cache(1));
        TestingUtil.extractInterceptorChain(this.cache(1)).addInterceptorAfter((AsyncInterceptor)new ExceptionInRemotePutInterceptor(lockManager), NonTransactionalLockingInterceptor.class);
        AssertJUnit.assertFalse((boolean)lockManager.isLocked((Object)key));
        try {
            this.cache(0).put((Object)key, (Object)"foo");
            AssertJUnit.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            AssertJUnit.assertEquals((String)"Induced Exception!", (String)e.getCause().getMessage());
        }
        this.eventually(() -> !lockManager.isLocked(key));
    }

    public static class ExceptionInRemotePutInterceptor
    extends DDAsyncInterceptor {
        LockManager lockManager;

        ExceptionInRemotePutInterceptor(LockManager lockManager) {
            this.lockManager = lockManager;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (ctx.isOriginLocal()) {
                return this.invokeNext(ctx, (VisitableCommand)command);
            }
            AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(command.getKey()));
            throw new RuntimeException("Induced Exception!");
        }
    }
}

