/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractInitiatorCrashTest
extends AbstractCrashTest {
    public AbstractInitiatorCrashTest(CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        super(cacheMode, lockingMode, useSynchronization);
    }

    public void testInitiatorCrashesBeforeReleasingLock() throws Exception {
        CountDownLatch releaseLocksLatch = new CountDownLatch(1);
        this.skipTxCompletion(this.advancedCache(1), releaseLocksLatch);
        Object k = this.getKeyForCache(2);
        Future<Void> future = this.beginAndCommitTx(k, 1);
        releaseLocksLatch.await(30L, TimeUnit.SECONDS);
        assert (this.checkTxCount(0, 0, 1));
        this.eventuallyEquals(0, () -> this.getLocalTxCount(1));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.assertEventuallyNotLocked(this.cache(0), k);
        this.assertEventuallyNotLocked(this.cache(1), k);
        this.assertLocked(this.cache(2), k);
        this.killMember(1);
        this.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
        this.assertNotLocked(k);
        future.get(30L, TimeUnit.SECONDS);
    }

    public void testInitiatorNodeCrashesBeforeCommit() throws Exception {
        Object k = this.getKeyForCache(2);
        this.tm(1).begin();
        this.cache(1).put(k, (Object)"v");
        EmbeddedTransaction transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
        transaction.runPrepare();
        this.tm(1).suspend();
        this.assertEventuallyNotLocked(this.cache(0), k);
        this.assertEventuallyNotLocked(this.cache(1), k);
        this.assertLocked(this.cache(2), k);
        this.checkTxCount(0, 0, 1);
        this.checkTxCount(1, 1, 0);
        this.checkTxCount(2, 0, 1);
        this.killMember(1);
        this.assertNotLocked(k);
        this.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
    }
}

